/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.cwriter.StatementVisitor;
import org.sosy_lab.cpachecker.util.cwriter.StatementWriter;
import org.sosy_lab.cpachecker.util.cwriter.TranslatorConfig;

public abstract class Statement {
    private static int gotoCounter = 0;
    private boolean isGotoTarget = false;
    private String gotoLabel = null;

    public abstract <E extends Exception> void accept(StatementVisitor<E> var1) throws E;

    public Optional<String> getLabelIfUsed() {
        if (!this.isGotoTarget) {
            return Optional.empty();
        }
        return Optional.of(this.gotoLabel);
    }

    private static String getNewLabelName() {
        String label = "label_" + gotoCounter;
        ++gotoCounter;
        return label;
    }

    public String getLabel() {
        if (!this.isGotoTarget) {
            this.gotoLabel = Statement.getNewLabelName();
            this.isGotoTarget = true;
        }
        return this.gotoLabel;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        StatementWriter w = null;
        try {
            w = StatementWriter.getWriter(sb, TranslatorConfig.getDefault());
            this.accept(w);
        }
        catch (IOException pE) {
            throw new AssertionError("IOException should not be possible for StringBuilder", pE);
        }
        return sb.toString();
    }

    static class EmptyStatement
    extends Statement {
        EmptyStatement() {
        }

        @Override
        public <E extends Exception> void accept(StatementVisitor<E> pVisitor) throws E {
            pVisitor.visit(this);
        }
    }

    static class Label
    extends Statement {
        private final String name;

        public Label(String pLabelName) {
            this.name = pLabelName;
        }

        @Override
        public <E extends Exception> void accept(StatementVisitor<E> pVisitor) throws E {
            pVisitor.visit(this);
        }

        @Override
        public String getLabel() {
            return this.name;
        }

        @Override
        public Optional<String> getLabelIfUsed() {
            return Optional.of(this.name);
        }
    }

    static class FunctionDefinition
    extends Statement {
        private final String functionHeader;
        private final CompoundStatement functionBody;

        public FunctionDefinition(String pFunctionHeader, CompoundStatement pFunctionBody) {
            this.functionHeader = pFunctionHeader;
            this.functionBody = pFunctionBody;
        }

        @Override
        public <E extends Exception> void accept(StatementVisitor<E> pVisitor) throws E {
            pVisitor.visit(this);
        }

        public String getFunctionHeader() {
            return this.functionHeader;
        }

        public CompoundStatement getFunctionBody() {
            return this.functionBody;
        }
    }

    static class SimpleStatement
    extends Statement {
        private final String code;
        private final CFAEdge origin;

        public SimpleStatement(String pCode) {
            this(null, pCode);
        }

        public SimpleStatement(CFAEdge pOrigin, String pCode) {
            this.origin = pOrigin;
            this.code = pCode;
        }

        @Override
        public <E extends Exception> void accept(StatementVisitor<E> pVisitor) throws E {
            pVisitor.visit(this);
        }

        public Optional<CFAEdge> getOrigin() {
            return Optional.ofNullable(this.origin);
        }

        public String getCode() {
            return this.code;
        }
    }

    static class CompoundStatement
    extends Statement {
        private final List<Statement> statements = new ArrayList<Statement>();
        private final CompoundStatement outerBlock;

        public CompoundStatement() {
            this(null);
        }

        public CompoundStatement(CompoundStatement pOuterBlock) {
            this.outerBlock = pOuterBlock;
        }

        public void addStatement(Statement statement) {
            this.statements.add(statement);
        }

        @Override
        public <E extends Exception> void accept(StatementVisitor<E> pVisitor) throws E {
            pVisitor.visit(this);
        }

        public ImmutableList<Statement> getStatements() {
            return ImmutableList.copyOf(this.statements);
        }

        public CompoundStatement getSurroundingBlock() {
            return this.outerBlock;
        }

        public boolean isEmpty() {
            return this.statements.isEmpty();
        }

        public Statement getLast() {
            return this.statements.get(this.statements.size() - 1);
        }
    }

    static class InlinedFunction
    extends CompoundStatement {
        public InlinedFunction(CompoundStatement pOuterBlock) {
            super(pOuterBlock);
        }
    }
}

