/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.common.base.Preconditions;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import org.sosy_lab.cpachecker.util.cwriter.ARGToCTranslator;
import org.sosy_lab.cpachecker.util.cwriter.Statement;
import org.sosy_lab.cpachecker.util.cwriter.StatementVisitor;
import org.sosy_lab.cpachecker.util.cwriter.StatementWriterWithMetadata;
import org.sosy_lab.cpachecker.util.cwriter.TranslatorConfig;

public class StatementWriter
implements StatementVisitor<IOException>,
Closeable {
    private final Appendable sb;
    private int currentIndent = 0;
    private boolean closed = false;

    protected StatementWriter(Appendable pDestination, TranslatorConfig pConfig) throws IOException {
        this.sb = pDestination;
        if (pConfig.doIncludeHeader()) {
            this.sb.append("#include <stdio.h>\n");
        }
        if (pConfig.doIncludeHeader() || pConfig.getTargetStrategy() == ARGToCTranslator.TargetTreatment.ASSERTFALSE) {
            this.sb.append("#include <assert.h>\n");
        }
        switch (pConfig.getTargetStrategy()) {
            case VERIFIERERROR: {
                this.sb.append("extern void reach_error();\n");
                break;
            }
            case REACHASMEMSAFETY: {
                this.sb.append("#include <stdlib.h>\n");
                break;
            }
        }
        this.sb.append("extern void __VERIFIER_assume();\n");
        this.sb.append("extern _Bool __VERIFIER_nondet_bool();\n");
    }

    public static StatementWriter getWriter(Appendable pDestination, TranslatorConfig pConfig) throws IOException {
        if (pConfig.getMetadataOutput() != null) {
            return new StatementWriterWithMetadata(pDestination, pConfig.getMetadataOutput(), pConfig);
        }
        return new StatementWriter(pDestination, pConfig);
    }

    public void write(String pString) throws IOException {
        this.sb.append(pString).append("\n");
    }

    private void addIndent() throws IOException {
        for (int i = 0; i < this.currentIndent; ++i) {
        }
        this.sb.append(" ");
    }

    private void increaseIndent() {
        Preconditions.checkState((this.currentIndent >= 0 ? 1 : 0) != 0);
        this.currentIndent += 4;
        Preconditions.checkState((this.currentIndent >= 0 ? 1 : 0) != 0);
    }

    private void decreaseIndent() {
        Preconditions.checkState((this.currentIndent >= 0 ? 1 : 0) != 0);
        this.currentIndent -= 4;
        Preconditions.checkState((this.currentIndent >= 0 ? 1 : 0) != 0);
    }

    private void addLabelIfNecessary(Statement pS) throws IOException {
        Optional<String> label = pS.getLabelIfUsed();
        if (label.isPresent()) {
            this.sb.append(label.orElseThrow()).append(":;\n");
        }
    }

    @Override
    public void visit(Statement.SimpleStatement pS) throws IOException {
        this.addLabelIfNecessary(pS);
        this.addIndent();
        this.sb.append(pS.getCode());
        this.sb.append("\n");
    }

    @Override
    public void visit(Statement.Label pS) throws IOException {
        this.addIndent();
        this.sb.append(pS.getLabel()).append(":;");
    }

    @Override
    public void visit(Statement.FunctionDefinition pS) throws IOException {
        this.addLabelIfNecessary(pS);
        this.addIndent();
        this.sb.append(pS.getFunctionHeader()).append("\n");
        pS.getFunctionBody().accept(this);
        this.sb.append("\n");
    }

    @Override
    public void visit(Statement.EmptyStatement pS) throws IOException {
        this.addLabelIfNecessary(pS);
    }

    @Override
    public void visit(Statement.CompoundStatement pS) throws IOException {
        this.visitCompound(pS);
    }

    private void visitCompound(Statement.CompoundStatement pS) throws IOException {
        this.addLabelIfNecessary(pS);
        this.addIndent();
        this.sb.append("{\n");
        for (Statement statement : pS.getStatements()) {
            int indentBefore = this.currentIndent;
            this.increaseIndent();
            statement.accept(this);
            this.decreaseIndent();
            Preconditions.checkState((this.currentIndent == indentBefore ? 1 : 0) != 0);
        }
        this.addIndent();
        this.sb.append("}\n");
    }

    @Override
    public void visit(Statement.InlinedFunction pS) throws IOException {
        this.visitCompound(pS);
    }

    @Override
    public void close() throws IOException {
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        this.closed = true;
    }
}

