/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Closeable;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Optional;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.cwriter.Statement;
import org.sosy_lab.cpachecker.util.cwriter.StatementVisitor;
import org.sosy_lab.cpachecker.util.cwriter.StatementWriter;
import org.sosy_lab.cpachecker.util.cwriter.TranslatorConfig;

public class StatementWriterWithMetadata
extends StatementWriter
implements StatementVisitor<IOException>,
Closeable {
    final AppendableWithLineCounter countingAppendable;
    private final Writer metadataOutput;
    private boolean entryWritten = false;

    StatementWriterWithMetadata(Appendable pDestination, Path pMetadataOutput, TranslatorConfig pConfig) throws IOException {
        this(new AppendableWithLineCounter(pDestination), IO.openOutputFile((Path)pMetadataOutput, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]), pConfig);
    }

    private StatementWriterWithMetadata(AppendableWithLineCounter pCountingAppendable, Writer pMetadataOutput, TranslatorConfig pConfig) throws IOException {
        super(pCountingAppendable, pConfig);
        this.countingAppendable = pCountingAppendable;
        this.metadataOutput = pMetadataOutput;
        this.metadataOutput.write(this.getJsonTemplate());
    }

    @Override
    public void write(String pString) throws IOException {
        int before = this.countingAppendable.getLineCount();
        super.write(pString);
        int after = this.countingAppendable.getLineCount();
        assert (after > before);
    }

    private String getJsonTemplate() {
        return "[";
    }

    private String getJsonForMapping(FileLocation origin, int newStartingLineNumber, int newEndingLineNumber) {
        int originalStartingLineNumber = origin.getStartingLineNumber();
        int originalEndingLineNumber = origin.getEndingLineNumber();
        Object prefix = "";
        if (this.entryWritten) {
            prefix = ",";
        } else {
            assert (!this.entryWritten);
            this.entryWritten = true;
        }
        prefix = (String)prefix + "\n";
        return (String)prefix + String.format("{%n  \"startingLineNumber\": %s,%n  \"endingLineNumber\": %s,%n  \"metadata\": {%n    \"originalStartingLineNumber\": %s,%n    \"originalEndingLineNumber\": %s%n  }%n}", newStartingLineNumber, newEndingLineNumber, originalStartingLineNumber, originalEndingLineNumber);
    }

    @Override
    public void visit(Statement.SimpleStatement pS) throws IOException {
        int startingLineNumber = this.countingAppendable.getLineCount();
        super.visit(pS);
        int endlingLineNumber = this.countingAppendable.getLineCount() - 1;
        assert (endlingLineNumber >= startingLineNumber);
        Optional<CFAEdge> edge = pS.getOrigin();
        if (edge.isPresent()) {
            String json = this.getJsonForMapping(edge.orElseThrow().getFileLocation(), startingLineNumber, endlingLineNumber);
            this.metadataOutput.write(json);
        }
    }

    @Override
    public void visit(Statement.Label pS) throws IOException {
        super.visit(pS);
    }

    @Override
    public void visit(Statement.FunctionDefinition pS) throws IOException {
        super.visit(pS);
    }

    @Override
    public void visit(Statement.EmptyStatement pS) throws IOException {
        super.visit(pS);
    }

    @Override
    public void visit(Statement.CompoundStatement pS) throws IOException {
        super.visit(pS);
    }

    @Override
    public void visit(Statement.InlinedFunction pS) throws IOException {
        super.visit(pS);
    }

    @Override
    public void close() throws IOException {
        this.metadataOutput.write("]\n");
        this.metadataOutput.close();
        super.close();
    }

    private static class AppendableWithLineCounter
    implements Appendable {
        private final Appendable delegate;
        private int lineCount = 1;

        public AppendableWithLineCounter(Appendable pDelegate) {
            this.delegate = pDelegate;
        }

        public int getLineCount() {
            return this.lineCount;
        }

        @Override
        @CanIgnoreReturnValue
        public Appendable append(CharSequence csq) throws IOException {
            if (csq.toString().contains("\n")) {
                for (int i = 0; i < csq.length(); ++i) {
                    if (csq.charAt(i) != '\n') continue;
                    ++this.lineCount;
                }
            }
            this.delegate.append(csq);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Appendable append(CharSequence csq, int start, int end) throws IOException {
            if (csq.toString().contains("\n")) {
                for (int i = 0; i < csq.length(); ++i) {
                    if (csq.charAt(i) != '\n') continue;
                    ++this.lineCount;
                }
            }
            this.delegate.append(csq, start, end);
            return this;
        }

        @Override
        @CanIgnoreReturnValue
        public Appendable append(char c) throws IOException {
            if (c == '\n') {
                ++this.lineCount;
            }
            this.delegate.append(c);
            return this;
        }
    }
}

