/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter;

import java.nio.file.Path;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.cpachecker.util.cwriter.ARGToCTranslator;

@Options(prefix="cpa.arg.export.code")
public class TranslatorConfig {
    @Option(secure=true, name="header", description="write include directives")
    private boolean includeHeader = true;
    @Option(secure=true, name="blockAtFunctionEnd", description="Only enable CLOSEFUNCTIONBLOCK if you are sure that the ARG merges different flows through a function at the end of the function.")
    private ARGToCTranslator.BlockTreatmentAtFunctionEnd handleCompoundStatementAtEndOfFunction = ARGToCTranslator.BlockTreatmentAtFunctionEnd.KEEPBLOCK;
    @Option(secure=true, name="handleTargetStates", description="How to deal with target states during code generation")
    private ARGToCTranslator.TargetTreatment targetStrategy = ARGToCTranslator.TargetTreatment.NONE;
    @Option(secure=true, description="Enable the integration of __VERIFIER_assume statements for non-true assumption in states. Disable if you want to create residual programs.")
    private boolean addAssumptions = true;
    @Option(secure=true, description="If specified, metadata about the produced C program will be exported to this file")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path metadataOutput = null;

    public TranslatorConfig(Configuration pConfig) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
    }

    private TranslatorConfig() {
    }

    public static TranslatorConfig getDefault() {
        return new TranslatorConfig();
    }

    public boolean doIncludeHeader() {
        return this.includeHeader;
    }

    public ARGToCTranslator.BlockTreatmentAtFunctionEnd doHandleCompoundStatementAtEndOfFunction() {
        return this.handleCompoundStatementAtEndOfFunction;
    }

    public ARGToCTranslator.TargetTreatment getTargetStrategy() {
        return this.targetStrategy;
    }

    public boolean doAddAssumptions() {
        return this.addAssumptions;
    }

    public Path getMetadataOutput() {
        return this.metadataOutput;
    }
}

