/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter.tests;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.ConfigurationBuilder;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.cpa.arg.ARGState;
import org.sosy_lab.cpachecker.util.cwriter.ARGToCTranslator;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.ToCTranslationTest;

@RunWith(value=Enclosed.class)
public final class ARGToCTranslatorTest {
    private ARGToCTranslatorTest() {
    }

    @RunWith(value=Parameterized.class)
    public static class AssumptionAutomataCombinationTest
    extends TranslationTest {
        private static final String CONFIG_FILE = "assumption-guiding.properties";
        private final Path conditionAutomaton;

        public AssumptionAutomataCombinationTest(String pTestLabel, String pProgram, boolean pVerdict, String pConditionAutomaton) throws InvalidConfigurationException, IOException {
            super(pTestLabel, pProgram, pVerdict, false);
            this.conditionAutomaton = Path.of("test/programs/programtranslation/", pConditionAutomaton);
            this.generationPropfile = CONFIG_FILE;
        }

        @Override
        protected ConfigurationBuilder getGenerationConfig(String propfile) throws InvalidConfigurationException {
            ConfigurationBuilder config = super.getGenerationConfig(propfile);
            config.setOption("AssumptionAutomaton.cpa.automaton.inputFile", this.conditionAutomaton.toString());
            return config;
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> data() {
            ImmutableList.Builder b = ImmutableList.builder();
            b.add((Object)AssumptionAutomataCombinationTest.generationTest("main.c", "AssumptionAutomaton.True.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationTest("main.c", "AssumptionAutomaton.False.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationWithChangedVerdictTest("multipleErrors.c", true, "multipleErrors.AssumptionAutomaton.noErrorReachable.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationWithChangedVerdictTest("multipleErrors.c", true, "multipleErrors.AssumptionAutomaton.safeBranchReachable.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationWithChangedVerdictTest("multipleErrors.c", false, "multipleErrors.AssumptionAutomaton.unsafeBranchReachable.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationTest("main.c", "main_additional_spec.AssumptionAutomaton.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationTest("simple.c", "simple_additional_spec.AssumptionAutomaton.txt"));
            b.add((Object)AssumptionAutomataCombinationTest.generationTest("simple2.c", "simple2_additional_spec.AssumptionAutomaton.txt"));
            return b.build();
        }

        private static Object[] generationTest(String program, String conditionAutomaton) {
            String label = String.format("generationTest(%s with %s)", program, conditionAutomaton);
            return new Object[]{label, program, true, conditionAutomaton};
        }

        private static Object[] generationWithChangedVerdictTest(String program, boolean verdict, String conditionAutomaton) {
            String label = String.format("generationWithChangedVerdictTest(%s with %s is %s)", program, conditionAutomaton, verdict);
            return new Object[]{label, program, verdict, conditionAutomaton};
        }
    }

    @RunWith(value=Parameterized.class)
    public static class SpecificationCombinationTest
    extends TranslationTest {
        private final String spec;

        public SpecificationCombinationTest(String pTestLabel, String pProgram, boolean pVerdict, boolean pHasGotoDecProblem, String pSpec, boolean useOverflows) throws InvalidConfigurationException, IOException {
            super(pTestLabel, pProgram, pVerdict, pHasGotoDecProblem);
            this.spec = pSpec;
            this.generationPropfile = useOverflows ? "inline-overflow.properties" : "inline-errorlabel.properties";
        }

        @Override
        protected ConfigurationBuilder getGenerationConfig(String propfile) throws InvalidConfigurationException {
            ConfigurationBuilder config = super.getGenerationConfig(propfile);
            if (this.spec != null) {
                String specPath = Path.of("test/programs/programtranslation/", this.spec).toString();
                config.setOption("specification", specPath);
            }
            return config;
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> data() {
            ImmutableList.Builder b = ImmutableList.builder();
            b.add((Object)SpecificationCombinationTest.specCausedMultiBranchingTest("main.c", false, "main_additional_spec.spc"));
            b.add((Object)SpecificationCombinationTest.specCausedMultiBranchingTest("simple.c", false, "simple_additional_spec.spc"));
            b.add((Object)SpecificationCombinationTest.specCausedMultiBranchingTest("simple.c", true, "simple_additional_spec2.spc"));
            b.add((Object)SpecificationCombinationTest.specCausedMultiBranchingTest("simple2.c", false, "simple2_additional_spec.spc"));
            b.add((Object)SpecificationCombinationTest.overflowToCTest("simple.c", false));
            return b.build();
        }

        private static Object[] specCausedMultiBranchingTest(String program, boolean verdict, String spec) {
            String label = String.format("specCausedMultiBranchingTest(%s with %s is %s)", program, spec, verdict);
            return new Object[]{label, program, verdict, false, spec, false};
        }

        private static Object[] overflowToCTest(String program, boolean verdict) {
            String label = String.format("overflowToCTest(%s is %s)", program, verdict);
            return new Object[]{label, program, verdict, true, null, true};
        }
    }

    @RunWith(value=Parameterized.class)
    public static class TranslationTest
    extends ToCTranslationTest {
        private final Path program;
        private final boolean hasGotoDecProblem;
        protected String generationPropfile;

        public TranslationTest(String pTestLabel, String pProgram, boolean pVerdict, boolean pHasGotoDecProblem) throws InvalidConfigurationException, IOException {
            super(TempFile.builder().prefix("residual").suffix(".c").create().toAbsolutePath(), pVerdict, TestDataTools.configurationForTest().loadFromResource(ARGToCTranslatorTest.class, "predicateAnalysis.properties").build());
            this.filePrefix = "residual";
            this.program = Path.of("test/programs/programtranslation/", pProgram);
            this.hasGotoDecProblem = pHasGotoDecProblem;
            this.generationPropfile = "inline-errorlabel.properties";
        }

        protected ConfigurationBuilder getGenerationConfig(String propfile) throws InvalidConfigurationException {
            return TestDataTools.configurationForTest().loadFromResource(ARGToCTranslatorTest.class, propfile).setOption("cpa.arg.export.code.handleTargetStates", "VERIFIERERROR").setOption("cpa.arg.export.code.header", "false");
        }

        protected ARGToCTranslator getTranslator() throws InvalidConfigurationException {
            Configuration generationConfig = this.getGenerationConfig(this.generationPropfile).build();
            return new ARGToCTranslator(this.logger, generationConfig, MachineModel.LINUX32);
        }

        @Override
        protected void createProgram(Path pTargetPath) throws Exception {
            ARGToCTranslator translator = this.getTranslator();
            Configuration config = this.getGenerationConfig(this.generationPropfile).build();
            ARGState root = TranslationTest.run(config, this.program);
            String res = translator.translateARG(root, this.hasGotoDecProblem);
            Files.write(pTargetPath, res.getBytes("utf-8"), new OpenOption[0]);
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> data() {
            ImmutableList.Builder b = ImmutableList.builder();
            b.add((Object)TranslationTest.simpleTask("main.c", true));
            b.add((Object)TranslationTest.simpleTask("main2.c", false));
            b.add((Object)TranslationTest.simpleTask("functionreturn.c", false));
            b.add((Object)TranslationTest.simpleTask("gotos.c", false));
            b.add((Object)TranslationTest.simpleTestWithGotoDecProblem("main.c", true));
            b.add((Object)TranslationTest.simpleTestWithGotoDecProblem("main2.c", false));
            b.add((Object)TranslationTest.simpleTestWithGotoDecProblem("functionreturn.c", false));
            return b.build();
        }

        private static Object[] simpleTask(String program, boolean verdict) {
            String label = String.format("SimpleTest(%s is %s)", program, verdict);
            return new Object[]{label, program, verdict, false};
        }

        private static Object[] simpleTestWithGotoDecProblem(String program, boolean verdict) {
            String label = String.format("SimpleTestWithGotoDecProblem(%s is %s)", program, verdict);
            return new Object[]{label, program, verdict, true};
        }
    }
}

