/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter.tests;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.cwriter.CFAToCTranslator;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.ToCTranslationTest;

@RunWith(value=Parameterized.class)
public class CFAToCTranslatorTest
extends ToCTranslationTest {
    private final Path originalProgram;

    public CFAToCTranslatorTest(String pTestLabel, String pProgram, boolean pVerdict) throws InvalidConfigurationException, IOException {
        super(TempFile.builder().prefix("residual").suffix(".c").create().toAbsolutePath(), pVerdict, TestDataTools.configurationForTest().loadFromResource(CFAToCTranslatorTest.class, "predicateAnalysis.properties").build());
        this.originalProgram = Path.of(pProgram, new String[0]);
    }

    @Override
    protected void createProgram(Path pTargetPath) throws Exception {
        CFAToCTranslator translator = this.getTranslator();
        CFA cfaToTranslate = this.parseProgram(this.originalProgram);
        String result = translator.translateCfa(cfaToTranslate);
        IO.writeFile((Path)pTargetPath, (Charset)Charset.defaultCharset(), (Object)result);
    }

    private CFAToCTranslator getTranslator() throws InvalidConfigurationException {
        return new CFAToCTranslator(TestDataTools.configurationForTest().setOption("cpa.arg.export.code.header", "false").build());
    }

    private CFA parseProgram(Path pProgram) throws ParserException, IOException, InterruptedException, InvalidConfigurationException {
        ShutdownNotifier shutdown = ShutdownNotifier.createDummy();
        Configuration parseConfig = Configuration.builder().setOption("analysis.useLoopStructure", "false").build();
        CFACreator cfaCreator = new CFACreator(parseConfig, this.logger, shutdown);
        return cfaCreator.parseFileAndCreateCFA((List<String>)ImmutableList.of((Object)pProgram.toString()));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return ImmutableList.of((Object)CFAToCTranslatorTest.directTranslationTest("functionreturn.c", true), (Object)CFAToCTranslatorTest.directTranslationTest("gotos.c", false), (Object)CFAToCTranslatorTest.directTranslationTest("main.c", true), (Object)CFAToCTranslatorTest.directTranslationTest("main2.c", true), (Object)CFAToCTranslatorTest.directTranslationTest("multipleErrors.c", false), (Object)CFAToCTranslatorTest.directTranslationTest("multipleLoops.c", false), (Object)CFAToCTranslatorTest.directTranslationTest("no_overflow.c", true), (Object)CFAToCTranslatorTest.directTranslationTest("overflow.c", true), (Object)CFAToCTranslatorTest.directTranslationTest("simple.c", true), (Object)CFAToCTranslatorTest.directTranslationTest("simple2.c", true));
    }

    private static Object[] directTranslationTest(String pProgram, boolean pVerdict) {
        String testLabel = String.format("directTranslationTest(%s is %s)", pProgram, pVerdict);
        return new Object[]{testLabel, "test/programs/programtranslation/" + pProgram, pVerdict};
    }
}

