/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter.tests;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.CFACreator;
import org.sosy_lab.cpachecker.exceptions.ParserException;
import org.sosy_lab.cpachecker.util.cwriter.CfaToCExporter;
import org.sosy_lab.cpachecker.util.cwriter.tests.CFAToCTranslatorTest;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.ToCTranslationTest;

@RunWith(value=Parameterized.class)
public class CfaToCExporterTest
extends ToCTranslationTest {
    public static final String EXPORTER_TEST_DIR_PATH = "test/programs/cfa_to_c_export/";
    private final Path originalProgram;

    public CfaToCExporterTest(String pTestLabel, String pProgram, boolean pVerdict) throws InvalidConfigurationException, IOException {
        super(TempFile.builder().prefix("residual").suffix(".c").create().toAbsolutePath(), pVerdict, TestDataTools.configurationForTest().loadFromResource(CFAToCTranslatorTest.class, "predicateAnalysis.properties").build());
        this.originalProgram = Path.of(pProgram, new String[0]);
    }

    @Test
    public void testProgramsStaySame() throws Exception {
        this.createProgram(this.targetProgram);
        FileUtils.contentEquals((File)this.originalProgram.toFile(), (File)this.targetProgram.toFile());
    }

    @Override
    protected void createProgram(Path pTargetPath) throws Exception {
        CfaToCExporter exporter = this.getExporter();
        CFA cfaToExport = this.parseProgram(this.originalProgram);
        String result = exporter.exportCfa(cfaToExport);
        IO.writeFile((Path)pTargetPath, (Charset)Charset.defaultCharset(), (Object)result);
    }

    private CfaToCExporter getExporter() throws InvalidConfigurationException {
        return new CfaToCExporter(this.logger, Configuration.defaultConfiguration(), ShutdownNotifier.createDummy());
    }

    private CFA parseProgram(Path pProgram) throws ParserException, IOException, InterruptedException, InvalidConfigurationException {
        ShutdownNotifier shutdown = ShutdownNotifier.createDummy();
        Configuration parseConfig = Configuration.defaultConfiguration();
        CFACreator cfaCreator = new CFACreator(parseConfig, this.logger, shutdown);
        return cfaCreator.parseFileAndCreateCFA((List<String>)ImmutableList.of((Object)pProgram.toString()));
    }

    @Parameterized.Parameters(name="{0}")
    public static Collection<Object[]> data() {
        return ImmutableList.builder().addAll(CFAToCTranslatorTest.data()).add((Object[])new Object[][]{CfaToCExporterTest.directExportTest("declaration.c"), CfaToCExporterTest.directExportTest("declaration_multiple-on-one-line.c"), CfaToCExporterTest.directExportTest("declaration_split.c"), CfaToCExporterTest.directExportTest("declaration_with-side-effect.c"), CfaToCExporterTest.directExportTest("declaration_with-side-effect_multiple-on-one-line.c"), CfaToCExporterTest.directExportTest("for.c"), CfaToCExporterTest.directExportTest("for_condition-negated.c"), CfaToCExporterTest.directExportTest("function-call.c"), CfaToCExporterTest.directExportTest("functions_multiple.c"), CfaToCExporterTest.directExportTest("global-var.c"), CfaToCExporterTest.directExportTest("global-var_multiple.c"), CfaToCExporterTest.directExportTest("goto_label_multiple-per-statement.c"), CfaToCExporterTest.directExportTest("goto_label_on-empty-statement.c"), CfaToCExporterTest.directExportTest("goto_label_on-if.c"), CfaToCExporterTest.directExportTest("goto_with-dead-code.c"), CfaToCExporterTest.directExportTest("if-else.c"), CfaToCExporterTest.directExportTest("if-else_condition-abbreviated.c"), CfaToCExporterTest.directExportTest("if-else_condition-negated.c"), CfaToCExporterTest.directExportTest("if-else_condition-negated_double.c"), CfaToCExporterTest.directExportTest("if-else_condition-true.c"), CfaToCExporterTest.directExportTest("if-else_else-branch-empty.c"), CfaToCExporterTest.directExportTest("if-else_else-branch-missing.c"), CfaToCExporterTest.directExportTest("if-else_multiple-returns.c"), CfaToCExporterTest.directExportTest("if-else_with-goto.c"), CfaToCExporterTest.directExportTest("if-else_with-goto-out-and-back-in.c"), CfaToCExporterTest.directExportTest("if-else_with-goto-out-of-both-branches.c"), CfaToCExporterTest.directExportTest("if-else_with-goto_labeled-return-within.c"), CfaToCExporterTest.directExportTest("if-else_with-goto_labeled-return-within-both-branches.c"), CfaToCExporterTest.directExportTest("mixed.c"), CfaToCExporterTest.directExportTest("switch-case.c"), CfaToCExporterTest.directExportTest("while.c")}).build();
    }

    private static Object[] directExportTest(String pProgram) {
        boolean verdict = true;
        String testLabel = String.format("directExportTest(%s)", pProgram);
        return new Object[]{testLabel, EXPORTER_TEST_DIR_PATH + pProgram, true};
    }
}

