/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.cwriter.tests;

import com.google.common.collect.ImmutableList;
import com.google.common.truth.Truth;
import com.google.common.truth.TruthJUnit;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.runners.Enclosed;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.io.PathTemplate;
import org.sosy_lab.common.io.TempFile;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.reachedset.ReachedSet;
import org.sosy_lab.cpachecker.util.cwriter.CExpressionInvariantExporter;
import org.sosy_lab.cpachecker.util.cwriter.FormulaToCExpressionConverter;
import org.sosy_lab.cpachecker.util.predicates.smt.BitvectorFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FloatingPointFormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.SolverViewBasedTest0;
import org.sosy_lab.cpachecker.util.test.CPATestRunner;
import org.sosy_lab.cpachecker.util.test.TestDataTools;
import org.sosy_lab.cpachecker.util.test.ToCTranslationTest;
import org.sosy_lab.java_smt.SolverContextFactory;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.FormulaType;
import org.sosy_lab.java_smt.api.NumeralFormula;

@RunWith(value=Enclosed.class)
public class FormulaToCExpressionConverterTest {

    @RunWith(value=Parameterized.class)
    public static class TranslationTest
    extends ToCTranslationTest {
        private static final String TEST_DIR = "test/programs/induction/";
        private final Path program;
        private final Configuration config;

        public TranslationTest(Path pProgram, boolean pVerdict) throws InvalidConfigurationException, IOException {
            super(TempFile.builder().create().toAbsolutePath(), pVerdict, TestDataTools.configurationForTest().loadFromResource(TranslationTest.class, "kInduction-kipdrdfInvariants.properties").build());
            this.program = pProgram;
            this.config = TestDataTools.configurationForTest().loadFromResource(FormulaToCExpressionConverterTest.class, "kInduction-kipdrdfInvariants.properties").build();
        }

        @Override
        protected void createProgram(Path pTargetPath) throws Exception {
            CPAcheckerResult result = CPATestRunner.run(this.config, this.program.toString()).getCheckerResult();
            CFA cfa = result.getCfa();
            ReachedSet reached = result.getReached();
            Truth.assertThat((Object)cfa).isNotNull();
            Truth.assertThat((Iterable)reached).isNotNull();
            CExpressionInvariantExporter exporter = new CExpressionInvariantExporter(this.config, LogManager.createTestLogManager(), ShutdownNotifier.createDummy(), PathTemplate.ofFormatString((String)pTargetPath.toString()));
            exporter.exportInvariant(cfa, reached);
        }

        @Parameterized.Parameters(name="{0}")
        public static Collection<Object[]> data() {
            ImmutableList.Builder b = ImmutableList.builder();
            b.add((Object)TranslationTest.exportInvariantsTest("induction1.c", true));
            b.add((Object)TranslationTest.exportInvariantsTest("induction2.c", true));
            b.add((Object)TranslationTest.exportInvariantsTest("induction2_BUG.c", false));
            b.add((Object)TranslationTest.exportInvariantsTest("induction-next-state.c", true));
            return b.build();
        }

        private static Object[] exportInvariantsTest(String program, boolean verdict) {
            return new Object[]{Path.of(TEST_DIR, program), verdict};
        }
    }

    @RunWith(value=Parameterized.class)
    public static class ConversionTest
    extends SolverViewBasedTest0 {
        private FormulaToCExpressionConverter converter;
        @Parameterized.Parameter
        public SolverContextFactory.Solvers solverToUse;

        @Parameterized.Parameters(name="{0}")
        public static Object[] getAllSolvers() {
            return SolverContextFactory.Solvers.values();
        }

        protected SolverContextFactory.Solvers solverToUse() {
            return this.solverToUse;
        }

        @Before
        public void setup() {
            this.converter = new FormulaToCExpressionConverter(this.mgrv);
        }

        private void skipTestForSolvers(SolverContextFactory.Solvers ... solversToSkip) {
            TruthJUnit.assume().withMessage("Solver %s does not support tested features or uses different representation", new Object[]{this.solverToUse()}).that((Comparable)this.solverToUse()).isNotIn((Iterable)ImmutableList.copyOf((Object[])solversToSkip));
        }

        private static Observation checkThat(String formula) {
            return new Observation(formula);
        }

        @Test
        public void convertVar() throws InterruptedException {
            BooleanFormula var = this.bmgrv.makeVariable("x");
            ConversionTest.checkThat(this.converter.formulaToCExpression(var)).isEquivalentTo("x");
        }

        @Test
        public void convertConstant() throws InterruptedException {
            BooleanFormula trueFormula = this.bmgrv.makeTrue();
            ConversionTest.checkThat(this.converter.formulaToCExpression(trueFormula)).isEquivalentTo("true");
            BooleanFormula falseFormula = this.bmgrv.makeFalse();
            ConversionTest.checkThat(this.converter.formulaToCExpression(falseFormula)).isEquivalentTo("false");
        }

        @Test
        public void convertNot() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.bmgrv.makeVariable("x"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(!x)");
        }

        @Test
        public void convertAnd() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.and(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(x && y)");
        }

        @Test
        public void convertNegatedAnd() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.bmgrv.and(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y")));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((!x)\n|| (!y))");
        }

        @Test
        public void convertOr() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.or(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(x\n|| y)");
        }

        @Test
        public void convertNegatedOr() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.bmgrv.or(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y")));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((!x) && (!y))");
        }

        @Test
        public void convertImplication() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.implication(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y"));
            String expected = "((!x)\n|| y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(y || (!x))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedImplication() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.bmgrv.implication(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y")));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(x && (!y))");
        }

        @Test
        public void convertEquivalence() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.equivalence(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y"));
            String expected = "((x && y)\n|| ((!x) && (!y)))";
            if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((y || (!x)) && (x || (!y)))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedEquivalence() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.bmgrv.equivalence(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y")));
            String expected = "(((!x)\n|| (!y)) && (x\n|| y))";
            if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((x || y) && ((!x) || (!y)))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertXor() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.xor(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y"));
            String expected = "((x && (!y))\n|| ((!x) && y))";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((!x) || (!y)) && (x || y))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((x || y) && ((!x) || (!y)))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedXor() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.bmgrv.xor(this.bmgrv.makeVariable("x"), this.bmgrv.makeVariable("y")));
            String expected = "(((!x)\n|| y) && (x\n|| (!y)))";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x && y) || ((!x) && (!y)))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((y || (!x)) && (x || (!y)))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertEqual() throws InterruptedException {
            BooleanFormula formula = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(x == y)");
        }

        @Test
        public void convertNegatedEqual() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(!(x == y))");
        }

        @Test
        public void convertLessThan() throws InterruptedException {
            BooleanFormula formula = this.imgrv.lessThan((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            String expected = "(x < y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(!(y <= x))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((y + (-1 * x))+ -1) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedLessThan() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.imgrv.lessThan((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")));
            String expected = "(!(x < y))";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(y <= x)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(!(((y + (-1 * x)) + -1) >= 0))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertLessOrEquals() throws InterruptedException {
            BooleanFormula formula = this.imgrv.lessOrEquals((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            String expected = "(x <= y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((y + (-1 * x)) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedLessOrEquals() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.imgrv.lessOrEquals((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")));
            String expected = "(!(x<=y))";
            if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(!((y + (-1 * x)) >= 0))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertGreaterThan() throws InterruptedException {
            BooleanFormula formula = this.imgrv.greaterThan((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            String expected = "(x > y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(!(x<=y))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((x + (-1 * y)) + -1) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedGreaterThan() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.imgrv.greaterThan((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")));
            String expected = "(!(x > y))";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(x <= y)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(!(((x + (-1 * y)) + -1) >= 0))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertGreaterOrEquals() throws InterruptedException {
            BooleanFormula formula = this.imgrv.greaterOrEquals((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            String expected = "(x >= y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "(y <= x)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x + (-1 * y)) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertNegatedGreaterOrEquals() throws InterruptedException {
            BooleanFormula formula = this.bmgrv.not(this.imgrv.greaterOrEquals((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")));
            String expected = "(!(x >= y))";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "(!(y <= x))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(!((x + (-1 * y)) >= 0))";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertAddition() throws InterruptedException {
            BooleanFormula formula = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.add((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("z"));
            String expected = "((x + y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "((x + (y + (-1 * z))) == 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertSubtraction() throws InterruptedException {
            BooleanFormula formula = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.subtract((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y")), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("z"));
            String expected = "((x - y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "((x + ((-1 * y) + (-1 * z))) == 0)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((x + (-1 * y)) == z)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x + (-1 * y)) == z)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertMultiplication() throws InterruptedException {
            BooleanFormula formula = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.multiply((NumeralFormula.IntegerFormula)this.imgr.makeNumber(3L), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x")), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            String expected = "((3 * x) == y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "(((3 * x) + (-1 * y)) == 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertDivision() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.MATHSAT5, SolverContextFactory.Solvers.PRINCESS);
            BooleanFormula formula = this.imgrv.equal((NumeralFormula.IntegerFormula)this.imgrv.divide((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeNumber(2L)), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x / 2) == y)");
        }

        @Test
        public void convertModulo() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.MATHSAT5, SolverContextFactory.Solvers.PRINCESS);
            BooleanFormula formula = this.imgrv.equal(this.imgrv.modulo((NumeralFormula.IntegerFormula)this.imgrv.makeVariable("x"), (NumeralFormula.IntegerFormula)this.imgrv.makeNumber(2L)), (NumeralFormula.IntegerFormula)this.imgrv.makeVariable("y"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x % 2) == y)");
        }

        @Test
        public void convertBVLessThan() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula signed = bvmgrv.lessThan(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), true);
            BooleanFormula unsigned = bvmgrv.lessThan(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), false);
            String expected = "(x < y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(!(y <= x))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((y + (-1 * x)) + -1) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(signed)).isEquivalentTo(expected);
            ConversionTest.checkThat(this.converter.formulaToCExpression(unsigned)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVLessOrEquals() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula signed = bvmgrv.lessOrEquals(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), true);
            BooleanFormula unsigned = bvmgrv.lessOrEquals(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), false);
            String expected = "(x <= y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "(!(y<x))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((y + (-1 * x)) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(signed)).isEquivalentTo(expected);
            ConversionTest.checkThat(this.converter.formulaToCExpression(unsigned)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVGreaterThan() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula signed = bvmgrv.greaterThan(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), true);
            BooleanFormula unsigned = bvmgrv.greaterThan(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), false);
            String expected = "(x > y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "(y < x)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(!(x <= y))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((x + (-1 * y)) + -1) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(signed)).isEquivalentTo(expected);
            ConversionTest.checkThat(this.converter.formulaToCExpression(unsigned)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVGreaterOrEquals() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula signed = bvmgrv.greaterOrEquals(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), true);
            BooleanFormula unsigned = bvmgrv.greaterOrEquals(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), false);
            String expected = "(x >= y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "(!(x < y))";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(y <= x)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x + (-1 * y)) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(signed)).isEquivalentTo(expected);
            ConversionTest.checkThat(this.converter.formulaToCExpression(unsigned)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVNot() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.not(bvmgrv.makeVariable(5, "x")), bvmgrv.makeVariable(5, "y"));
            String expected = "((~x) == y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.SMTINTERPOL || this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x) == y)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVAnd() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.and(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y")), bvmgrv.makeVariable(5, "z"));
            String expected = "((x & y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((~((~x) | (~y))) == z)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVOr() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.or(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y")), bvmgrv.makeVariable(5, "z"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x | y) == z)");
        }

        @Test
        public void convertBVXor() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.xor(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y")), bvmgrv.makeVariable(5, "z"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x ^ y) == z)");
        }

        @Test
        public void convertBVAddition() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.add(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y")), bvmgrv.makeVariable(5, "z"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x + y) == z)");
        }

        @Test
        public void convertBVSubtraction() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.subtract(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y")), bvmgrv.makeVariable(5, "z"));
            String expected = "((x - y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5) {
                expected = "((x + (-y)) == z)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((x + (31 * y)) == z)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x + (-1 * y)) == z)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVNeg() throws InterruptedException {
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.negate(bvmgrv.makeVariable(5, "x")), bvmgrv.makeVariable(5, "y"));
            String expected = "((-x) == y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.SMTINTERPOL || this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((-1 * x) == y)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((31 * x) == y)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVMultiplication() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.SMTINTERPOL);
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.multiply(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y")), bvmgrv.makeVariable(5, "z"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x * y) == z)");
        }

        @Test
        public void convertBVDivision() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.SMTINTERPOL, SolverContextFactory.Solvers.PRINCESS, SolverContextFactory.Solvers.Z3);
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula signed = bvmgrv.equal(bvmgrv.divide(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), true), bvmgrv.makeVariable(5, "z"));
            BooleanFormula unsigned = bvmgrv.equal(bvmgrv.divide(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), false), bvmgrv.makeVariable(5, "z"));
            String expected = "((x / y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.CVC4) {
                expected = "(((0 == y) ? ((x < 0) ? 1 : 31) : (x / y)) == z)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(signed)).isEquivalentTo(expected);
            ConversionTest.checkThat(this.converter.formulaToCExpression(unsigned)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVModulo() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.SMTINTERPOL, SolverContextFactory.Solvers.PRINCESS, SolverContextFactory.Solvers.Z3);
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula signed = bvmgrv.equal(bvmgrv.modulo(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), true), bvmgrv.makeVariable(5, "z"));
            BooleanFormula unsigned = bvmgrv.equal(bvmgrv.modulo(bvmgrv.makeVariable(5, "x"), bvmgrv.makeVariable(5, "y"), false), bvmgrv.makeVariable(5, "z"));
            String expected = "((x % y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.CVC4) {
                expected = "(((0 == y) ? x : (x % y)) == z)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(signed)).isEquivalentTo(expected);
            ConversionTest.checkThat(this.converter.formulaToCExpression(unsigned)).isEquivalentTo(expected);
        }

        @Test
        public void convertBVSHL() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.Z3);
            BitvectorFormulaManagerView bvmgrv = this.mgrv.getBitvectorFormulaManager();
            BooleanFormula formula = bvmgrv.equal(bvmgrv.shiftLeft(bvmgrv.makeVariable(8, "x"), bvmgrv.makeBitvector(8, 4L)), bvmgrv.makeVariable(8, "y"));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x << 4) == y)");
        }

        @Test
        public void convertFPEqual() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.equalWithFPSemantics(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType()));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("(x == y)");
        }

        @Test
        public void convertFPLessThan() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.lessThan(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType()));
            String expected = "(x < y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((y + (-1 * x)) + -1) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertFPLessOrEquals() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.lessOrEquals(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType()));
            String expected = "(x <= y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((y + (-1 * x)) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertFPGreaterThan() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.greaterThan(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType()));
            String expected = "(x > y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(y < x)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "(((x + (-1 * y)) + -1) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertFPGreaterOrEquals() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.greaterOrEquals(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType()));
            String expected = "(x >= y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.MATHSAT5 || this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "(y <= x)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x + (-1 * y)) >= 0)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertFPAddition() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.equalWithFPSemantics(fmgrv.add(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType())), fmgrv.makeVariable("z", FormulaType.getSinglePrecisionFloatingPointType()));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x + y) == z)");
        }

        @Test
        public void convertFPSubtraction() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.equalWithFPSemantics(fmgrv.subtract(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType())), fmgrv.makeVariable("z", FormulaType.getSinglePrecisionFloatingPointType()));
            String expected = "((x - y) == z)";
            if (this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((x + (-1 * y)) == z)";
            } else if (this.solverToUse() == SolverContextFactory.Solvers.Z3) {
                expected = "((x + (-y)) == z)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertFPNeg() throws InterruptedException {
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.equalWithFPSemantics(fmgrv.negate(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType())), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType()));
            String expected = "((-x) == y)";
            if (this.solverToUse() == SolverContextFactory.Solvers.SMTINTERPOL || this.solverToUse() == SolverContextFactory.Solvers.PRINCESS) {
                expected = "((-1 * x) == y)";
            }
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo(expected);
        }

        @Test
        public void convertFPMultiplication() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.SMTINTERPOL);
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.equalWithFPSemantics(fmgrv.multiply(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType())), fmgrv.makeVariable("z", FormulaType.getSinglePrecisionFloatingPointType()));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x * y) == z)");
        }

        @Test
        public void convertFPDivision() throws InterruptedException {
            this.skipTestForSolvers(SolverContextFactory.Solvers.SMTINTERPOL, SolverContextFactory.Solvers.PRINCESS);
            FloatingPointFormulaManagerView fmgrv = this.mgrv.getFloatingPointFormulaManager();
            BooleanFormula formula = fmgrv.equalWithFPSemantics(fmgrv.divide(fmgrv.makeVariable("x", FormulaType.getSinglePrecisionFloatingPointType()), fmgrv.makeVariable("y", FormulaType.getSinglePrecisionFloatingPointType())), fmgrv.makeVariable("z", FormulaType.getSinglePrecisionFloatingPointType()));
            ConversionTest.checkThat(this.converter.formulaToCExpression(formula)).isEquivalentTo("((x / y) == z)");
        }

        private static class Observation {
            private String observable;

            private Observation(String pObservable) {
                this.observable = pObservable;
            }

            private void isEquivalentTo(String reference) {
                Truth.assertThat((String)this.observable).isNotNull();
                Truth.assertThat((String)reference).isNotNull();
                Truth.assertThat((String)Observation.prune(this.observable)).isEqualTo((Object)Observation.prune(reference));
            }

            private static String prune(String input) {
                return input.replaceAll("\\s+", "");
            }
        }
    }
}

