/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import java.io.PrintStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.sosy_lab.common.ShutdownManager;
import org.sosy_lab.common.ShutdownNotifier;
import org.sosy_lab.common.configuration.Configuration;
import org.sosy_lab.common.configuration.FileOption;
import org.sosy_lab.common.configuration.InvalidConfigurationException;
import org.sosy_lab.common.configuration.Option;
import org.sosy_lab.common.configuration.Options;
import org.sosy_lab.common.configuration.TimeSpanOption;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.common.time.TimeSpan;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCall;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CLeftHandSide;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.core.CPAcheckerResult;
import org.sosy_lab.cpachecker.core.interfaces.Statistics;
import org.sosy_lab.cpachecker.core.interfaces.StatisticsProvider;
import org.sosy_lab.cpachecker.core.reachedset.UnmodifiableReachedSet;
import org.sosy_lab.cpachecker.exceptions.CPAException;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.CSystemDependenceGraph;
import org.sosy_lab.cpachecker.util.dependencegraph.CallGraph;
import org.sosy_lab.cpachecker.util.dependencegraph.CallGraphUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.ControlDependenceBuilder;
import org.sosy_lab.cpachecker.util.dependencegraph.EdgeDefUseData;
import org.sosy_lab.cpachecker.util.dependencegraph.FlowDepAnalysis;
import org.sosy_lab.cpachecker.util.dependencegraph.ForeignDefUseData;
import org.sosy_lab.cpachecker.util.dependencegraph.GlobalPointerState;
import org.sosy_lab.cpachecker.util.dependencegraph.SdgDotExporter;
import org.sosy_lab.cpachecker.util.dependencegraph.SummaryEdgeBuilder;
import org.sosy_lab.cpachecker.util.dependencegraph.SystemDependenceGraph;
import org.sosy_lab.cpachecker.util.graph.dominance.DomFrontiers;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;
import org.sosy_lab.cpachecker.util.graph.dominance.DominanceUtils;
import org.sosy_lab.cpachecker.util.resources.ResourceLimit;
import org.sosy_lab.cpachecker.util.resources.ResourceLimitChecker;
import org.sosy_lab.cpachecker.util.resources.WalltimeLimit;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;
import org.sosy_lab.cpachecker.util.statistics.StatTimer;

@Options(prefix="dependencegraph")
public class CSystemDependenceGraphBuilder
implements StatisticsProvider {
    private final CFA cfa;
    private final LogManager logger;
    private final ShutdownNotifier shutdownNotifier;
    private final EdgeDefUseData.Extractor defUseExtractor;
    private final StatTimer dependenceGraphConstructionTimer = new StatTimer("Time for dep. graph");
    private final StatTimer flowDependenceTimer = new StatTimer("Time for flow deps.");
    private final StatTimer controlDependenceTimer = new StatTimer("Time for control deps.");
    private final StatTimer summaryEdgeTimer = new StatTimer("Time for summary edges");
    @Option(secure=true, description="File to export dependence graph to. If `null`, dependence graph will not be exported as dot.")
    @FileOption(value=FileOption.Type.OUTPUT_FILE)
    private Path exportDot = Path.of("DependenceGraph.dot", new String[0]);
    @Option(secure=true, name="controldeps.use", description="Whether to consider control dependencies.")
    private boolean considerControlDeps = true;
    @Option(secure=true, name="controldeps.considerInverseAssumption", description="Whether to take an assumption edge 'p' as control dependence if edge 'not p' is a control dependence. This creates a larger slice, but may reduce the size of the state space for deterministic programs. This behavior is also closer to the static program slicing based on control-flow graphs (CFGs), where branching is represented by a single assumption (with true- and false-edges)")
    private boolean controlDepsTakeBothAssumptions = true;
    @Option(secure=true, name="flowdeps.use", description="Whether to consider (data-)flow dependencies.")
    private boolean considerFlowDeps = true;
    @Option(secure=true, name="considerPointees", description="Whether to consider pointees. Only if this option is set to true, a pointer analysis is run during system dependence graph (SDG) construction and dependencies of pointees are inserted into the SDG. If this option is set to false, pointers are completely ignored and the resulting SDG is an under-approximation that lacks all pointee dependencies.")
    private boolean considerPointees = true;
    @Option(secure=true, name="onlyReachableFunctions", description="Whether to include only functions reachable from the main function in the dependence graph.")
    private boolean onlyReachableFunctions = true;
    @Option(secure=true, name="pointerAnalysisTime", description="The maximum duration a single pointer analysis method is allowed to run (use seconds or specify a unit; 0 for infinite).")
    @TimeSpanOption(codeUnit=TimeUnit.NANOSECONDS, defaultUserUnit=TimeUnit.SECONDS, min=0L)
    private TimeSpan pointerAnalysisTime = TimeSpan.ofSeconds((long)0L);
    @Option(secure=true, name="pointerStateComputationMethods", description="The computation methods used for pointer analysis. If no method is specified, an imprecise over-approximation of the global pointer state is created without running any actual pointer analysis. If at least one computation method is specified, the first one in the list is run with the time limit set by 'dependencegraph.pointerAnalysisTime'. If this method is able to create a valid global pointer state in time, the state is used and no other methods are run. Otherwise, if a second computation method is specified, the second method is run with the same time limit. If the method is able to create a valid global pointer state in time, the state is used and no other methods are run. The same is true for all subsequent computation methods specified in the list. If no computation method is able to create a valid global pointer state in time, an imprecise over-approximation of the global pointer state is created without running any actual pointer analysis. A pointer analysis is only run if 'dependencegraph.considerPointees' is set to true. Available computation methods: PointerStateComputationMethod.FLOW_SENSITIVE, PointerStateComputationMethod.FLOW_INSENSITIVE")
    private List<PointerStateComputationMethod> pointerStateComputationMethods = ImmutableList.of((Object)((Object)PointerStateComputationMethod.FLOW_SENSITIVE));
    private final SystemDependenceGraph.Builder<AFunctionDeclaration, CFAEdge, MemoryLocation, CSystemDependenceGraph.Node> builder;
    private SystemDependenceGraph<MemoryLocation, CSystemDependenceGraph.Node> systemDependenceGraph = SystemDependenceGraph.empty();
    private String usedGlobalPointerState = "none";

    public CSystemDependenceGraphBuilder(CFA pCfa, Configuration pConfig, LogManager pLogger, ShutdownNotifier pShutdownNotifier) throws InvalidConfigurationException {
        pConfig.inject((Object)this);
        this.cfa = pCfa;
        this.logger = pLogger;
        this.shutdownNotifier = pShutdownNotifier;
        this.defUseExtractor = new EdgeDefUseData.CachingExtractor(EdgeDefUseData.createExtractor(this.considerPointees));
        if (!this.considerFlowDeps && !this.considerControlDeps) {
            throw new InvalidConfigurationException("At least one kind of dependency is required to build a meaningful dependence graph");
        }
        this.builder = SystemDependenceGraph.builder(CSystemDependenceGraph.Node::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void insertDependencies(CallGraph<AFunctionDeclaration> pCallGraph, ImmutableSet<AFunctionDeclaration> pReachableFunctions) throws CPAException, InterruptedException {
        if (this.considerFlowDeps) {
            this.flowDependenceTimer.start();
            try {
                this.insertFlowDependencies(pReachableFunctions);
            }
            finally {
                this.flowDependenceTimer.stop();
            }
        }
        if (this.considerControlDeps) {
            this.controlDependenceTimer.start();
            try {
                this.insertControlDependencies(pReachableFunctions);
            }
            finally {
                this.controlDependenceTimer.stop();
            }
        }
        this.summaryEdgeTimer.start();
        try {
            SummaryEdgeBuilder.insertSummaryEdges(this.builder, pCallGraph, this.cfa.getMainFunction().getFunction(), SummaryEdgeBuilder.Method.BATCH);
        }
        finally {
            this.summaryEdgeTimer.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CSystemDependenceGraph build() throws CPAException, InterruptedException {
        this.dependenceGraphConstructionTimer.start();
        try {
            CallGraph<AFunctionDeclaration> callGraph = CallGraphUtils.createCallGraph(this.cfa);
            ImmutableSet reachableFunctions = ImmutableSet.of();
            if (this.onlyReachableFunctions) {
                AFunctionDeclaration mainFunction = this.cfa.getMainFunction().getFunction();
                ImmutableSet.Builder reachableFunctionsBuilder = ImmutableSet.builder();
                reachableFunctionsBuilder.add((Object)mainFunction);
                reachableFunctionsBuilder.addAll(callGraph.getReachableFrom((Collection<AFunctionDeclaration>)ImmutableSet.of((Object)mainFunction)));
                reachableFunctions = reachableFunctionsBuilder.build();
            }
            this.insertDependencies(callGraph, (ImmutableSet<AFunctionDeclaration>)reachableFunctions);
            this.systemDependenceGraph = this.builder.build();
        }
        finally {
            this.dependenceGraphConstructionTimer.stop();
        }
        if (this.exportDot != null) {
            new CSdgDotExporter().export(this.systemDependenceGraph, this.exportDot, this.logger);
        }
        return new CSystemDependenceGraph(this.systemDependenceGraph);
    }

    private static Optional<AFunctionDeclaration> getOptionalFunction(CFAEdge pEdge) {
        CFANode node = pEdge instanceof CFunctionReturnEdge ? pEdge.getPredecessor() : pEdge.getSuccessor();
        return Optional.of(node.getFunction());
    }

    private GlobalPointerState createGlobalPointerState() throws CPAException, InterruptedException {
        GlobalPointerState pointerState = null;
        if (this.considerPointees) {
            for (PointerStateComputationMethod method : this.pointerStateComputationMethods) {
                block14: {
                    ResourceLimitChecker pointerTimeChecker;
                    ShutdownNotifier pointerShutdownNotifier;
                    if (!this.pointerAnalysisTime.isEmpty()) {
                        ShutdownManager pointerShutdownManager = ShutdownManager.createWithParent((ShutdownNotifier)this.shutdownNotifier);
                        pointerShutdownNotifier = pointerShutdownManager.getNotifier();
                        WalltimeLimit timeLimit = WalltimeLimit.fromNowOn(this.pointerAnalysisTime);
                        pointerTimeChecker = new ResourceLimitChecker(pointerShutdownManager, (List<ResourceLimit>)ImmutableList.of((Object)timeLimit));
                        pointerTimeChecker.start();
                    } else {
                        pointerShutdownNotifier = this.shutdownNotifier;
                        pointerTimeChecker = null;
                    }
                    try {
                        if (method == PointerStateComputationMethod.FLOW_SENSITIVE) {
                            pointerState = GlobalPointerState.createFlowSensitive(this.cfa, this.logger, pointerShutdownNotifier);
                            break block14;
                        }
                        if (method == PointerStateComputationMethod.FLOW_INSENSITIVE) {
                            pointerState = GlobalPointerState.createFlowInsensitive(this.cfa, pointerShutdownNotifier);
                            break block14;
                        }
                        throw new AssertionError((Object)("Invalid PointerStateComputationMethod: " + method));
                    }
                    catch (InterruptedException ex) {
                        this.shutdownNotifier.shutdownIfNecessary();
                        if (pointerShutdownNotifier.shouldShutdown()) continue;
                        throw ex;
                    }
                    finally {
                        if (pointerTimeChecker == null) continue;
                        pointerTimeChecker.cancel();
                        continue;
                    }
                }
                if (pointerState == null) continue;
                break;
            }
            if (pointerState == null) {
                pointerState = GlobalPointerState.creatUnknown(this.cfa);
            }
        } else {
            pointerState = GlobalPointerState.IGNORE_POINTERS;
        }
        return pointerState;
    }

    private static ImmutableList<CFAEdge> getGlobalDeclarationEdges(CFA pCfa) {
        CFANode node = pCfa.getMainFunction();
        ArrayList<CFAEdge> declEdges = new ArrayList<CFAEdge>();
        HashSet<FunctionEntryNode> visited = new HashSet<FunctionEntryNode>();
        while (node.getNumLeavingEdges() == 1 && !visited.contains(node)) {
            CDeclaration declaration;
            visited.add((FunctionEntryNode)node);
            CFAEdge edge = node.getLeavingEdge(0);
            if (edge instanceof CDeclarationEdge && (declaration = ((CDeclarationEdge)edge).getDeclaration()).isGlobal()) {
                declEdges.add(edge);
            }
            node = edge.getSuccessor();
        }
        return ImmutableList.copyOf(declEdges);
    }

    private ImmutableMultimap<String, CFAEdge> getFunctionDeclarationEdges(ImmutableList<CFAEdge> pGlobalEdges) {
        ImmutableListMultimap.Builder declarationEdges = ImmutableListMultimap.builder();
        for (CFAEdge edge : pGlobalEdges) {
            CDeclaration declaration;
            if (!(edge instanceof CDeclarationEdge) || !((declaration = ((CDeclarationEdge)edge).getDeclaration()) instanceof CFunctionDeclaration)) continue;
            String name = ((CFunctionDeclaration)declaration).getQualifiedName();
            declarationEdges.put((Object)name, (Object)edge);
        }
        return declarationEdges.build();
    }

    private ImmutableMultimap<String, CFAEdge> getComplexTypeDeclarationEdges(ImmutableList<CFAEdge> pGlobalEdges) {
        ImmutableListMultimap.Builder declarationEdges = ImmutableListMultimap.builder();
        for (CFAEdge edge : pGlobalEdges) {
            CDeclaration declaration;
            if (!(edge instanceof CDeclarationEdge) || !((declaration = ((CDeclarationEdge)edge).getDeclaration()) instanceof CComplexTypeDeclaration)) continue;
            CComplexType globalType = ((CComplexTypeDeclaration)declaration).getType();
            String name = globalType.getQualifiedName();
            declarationEdges.put((Object)name, (Object)edge);
        }
        return declarationEdges.build();
    }

    private CFunctionCallEdge getCallEdge(CFunctionSummaryEdge pSummaryEdge) {
        for (CFAEdge edge : CFAUtils.leavingEdges(pSummaryEdge.getPredecessor())) {
            if (!(edge instanceof CFunctionCallEdge)) continue;
            return (CFunctionCallEdge)edge;
        }
        throw new AssertionError((Object)"No CFunctionCallEdge for CFunctionSummaryEdge");
    }

    private CFunctionCall getFunctionCallWithoutParameters(CFunctionSummaryEdge pSummaryEdge) {
        CFunctionCall functionCall = pSummaryEdge.getExpression();
        if (functionCall instanceof CFunctionCallAssignmentStatement) {
            CFunctionCallAssignmentStatement statement = (CFunctionCallAssignmentStatement)functionCall;
            CLeftHandSide lhs = statement.getLeftHandSide();
            CFunctionCallExpression rhs = statement.getRightHandSide();
            CFunctionCallExpression functionCallExpression = new CFunctionCallExpression(rhs.getFileLocation(), rhs.getExpressionType(), rhs.getFunctionNameExpression(), (List<CExpression>)ImmutableList.of(), rhs.getDeclaration());
            return new CFunctionCallAssignmentStatement(statement.getFileLocation(), lhs, functionCallExpression);
        }
        if (functionCall instanceof CFunctionCallStatement) {
            CFunctionCallStatement statement = (CFunctionCallStatement)functionCall;
            CFunctionCallExpression expression = statement.getFunctionCallExpression();
            CFunctionCallExpression functionCallExpression = new CFunctionCallExpression(expression.getFileLocation(), expression.getExpressionType(), expression.getFunctionNameExpression(), (List<CExpression>)ImmutableList.of(), expression.getDeclaration());
            return new CFunctionCallStatement(statement.getFileLocation(), functionCallExpression);
        }
        throw new AssertionError((Object)("Unsupported function call: " + functionCall));
    }

    private Optional<MemoryLocation> getReturnVariable(CFunctionSummaryEdge pSummaryEdge) {
        CFunctionCallEdge callEdge = this.getCallEdge(pSummaryEdge);
        Optional<CVariableDeclaration> returnVariable = callEdge.getSummaryEdge().getFunctionEntry().getReturnVariable();
        if (returnVariable.isPresent()) {
            return Optional.of(MemoryLocation.forDeclaration(returnVariable.orElseThrow()));
        }
        return Optional.empty();
    }

    private void insertFunctionDeclarationEdge(ImmutableMultimap<String, CFAEdge> pDeclarationEdges, FunctionEntryNode pEntryNode) {
        for (CFAEdge functionDeclarationEdge : pDeclarationEdges.get((Object)pEntryNode.getFunctionName())) {
            this.builder.node(SystemDependenceGraph.NodeType.ENTRY, Optional.of(pEntryNode.getFunction()), Optional.empty(), Optional.empty()).depends(SystemDependenceGraph.EdgeType.DECLARATION_EDGE, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, CSystemDependenceGraphBuilder.getOptionalFunction(functionDeclarationEdge), Optional.of(functionDeclarationEdge), Optional.empty());
        }
    }

    private void insertDefSummaryUseCallEdges(Optional<AFunctionDeclaration> pDefFunction, Optional<AFunctionDeclaration> pUseFunction, Optional<CFAEdge> pDefEdge, MemoryLocation pCause) {
        Optional<AFunctionDeclaration> callerFunction = pDefFunction;
        Optional<AFunctionDeclaration> calleeFunction = pUseFunction;
        Optional<CFAEdge> summaryEdge = pDefEdge;
        this.builder.node(SystemDependenceGraph.NodeType.FORMAL_IN, calleeFunction, Optional.empty(), Optional.of(pCause)).depends(SystemDependenceGraph.EdgeType.PARAMETER_EDGE, Optional.of(pCause)).on(SystemDependenceGraph.NodeType.ACTUAL_IN, callerFunction, summaryEdge, Optional.of(pCause));
        this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_IN, callerFunction, summaryEdge, Optional.of(pCause)).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, callerFunction, summaryEdge, Optional.empty());
    }

    private void insertDefReturnUseSummaryEdges(Optional<AFunctionDeclaration> pDefFunction, Optional<AFunctionDeclaration> pUseFunction, Optional<CFAEdge> pUseEdge, MemoryLocation pCause) {
        Optional<AFunctionDeclaration> callerFunction = pUseFunction;
        Optional<AFunctionDeclaration> calleeFunction = pDefFunction;
        Optional<CFAEdge> summaryEdge = pUseEdge;
        this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_OUT, callerFunction, summaryEdge, Optional.of(pCause)).depends(SystemDependenceGraph.EdgeType.PARAMETER_EDGE, Optional.of(pCause)).on(SystemDependenceGraph.NodeType.FORMAL_OUT, calleeFunction, Optional.empty(), Optional.of(pCause));
        this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_OUT, callerFunction, summaryEdge, Optional.of(pCause)).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, callerFunction, summaryEdge, Optional.empty());
    }

    private void insertUseSummaryEdges(GlobalPointerState pPointerState, ForeignDefUseData pForeignDefUseData, SystemDependenceGraph.NodeType pDefNodeType, Optional<AFunctionDeclaration> pDefFunction, Optional<CFAEdge> pDefEdge, Optional<MemoryLocation> pDefVariable, CFAEdge pUseEdge, MemoryLocation pCause, SystemDependenceGraph.EdgeType pEdgeType) {
        Optional<AFunctionDeclaration> useFunction = CSystemDependenceGraphBuilder.getOptionalFunction(pUseEdge);
        Optional<CFAEdge> useEdge = Optional.of(pUseEdge);
        CFunctionSummaryEdge summaryEdge = (CFunctionSummaryEdge)pUseEdge;
        Optional<MemoryLocation> returnVariable = this.getReturnVariable(summaryEdge);
        EdgeDefUseData defUseDataWithoutParams = this.defUseExtractor.extract(this.getFunctionCallWithoutParameters(summaryEdge));
        if (defUseDataWithoutParams.getUses().contains((Object)pCause) || defUseDataWithoutParams.getDefs().contains((Object)pCause) && pEdgeType == SystemDependenceGraph.EdgeType.DECLARATION_EDGE) {
            this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_OUT, pDefFunction, useEdge, returnVariable).depends(pEdgeType, Optional.of(pCause)).on(pDefNodeType, pDefFunction, pDefEdge, pDefVariable);
        } else {
            for (CExpression pointeeExpression : defUseDataWithoutParams.getPointeeUses()) {
                if (!pPointerState.getPossiblePointees(useEdge.orElseThrow(), pointeeExpression).contains((Object)pCause)) continue;
                this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_OUT, useFunction, useEdge, returnVariable).depends(pEdgeType, Optional.of(pCause)).on(pDefNodeType, pDefFunction, pDefEdge, pDefVariable);
            }
        }
        if (pForeignDefUseData.getForeignUses(summaryEdge.getFunctionEntry().getFunction()).contains((Object)pCause)) {
            this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_IN, useFunction, useEdge, Optional.of(pCause)).depends(pEdgeType, Optional.of(pCause)).on(pDefNodeType, pDefFunction, pDefEdge, pDefVariable);
        }
        List<CParameterDeclaration> params = summaryEdge.getFunctionEntry().getFunctionParameters();
        CFunctionCallExpression funcCallExpr = summaryEdge.getExpression().getFunctionCallExpression();
        List<CExpression> expressions = funcCallExpr.getParameterExpressions();
        for (int index = 0; index < Math.min(params.size(), expressions.size()); ++index) {
            EdgeDefUseData argDefUseData = this.defUseExtractor.extract(expressions.get(index));
            MemoryLocation paramMemLoc = MemoryLocation.forDeclaration(params.get(index));
            Optional<MemoryLocation> paramVariable = Optional.of(paramMemLoc);
            if (argDefUseData.getUses().contains((Object)pCause)) {
                this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_IN, useFunction, useEdge, paramVariable).depends(pEdgeType, Optional.of(pCause)).on(pDefNodeType, pDefFunction, pDefEdge, pDefVariable);
                continue;
            }
            for (CExpression pointeeExpression : argDefUseData.getPointeeUses()) {
                if (!pPointerState.getPossiblePointees(pUseEdge, pointeeExpression).contains((Object)pCause)) continue;
                this.builder.node(SystemDependenceGraph.NodeType.ACTUAL_IN, useFunction, useEdge, paramVariable).depends(pEdgeType, Optional.of(pCause)).on(pDefNodeType, pDefFunction, pDefEdge, pDefVariable);
            }
        }
    }

    private void insertFlowDependency(GlobalPointerState pointerState, ForeignDefUseData foreignDefUseData, CFAEdge pDefEdge, CFAEdge pUseEdge, MemoryLocation pCause, boolean pIsDeclaration) {
        Optional<AFunctionDeclaration> defFunction = CSystemDependenceGraphBuilder.getOptionalFunction(pDefEdge);
        Optional<AFunctionDeclaration> useFunction = CSystemDependenceGraphBuilder.getOptionalFunction(pUseEdge);
        Optional<CFAEdge> defEdge = Optional.of(pDefEdge);
        Optional<CFAEdge> useEdge = Optional.of(pUseEdge);
        if (pDefEdge instanceof CFunctionSummaryEdge && pUseEdge instanceof CFunctionCallEdge) {
            this.insertDefSummaryUseCallEdges(defFunction, useFunction, defEdge, pCause);
        } else if (pDefEdge instanceof CFunctionReturnEdge && pUseEdge instanceof CFunctionSummaryEdge) {
            this.insertDefReturnUseSummaryEdges(defFunction, useFunction, useEdge, pCause);
        } else {
            SystemDependenceGraph.NodeType defNodeType;
            SystemDependenceGraph.EdgeType edgeType = pIsDeclaration ? SystemDependenceGraph.EdgeType.DECLARATION_EDGE : SystemDependenceGraph.EdgeType.FLOW_DEPENDENCY;
            Optional<MemoryLocation> defNodeVariable = Optional.empty();
            if (pDefEdge instanceof CFunctionCallEdge) {
                defEdge = Optional.empty();
                defNodeType = SystemDependenceGraph.NodeType.FORMAL_IN;
                defNodeVariable = Optional.of(pCause);
            } else if (pDefEdge instanceof CFunctionReturnEdge) {
                defEdge = Optional.empty();
                defNodeType = SystemDependenceGraph.NodeType.FORMAL_OUT;
                defNodeVariable = Optional.of(pCause);
            } else if (pDefEdge instanceof CFunctionSummaryEdge) {
                defNodeType = SystemDependenceGraph.NodeType.ACTUAL_OUT;
                defNodeVariable = Optional.of(pCause);
                CFunctionSummaryEdge summaryEdge = (CFunctionSummaryEdge)pDefEdge;
                CFunctionCall functionCall = this.getFunctionCallWithoutParameters(summaryEdge);
                EdgeDefUseData defUseData = this.defUseExtractor.extract(functionCall);
                if (defUseData.getDefs().contains((Object)pCause)) {
                    defNodeVariable = this.getReturnVariable(summaryEdge);
                } else {
                    for (CExpression pointeeExpression : defUseData.getPointeeDefs()) {
                        if (!pointerState.getPossiblePointees(pDefEdge, pointeeExpression).contains((Object)pCause)) continue;
                        defNodeVariable = this.getReturnVariable(summaryEdge);
                    }
                }
            } else {
                defNodeType = SystemDependenceGraph.NodeType.STATEMENT;
            }
            if (pUseEdge instanceof CFunctionCallEdge) {
                this.builder.node(SystemDependenceGraph.NodeType.FORMAL_IN, useFunction, Optional.empty(), Optional.of(pCause)).depends(edgeType, Optional.of(pCause)).on(defNodeType, defFunction, defEdge, defNodeVariable);
            } else if (pUseEdge instanceof CFunctionReturnEdge) {
                this.builder.node(SystemDependenceGraph.NodeType.FORMAL_OUT, useFunction, Optional.empty(), Optional.of(pCause)).depends(edgeType, Optional.of(pCause)).on(defNodeType, defFunction, defEdge, defNodeVariable);
            } else if (pUseEdge instanceof CFunctionSummaryEdge) {
                this.insertUseSummaryEdges(pointerState, foreignDefUseData, defNodeType, defFunction, defEdge, defNodeVariable, pUseEdge, pCause, edgeType);
            } else {
                this.builder.node(SystemDependenceGraph.NodeType.STATEMENT, useFunction, useEdge, Optional.empty()).depends(edgeType, Optional.of(pCause)).on(defNodeType, defFunction, defEdge, defNodeVariable);
            }
        }
    }

    private void insertFlowDependencies(ImmutableSet<AFunctionDeclaration> pReachableFunctions) throws CPAException, InterruptedException {
        GlobalPointerState pointerState = this.createGlobalPointerState();
        if (pointerState == null) {
            return;
        }
        this.usedGlobalPointerState = pointerState.getClass().getSimpleName();
        this.shutdownNotifier.shutdownIfNecessary();
        ForeignDefUseData foreignDefUseData = ForeignDefUseData.extract(this.cfa, this.defUseExtractor, pointerState);
        ImmutableList<CFAEdge> globalEdges = CSystemDependenceGraphBuilder.getGlobalDeclarationEdges(this.cfa);
        ImmutableMultimap<String, CFAEdge> functionDeclarationEdges = this.getFunctionDeclarationEdges(globalEdges);
        ImmutableMultimap<String, CFAEdge> complexTypeDeclarationEdges = this.getComplexTypeDeclarationEdges(globalEdges);
        for (FunctionEntryNode entryNode : this.cfa.getAllFunctionHeads()) {
            this.shutdownNotifier.shutdownIfNecessary();
            if (this.onlyReachableFunctions && !pReachableFunctions.contains((Object)entryNode.getFunction())) continue;
            DomTree<CFANode> domTree = DominanceUtils.createFunctionDomTree(entryNode);
            this.insertFunctionDeclarationEdge(functionDeclarationEdges, entryNode);
            FlowDepAnalysis.DependenceConsumer dependenceConsumer = (pDefEdge, pUseEdge, pCause, pIsDeclaration) -> this.insertFlowDependency(pointerState, foreignDefUseData, pDefEdge, pUseEdge, pCause, pIsDeclaration);
            boolean isMain = entryNode.equals(this.cfa.getMainFunction());
            new FlowDepAnalysis(domTree, DomFrontiers.forDomTree(domTree), entryNode, (List<CFAEdge>)(isMain ? ImmutableList.of() : globalEdges), this.defUseExtractor, pointerState, foreignDefUseData, complexTypeDeclarationEdges, dependenceConsumer).run();
        }
    }

    private void insertControlDependencies(ImmutableSet<AFunctionDeclaration> pReachableFunctions) {
        for (FunctionEntryNode entryNode : this.cfa.getAllFunctionHeads()) {
            if (this.onlyReachableFunctions && !pReachableFunctions.contains((Object)entryNode.getFunction())) continue;
            ControlDependenceBuilder.insertControlDependencies(this.builder, entryNode, this.controlDepsTakeBothAssumptions);
            Optional<AFunctionDeclaration> procedure = Optional.of(entryNode.getFunction());
            for (CFAEdge edge : CFAUtils.allEnteringEdges(entryNode)) {
                if (!(edge instanceof CFunctionCallEdge)) continue;
                CFunctionCallEdge callEdge = (CFunctionCallEdge)edge;
                this.builder.node(SystemDependenceGraph.NodeType.ENTRY, procedure, Optional.empty(), Optional.empty()).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, procedure, Optional.of(callEdge), Optional.empty());
                CFunctionSummaryEdge summaryEdge = callEdge.getSummaryEdge();
                Optional<AFunctionDeclaration> summaryEdgeProcedure = Optional.of(summaryEdge.getPredecessor().getFunction());
                this.builder.node(SystemDependenceGraph.NodeType.STATEMENT, procedure, Optional.of(callEdge), Optional.empty()).depends(SystemDependenceGraph.EdgeType.CALL_EDGE, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, summaryEdgeProcedure, Optional.of(summaryEdge), Optional.empty());
            }
        }
    }

    @Override
    public void collectStatistics(Collection<Statistics> pStatsCollection) {
        pStatsCollection.add(new Statistics(){

            private String getNodeCountDescription(SystemDependenceGraph.NodeType pNodeType) {
                switch (pNodeType) {
                    case ENTRY: {
                        return "Number of entry nodes";
                    }
                    case STATEMENT: {
                        return "Number of statement nodes";
                    }
                    case FORMAL_IN: {
                        return "Number of formal-in nodes";
                    }
                    case FORMAL_OUT: {
                        return "Number of formal-out nodes";
                    }
                    case ACTUAL_IN: {
                        return "Number of actual-in nodes";
                    }
                    case ACTUAL_OUT: {
                        return "Number of actual-out nodes";
                    }
                }
                return "Number of " + pNodeType + " nodes";
            }

            private String getEdgeCountDescription(SystemDependenceGraph.EdgeType pEdgeType) {
                switch (pEdgeType) {
                    case FLOW_DEPENDENCY: {
                        return "Number of flow dependencies";
                    }
                    case CONTROL_DEPENDENCY: {
                        return "Number of control dependencies";
                    }
                    case DECLARATION_EDGE: {
                        return "Number of declaration edges";
                    }
                    case CALL_EDGE: {
                        return "Number of call edges";
                    }
                    case PARAMETER_EDGE: {
                        return "Number of parameter edges";
                    }
                    case SUMMARY_EDGE: {
                        return "Number of summary edges";
                    }
                }
                return "Number of " + pEdgeType + " edges";
            }

            @Override
            public void printStatistics(PrintStream pOut, CPAcheckerResult.Result pResult, UnmodifiableReachedSet pReached) {
                if (CSystemDependenceGraphBuilder.this.dependenceGraphConstructionTimer.getUpdateCount() > 0) {
                    String description;
                    int initialIndentation = 3;
                    int detailsIndentation = initialIndentation + 1;
                    this.put(pOut, initialIndentation, CSystemDependenceGraphBuilder.this.dependenceGraphConstructionTimer);
                    this.put(pOut, detailsIndentation, CSystemDependenceGraphBuilder.this.flowDependenceTimer);
                    this.put(pOut, detailsIndentation, CSystemDependenceGraphBuilder.this.controlDependenceTimer);
                    this.put(pOut, detailsIndentation, CSystemDependenceGraphBuilder.this.summaryEdgeTimer);
                    for (SystemDependenceGraph.NodeType nodeType : SystemDependenceGraph.NodeType.values()) {
                        int nodeCount = CSystemDependenceGraphBuilder.this.systemDependenceGraph.getNodeCount(nodeType);
                        description = this.getNodeCountDescription(nodeType);
                        this.put(pOut, detailsIndentation, description, String.valueOf(nodeCount));
                    }
                    for (Enum enum_ : SystemDependenceGraph.EdgeType.values()) {
                        int edgeCount = CSystemDependenceGraphBuilder.this.systemDependenceGraph.getEdgeCount((SystemDependenceGraph.EdgeType)enum_);
                        description = this.getEdgeCountDescription((SystemDependenceGraph.EdgeType)enum_);
                        this.put(pOut, detailsIndentation, description, String.valueOf(edgeCount));
                    }
                    this.put(pOut, detailsIndentation, "Used GlobalPointerState", CSystemDependenceGraphBuilder.this.usedGlobalPointerState);
                }
            }

            @Override
            public String getName() {
                return "";
            }
        });
    }

    private static final class CSdgDotExporter
    extends SdgDotExporter<AFunctionDeclaration, CFAEdge, MemoryLocation, CSystemDependenceGraph.Node> {
        private CSdgDotExporter() {
        }

        @Override
        protected String getProcedureLabel(AFunctionDeclaration pContext) {
            return pContext.toString();
        }

        @Override
        protected String getNodeStyle(SystemDependenceGraph.Node<AFunctionDeclaration, CFAEdge, MemoryLocation> pNode) {
            Optional<CFAEdge> optCfaEdge = pNode.getStatement();
            if (optCfaEdge.isPresent()) {
                switch (optCfaEdge.orElseThrow().getEdgeType()) {
                    case AssumeEdge: {
                        return "shape=\"diamond\",color=\"{color}\"";
                    }
                    case FunctionCallEdge: {
                        return "shape=\"ellipse\",peripheries=\"2\",color=\"{color}\"";
                    }
                    case BlankEdge: {
                        return "shape=\"box\",color=\"{color}\"";
                    }
                }
                return "shape=\"ellipse\",color=\"{color}\"";
            }
            return "";
        }

        @Override
        protected String getNodeLabel(SystemDependenceGraph.Node<AFunctionDeclaration, CFAEdge, MemoryLocation> pNode) {
            Optional<CFAEdge> optCfaEdge;
            StringBuilder sb = new StringBuilder();
            if (pNode.getType() != SystemDependenceGraph.NodeType.STATEMENT) {
                sb.append((Object)pNode.getType());
                sb.append(" of ");
                if (pNode.getType() == SystemDependenceGraph.NodeType.ENTRY) {
                    sb.append((Object)pNode.getProcedure().orElse(null));
                } else {
                    sb.append((Object)pNode.getVariable().orElse(null));
                }
                sb.append("\\n");
            }
            if ((optCfaEdge = pNode.getStatement()).isPresent()) {
                CFAEdge cfaEdge = optCfaEdge.orElseThrow();
                sb.append(cfaEdge.getPredecessor());
                sb.append(" ---> ");
                sb.append(cfaEdge.getSuccessor());
                sb.append(", ");
                sb.append(cfaEdge.getFileLocation());
                sb.append(":\\n");
                sb.append(cfaEdge.getDescription());
            }
            return sb.toString();
        }

        @Override
        protected boolean isHighlighted(SystemDependenceGraph.Node<AFunctionDeclaration, CFAEdge, MemoryLocation> pNode) {
            return false;
        }

        @Override
        protected boolean isHighlighted(SystemDependenceGraph.EdgeType pEdgeType, SystemDependenceGraph.Node<AFunctionDeclaration, CFAEdge, MemoryLocation> pPredecessor, SystemDependenceGraph.Node<AFunctionDeclaration, CFAEdge, MemoryLocation> pSuccessor) {
            return false;
        }
    }

    private static enum PointerStateComputationMethod {
        FLOW_SENSITIVE,
        FLOW_INSENSITIVE;

    }
}

