/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

final class CallGraph<P> {
    private final ImmutableList<Node.ImmutableNode<P>> nodes;
    private final ImmutableMap<P, Node.ImmutableNode<P>> nodeMap;

    private CallGraph(ImmutableList<Node.ImmutableNode<P>> pNodes, ImmutableMap<P, Node.ImmutableNode<P>> pNodeMap) {
        this.nodes = pNodes;
        this.nodeMap = pNodeMap;
    }

    private static <P> Node.MutableNode<P> createNodeIfAbsent(List<Node.MutableNode<P>> pNodes, Map<P, Node.MutableNode<P>> pNodeMap, P pProcedure) {
        Node.MutableNode node = pNodeMap.computeIfAbsent(pProcedure, key -> new Node.MutableNode<Object>(pNodes.size(), key));
        if (pNodeMap.size() > pNodes.size()) {
            pNodes.add(node);
        }
        return node;
    }

    private static <P> void insertEdge(List<Node.MutableNode<P>> pNodes, Map<P, Node.MutableNode<P>> pNodeMap, P pPredecessor, P pSuccessor) {
        Node.MutableNode<P> predecessorCallNode = CallGraph.createNodeIfAbsent(pNodes, pNodeMap, pPredecessor);
        Node.MutableNode<P> successorCallNode = CallGraph.createNodeIfAbsent(pNodes, pNodeMap, pSuccessor);
        predecessorCallNode.addSuccessor(successorCallNode);
        successorCallNode.addPredecessor(predecessorCallNode);
    }

    /*
     * WARNING - void declaration
     */
    static <P, N> CallGraph<P> createCallGraph(Function<? super N, ? extends Iterable<? extends SuccessorResult<? extends P, ? extends N>>> pSuccessorFunction, Collection<? extends N> pStartNodes) {
        void var11_15;
        ArrayList<Node.MutableNode<P>> nodes = new ArrayList<Node.MutableNode<P>>();
        HashMap nodeMap = new HashMap();
        ArrayDeque waitlist = new ArrayDeque();
        HashSet waitlisted = new HashSet();
        for (Object startNode : pStartNodes) {
            if (!waitlisted.add(startNode)) continue;
            waitlist.add(startNode);
        }
        while (!waitlist.isEmpty()) {
            Object node = waitlist.remove();
            for (SuccessorResult successorResult : pSuccessorFunction.apply(node)) {
                Object successor;
                if (successorResult.getType() == SuccessorResult.Type.CALL_EDGE) {
                    CallGraph.insertEdge(nodes, nodeMap, successorResult.getPredecessorProcedure(), successorResult.getSuccessorProcedure());
                }
                if (!waitlisted.add(successor = successorResult.getSucessor())) continue;
                waitlist.add(successor);
            }
        }
        ImmutableList.Builder immutableNodesBuilder = ImmutableList.builderWithExpectedSize((int)nodes.size());
        ArrayList<ImmutableList.Builder> immutablePredecessors = new ArrayList<ImmutableList.Builder>(nodes.size());
        ArrayList<ImmutableList.Builder> arrayList = new ArrayList<ImmutableList.Builder>(nodes.size());
        ImmutableMap.Builder immutableNodeMapBuilder = ImmutableMap.builderWithExpectedSize((int)nodeMap.size());
        for (Node.MutableNode mutableNode : nodes) {
            Node.ImmutableNode immutableNode = new Node.ImmutableNode(mutableNode.getId(), mutableNode.getProcedure());
            immutableNodesBuilder.add(immutableNode);
            immutablePredecessors.add(ImmutableList.builderWithExpectedSize((int)mutableNode.getPredecessors().size()));
            arrayList.add(ImmutableList.builderWithExpectedSize((int)mutableNode.getSuccessors().size()));
            immutableNodeMapBuilder.put(immutableNode.getProcedure(), immutableNode);
        }
        ImmutableList immutableNodes = immutableNodesBuilder.build();
        for (Node.MutableNode mutableNode : nodes) {
            int predecessorId = mutableNode.getId();
            for (Node mutableSuccessorNode : mutableNode.getSuccessors()) {
                int successorId = mutableSuccessorNode.getId();
                ((ImmutableList.Builder)immutablePredecessors.get(successorId)).add((Object)((Node)immutableNodes.get(predecessorId)));
                ((ImmutableList.Builder)arrayList.get(predecessorId)).add((Object)((Node)immutableNodes.get(successorId)));
            }
        }
        boolean bl = false;
        while (var11_15 < immutableNodes.size()) {
            Node.ImmutableNode immutableNode = (Node.ImmutableNode)immutableNodes.get((int)var11_15);
            immutableNode.predecessors = ((ImmutableList.Builder)immutablePredecessors.get((int)var11_15)).build();
            immutableNode.successors = ((ImmutableList.Builder)arrayList.get((int)var11_15)).build();
            ++var11_15;
        }
        return new CallGraph<P>(immutableNodes, immutableNodeMapBuilder.buildOrThrow());
    }

    Optional<Node<P>> getNode(P pProcedure) {
        return Optional.ofNullable((Node)this.nodeMap.get(pProcedure));
    }

    Node<P> getNodeById(int pId) {
        return (Node)this.nodes.get(pId);
    }

    ImmutableSet<P> getReachableFrom(Collection<? extends P> pProcedures) {
        ArrayDeque<Node> waitlist = new ArrayDeque<Node>();
        HashSet<Node> waitlisted = new HashSet<Node>();
        for (P procedure : pProcedures) {
            Node node2 = (Node)this.nodeMap.get(procedure);
            if (node2 == null || !waitlisted.add(node2)) continue;
            waitlist.add(node2);
        }
        while (!waitlist.isEmpty()) {
            for (Node successor : ((Node)waitlist.remove()).getSuccessors()) {
                if (!waitlisted.add(successor)) continue;
                waitlist.add(successor);
            }
        }
        ImmutableSet.Builder builder = ImmutableSet.builderWithExpectedSize((int)waitlisted.size());
        waitlisted.forEach(node -> builder.add(node.getProcedure()));
        return builder.build();
    }

    ImmutableSet<P> getRecursiveProcedures() {
        ArrayDeque<Node> waitlist = new ArrayDeque<Node>();
        HashMultimap callers = HashMultimap.create();
        for (Node caller : this.nodes) {
            for (Node callee : caller.getSuccessors()) {
                if (!callers.put((Object)callee, (Object)caller)) continue;
                waitlist.add(callee);
            }
        }
        while (!waitlist.isEmpty()) {
            Node node = (Node)waitlist.remove();
            Collection nodeCallers = callers.get((Object)node);
            for (Node nodeCallee : node.getSuccessors()) {
                if (!callers.putAll((Object)nodeCallee, (Iterable)nodeCallers)) continue;
                waitlist.add(nodeCallee);
            }
        }
        HashSet recursiveProcedures = new HashSet();
        for (Node node : this.nodes) {
            if (!callers.containsEntry((Object)node, (Object)node)) continue;
            recursiveProcedures.add(node.getProcedure());
        }
        return ImmutableSet.copyOf(recursiveProcedures);
    }

    ImmutableList<P> getPostOrder(P pStart) {
        Node startNode = (Node)this.nodeMap.get(pStart);
        if (startNode == null) {
            return ImmutableList.of();
        }
        ArrayList postOrderList = new ArrayList();
        ArrayDeque<Node> stack = new ArrayDeque<Node>();
        HashSet<Node> stacked = new HashSet<Node>();
        stack.push(startNode);
        stacked.add(startNode);
        block0: while (!stack.isEmpty()) {
            Node caller = (Node)stack.peek();
            for (Node callee : caller.getSuccessors()) {
                if (!stacked.add(callee)) continue;
                stack.push(callee);
                continue block0;
            }
            postOrderList.add(((Node)stack.pop()).getProcedure());
        }
        return ImmutableList.copyOf((Collection)Lists.reverse(postOrderList));
    }

    public String toString() {
        return this.getClass().getSimpleName() + this.nodes;
    }

    static abstract class Node<P> {
        private int id;
        private final P procedure;

        private Node(int pId, P pProcedure) {
            this.id = pId;
            this.procedure = pProcedure;
        }

        final int getId() {
            return this.id;
        }

        final P getProcedure() {
            return this.procedure;
        }

        abstract ImmutableList<Node<P>> getPredecessors();

        abstract ImmutableList<Node<P>> getSuccessors();

        public final String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(CallGraph.class.getSimpleName());
            sb.append('.');
            sb.append(this.getClass().getSimpleName());
            sb.append('[');
            sb.append("id=");
            sb.append(this.id);
            sb.append(',');
            sb.append("procedure='");
            sb.append(this.procedure.toString());
            sb.append("',");
            sb.append("predecessors=");
            List predecessorProcedures = (List)this.getPredecessors().stream().map(Node::getProcedure).collect(ImmutableList.toImmutableList());
            sb.append(predecessorProcedures.toString());
            sb.append(',');
            sb.append("successors=");
            List successorProcedures = (List)this.getSuccessors().stream().map(Node::getProcedure).collect(ImmutableList.toImmutableList());
            sb.append(successorProcedures.toString());
            sb.append(']');
            return sb.toString();
        }

        private static final class ImmutableNode<P>
        extends Node<P> {
            private ImmutableList<Node<P>> predecessors;
            private ImmutableList<Node<P>> successors;

            private ImmutableNode(int pId, P pProcedure) {
                super(pId, pProcedure);
            }

            @Override
            ImmutableList<Node<P>> getPredecessors() {
                return this.predecessors;
            }

            @Override
            ImmutableList<Node<P>> getSuccessors() {
                return this.successors;
            }
        }

        private static final class MutableNode<P>
        extends Node<P> {
            private final List<Node<P>> predecessors = new ArrayList<Node<P>>();
            private final List<Node<P>> successors = new ArrayList<Node<P>>();

            private MutableNode(int pId, P pProcedure) {
                super(pId, pProcedure);
            }

            @Override
            ImmutableList<Node<P>> getPredecessors() {
                return ImmutableList.copyOf(this.predecessors);
            }

            private void addPredecessor(Node<P> pNode) {
                this.predecessors.add(pNode);
            }

            @Override
            ImmutableList<Node<P>> getSuccessors() {
                return ImmutableList.copyOf(this.successors);
            }

            private void addSuccessor(Node<P> pNode) {
                this.successors.add(pNode);
            }
        }
    }

    static final class SuccessorResult<P, N> {
        private final Type type;
        private final P predecessorProcedure;
        private final P successorProcedure;
        private final N sucessor;

        private SuccessorResult(Type pType, P pPredecessorProcedure, P pSuccessorProcedure, N pSucessor) {
            this.type = pType;
            this.predecessorProcedure = pPredecessorProcedure;
            this.successorProcedure = pSuccessorProcedure;
            this.sucessor = pSucessor;
        }

        static <P, N> SuccessorResult<P, N> createNonCallSuccessor(P pProcedure, N pSuccessor) {
            return new SuccessorResult<P, N>(Type.NON_CALL_EDGE, pProcedure, pProcedure, pSuccessor);
        }

        static <P, N> SuccessorResult<P, N> createCallSuccessor(P pCallerProcedure, P pCalleeProcedure, N pSuccessor) {
            return new SuccessorResult<P, N>(Type.CALL_EDGE, pCallerProcedure, pCalleeProcedure, pSuccessor);
        }

        private Type getType() {
            return this.type;
        }

        private P getPredecessorProcedure() {
            return this.predecessorProcedure;
        }

        private P getSuccessorProcedure() {
            return this.successorProcedure;
        }

        private N getSucessor() {
            return this.sucessor;
        }

        private static enum Type {
            NON_CALL_EDGE,
            CALL_EDGE;

        }
    }
}

