/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.CallGraph;

final class CallGraphUtils {
    CallGraphUtils() {
    }

    private static List<CallGraph.SuccessorResult<AFunctionDeclaration, CFANode>> getSuccessorResults(CFANode pNode) {
        ArrayList<CallGraph.SuccessorResult<AFunctionDeclaration, CFANode>> edges = new ArrayList<CallGraph.SuccessorResult<AFunctionDeclaration, CFANode>>();
        for (CFAEdge edge : CFAUtils.leavingEdges(pNode)) {
            if (edge.getEdgeType() == CFAEdgeType.FunctionCallEdge) {
                CFANode successor = edge.getSuccessor();
                edges.add(CallGraph.SuccessorResult.createCallSuccessor(pNode.getFunction(), successor.getFunction(), successor));
                continue;
            }
            edges.add(CallGraph.SuccessorResult.createNonCallSuccessor(pNode.getFunction(), edge.getSuccessor()));
        }
        return edges;
    }

    static CallGraph<AFunctionDeclaration> createCallGraph(CFA pCfa) {
        return CallGraph.createCallGraph(CallGraphUtils::getSuccessorResults, ImmutableSet.of((Object)pCfa.getMainFunction()));
    }
}

