/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFAEdgeType;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.util.CFATraversal;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.SystemDependenceGraph;
import org.sosy_lab.cpachecker.util.graph.dominance.DomFrontiers;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;
import org.sosy_lab.cpachecker.util.graph.dominance.DominanceUtils;

final class ControlDependenceBuilder<N extends SystemDependenceGraph.Node<AFunctionDeclaration, CFAEdge, ?>> {
    private final SystemDependenceGraph.Builder<AFunctionDeclaration, CFAEdge, ?, N> builder;
    private final Optional<AFunctionDeclaration> procedure;
    private final Set<CFAEdge> dependentEdges;

    private ControlDependenceBuilder(SystemDependenceGraph.Builder<AFunctionDeclaration, CFAEdge, ?, N> pBuilder, FunctionEntryNode pEntryNode) {
        this.builder = pBuilder;
        this.procedure = Optional.of(pEntryNode.getFunction());
        this.dependentEdges = new HashSet<CFAEdge>();
    }

    private static boolean ignoreFunctionEdge(CFAEdge pEdge) {
        return pEdge.getEdgeType() == CFAEdgeType.FunctionCallEdge;
    }

    private static Iterable<CFAEdge> functionEdges(Set<CFANode> pFunctionNodes) {
        return FluentIterable.from(pFunctionNodes).transformAndConcat(CFAUtils::allLeavingEdges).filter(edge -> !ControlDependenceBuilder.ignoreFunctionEdge(edge));
    }

    static void insertControlDependencies(SystemDependenceGraph.Builder<AFunctionDeclaration, CFAEdge, ?, ?> pBuilder, FunctionEntryNode pEntryNode, boolean pDependOnBothAssumptions) {
        ControlDependenceBuilder controlDependenceBuilder = new ControlDependenceBuilder(pBuilder, pEntryNode);
        DomTree<CFANode> postDomTree = DominanceUtils.createFunctionPostDomTree(pEntryNode);
        HashSet<CFANode> postDomTreeNodes = new HashSet<CFANode>();
        Iterators.addAll(postDomTreeNodes, postDomTree.iterator());
        controlDependenceBuilder.insertControlDependencies(postDomTree, postDomTreeNodes, pDependOnBothAssumptions);
        CFATraversal.NodeCollectingCFAVisitor nodeCollector = new CFATraversal.NodeCollectingCFAVisitor();
        CFATraversal.dfs().ignoreFunctionCalls().traverse(pEntryNode, nodeCollector);
        controlDependenceBuilder.insertMissingControlDependencies(postDomTree, postDomTreeNodes, nodeCollector.getVisitedNodes());
        controlDependenceBuilder.insertEntryControlDependencies(nodeCollector.getVisitedNodes());
    }

    private void insertControlDependencies(DomTree<CFANode> pPostDomTree, Set<CFANode> pPostDomTreeNodes, boolean pDependOnBothAssumptions) {
        DomFrontiers<CFANode> frontiers = DomFrontiers.forDomTree(pPostDomTree);
        for (CFANode dependentNode : pPostDomTree) {
            for (CFANode branchNode : frontiers.getFrontier(dependentNode)) {
                for (CFAEdge assumeEdge : CFAUtils.leavingEdges(branchNode)) {
                    CFANode assumeSuccessor = assumeEdge.getSuccessor();
                    if (!pPostDomTreeNodes.contains(assumeSuccessor) || !pDependOnBothAssumptions && !assumeSuccessor.equals(dependentNode) && !pPostDomTree.isAncestorOf(dependentNode, assumeSuccessor)) continue;
                    for (CFAEdge dependentEdge : CFAUtils.allLeavingEdges(dependentNode)) {
                        if (ControlDependenceBuilder.ignoreFunctionEdge(dependentEdge) || assumeEdge.equals(dependentEdge)) continue;
                        Optional<CFAEdge> dependentStatement = Optional.of(dependentEdge);
                        Optional<CFAEdge> controlStatement = Optional.of(assumeEdge);
                        this.builder.node(SystemDependenceGraph.NodeType.STATEMENT, this.procedure, dependentStatement, Optional.empty()).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, this.procedure, controlStatement, Optional.empty());
                        this.dependentEdges.add(dependentEdge);
                    }
                }
            }
        }
    }

    private void insertMissingControlDependencies(DomTree<CFANode> pPostDomTree, Set<CFANode> pPostDomTreeNodes, Set<CFANode> pFunctionNodes) {
        HashSet edgesWithoutDominator = new HashSet();
        for (CFANode node : pFunctionNodes) {
            if (node instanceof FunctionExitNode || pPostDomTreeNodes.contains(node) && !pPostDomTree.getParent(node).isEmpty()) continue;
            Iterables.addAll(edgesWithoutDominator, CFAUtils.allEnteringEdges(node));
            Iterables.addAll(edgesWithoutDominator, CFAUtils.allLeavingEdges(node));
        }
        HashSet<CFAEdge> assumeEdgesWithoutDominator = new HashSet<CFAEdge>();
        for (CFAEdge edge : edgesWithoutDominator) {
            if (edge.getEdgeType() != CFAEdgeType.AssumeEdge) continue;
            assumeEdgesWithoutDominator.add(edge);
        }
        for (CFAEdge dependentEdge : edgesWithoutDominator) {
            if (ControlDependenceBuilder.ignoreFunctionEdge(dependentEdge)) continue;
            for (CFAEdge assumeEdge : assumeEdgesWithoutDominator) {
                if (assumeEdge.equals(dependentEdge)) continue;
                Optional<CFAEdge> dependentStatement = Optional.of(dependentEdge);
                Optional<CFAEdge> controlStatement = Optional.of(assumeEdge);
                this.builder.node(SystemDependenceGraph.NodeType.STATEMENT, this.procedure, dependentStatement, Optional.empty()).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.STATEMENT, this.procedure, controlStatement, Optional.empty());
                this.dependentEdges.add(dependentEdge);
            }
        }
    }

    private void insertEntryControlDependencies(Set<CFANode> pFunctionNodes) {
        for (CFAEdge edge : ControlDependenceBuilder.functionEdges(pFunctionNodes)) {
            if (this.dependentEdges.contains(edge)) continue;
            this.builder.node(SystemDependenceGraph.NodeType.STATEMENT, this.procedure, Optional.of(edge), Optional.empty()).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.ENTRY, this.procedure, Optional.empty(), Optional.empty());
        }
        final HashSet entryNodeDependent = new HashSet();
        Object entryNode = this.builder.node(SystemDependenceGraph.NodeType.ENTRY, this.procedure, Optional.empty(), Optional.empty()).getNode();
        this.builder.traverse((Collection<N>)ImmutableSet.of(entryNode), new SystemDependenceGraph.ForwardsVisitor<N>(){

            @Override
            public SystemDependenceGraph.VisitResult visitNode(N pNode) {
                if (((SystemDependenceGraph.Node)pNode).getType() == SystemDependenceGraph.NodeType.ENTRY) {
                    return SystemDependenceGraph.VisitResult.CONTINUE;
                }
                Optional statement = ((SystemDependenceGraph.Node)pNode).getStatement();
                if (statement.isPresent() && entryNodeDependent.add((CFAEdge)statement.orElseThrow())) {
                    return SystemDependenceGraph.VisitResult.CONTINUE;
                }
                return SystemDependenceGraph.VisitResult.SKIP;
            }

            @Override
            public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, N pPredecessor, N pSuccessor) {
                return pType == SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY ? SystemDependenceGraph.VisitResult.CONTINUE : SystemDependenceGraph.VisitResult.SKIP;
            }
        });
        for (CFAEdge edge : ControlDependenceBuilder.functionEdges(pFunctionNodes)) {
            if (entryNodeDependent.contains(edge)) continue;
            this.builder.node(SystemDependenceGraph.NodeType.STATEMENT, this.procedure, Optional.of(edge), Optional.empty()).depends(SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, Optional.empty()).on(SystemDependenceGraph.NodeType.ENTRY, this.procedure, Optional.empty(), Optional.empty());
        }
    }
}

