/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.base.Equivalence;
import com.google.common.collect.ImmutableSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAddressOfLabelExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArrayRangeDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CArraySubscriptExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNode;
import org.sosy_lab.cpachecker.cfa.ast.c.CAstNodeVisitor;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CCharLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexCastExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CComplexTypeDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignatedInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldDesignator;
import org.sosy_lab.cpachecker.cfa.ast.c.CFieldReference;
import org.sosy_lab.cpachecker.cfa.ast.c.CFloatLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallAssignmentStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionCallStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CImaginaryLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializer;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CInitializerList;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CPointerExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CReturnStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CSimpleDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CStringLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeDefDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CTypeIdExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CUnaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CEnumType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

public final class EdgeDefUseData {
    private final ImmutableSet<MemoryLocation> defs;
    private final ImmutableSet<MemoryLocation> uses;
    private final ImmutableSet<CExpression> pointeeDefs;
    private final ImmutableSet<CExpression> pointeeUses;
    private final boolean partialDefs;

    private EdgeDefUseData(ImmutableSet<MemoryLocation> pDefs, ImmutableSet<MemoryLocation> pUses, ImmutableSet<CExpression> pPointeeDefs, ImmutableSet<CExpression> pPointeeUses, boolean pPartialDefs) {
        this.defs = pDefs;
        this.uses = pUses;
        this.pointeeDefs = pPointeeDefs;
        this.pointeeUses = pPointeeUses;
        this.partialDefs = pPartialDefs;
    }

    public ImmutableSet<MemoryLocation> getDefs() {
        return this.defs;
    }

    public ImmutableSet<MemoryLocation> getUses() {
        return this.uses;
    }

    public ImmutableSet<CExpression> getPointeeDefs() {
        return this.pointeeDefs;
    }

    public ImmutableSet<CExpression> getPointeeUses() {
        return this.pointeeUses;
    }

    public boolean hasPartialDefs() {
        return this.partialDefs;
    }

    public static Extractor createExtractor(final boolean pConsiderPointees) {
        return new Extractor(){

            private EdgeDefUseData createEdgeDefUseData(Collector pCollector) {
                ImmutableSet pointeeUses;
                ImmutableSet pointeeDefs;
                ImmutableSet defs = ImmutableSet.copyOf(pCollector.defs);
                ImmutableSet uses = ImmutableSet.copyOf(pCollector.uses);
                if (pConsiderPointees) {
                    pointeeDefs = ImmutableSet.copyOf(pCollector.pointeeDefs);
                    pointeeUses = ImmutableSet.copyOf(pCollector.pointeeUses);
                } else {
                    pointeeDefs = ImmutableSet.of();
                    pointeeUses = ImmutableSet.of();
                }
                return new EdgeDefUseData((ImmutableSet<MemoryLocation>)defs, (ImmutableSet<MemoryLocation>)uses, (ImmutableSet<CExpression>)pointeeDefs, (ImmutableSet<CExpression>)pointeeUses, pCollector.partialDefs);
            }

            @Override
            public EdgeDefUseData extract(CFAEdge pEdge) {
                AAstNode astNode;
                Optional<AAstNode> optAstNode = pEdge.getRawAST();
                if (optAstNode.isPresent() && (astNode = optAstNode.orElseThrow()) instanceof CAstNode) {
                    CAstNode cAstNode = (CAstNode)astNode;
                    Collector collector = new Collector(pConsiderPointees);
                    cAstNode.accept(collector);
                    return this.createEdgeDefUseData(collector);
                }
                return new EdgeDefUseData((ImmutableSet<MemoryLocation>)ImmutableSet.of(), (ImmutableSet<MemoryLocation>)ImmutableSet.of(), (ImmutableSet<CExpression>)ImmutableSet.of(), (ImmutableSet<CExpression>)ImmutableSet.of(), false);
            }

            @Override
            public EdgeDefUseData extract(CAstNode pAstNode) {
                Collector collector = new Collector(pConsiderPointees);
                pAstNode.accept(collector);
                return this.createEdgeDefUseData(collector);
            }
        };
    }

    public String toString() {
        return String.format("[defs: %s, uses: %s, pointee-defs: %s, pointee-uses: %s]", this.defs.toString(), this.uses.toString(), this.pointeeDefs.toString(), this.pointeeUses.toString());
    }

    private static enum Mode {
        DEF,
        USE;

    }

    private static class Collector
    implements CAstNodeVisitor<Void, NoException> {
        private final boolean considerPointees;
        private final Set<MemoryLocation> defs;
        private final Set<MemoryLocation> uses;
        private final Set<CExpression> pointeeDefs;
        private final Set<CExpression> pointeeUses;
        private boolean partialDefs;
        private Mode mode;

        private Collector(boolean pConsiderPointees) {
            this.considerPointees = pConsiderPointees;
            this.partialDefs = false;
            this.mode = Mode.USE;
            this.defs = new HashSet<MemoryLocation>();
            this.uses = new HashSet<MemoryLocation>();
            if (this.considerPointees) {
                this.pointeeDefs = new HashSet<CExpression>();
                this.pointeeUses = new HashSet<CExpression>();
            } else {
                this.pointeeDefs = null;
                this.pointeeUses = null;
            }
        }

        @Override
        public Void visit(CArrayDesignator pArrayDesignator) {
            pArrayDesignator.getSubscriptExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CArrayRangeDesignator pArrayRangeDesignator) {
            pArrayRangeDesignator.getFloorExpression().accept(this);
            pArrayRangeDesignator.getCeilExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CFieldDesignator pFieldDesignator) {
            return null;
        }

        @Override
        public Void visit(CInitializerExpression pInitializerExpression) {
            pInitializerExpression.getExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CInitializerList pInitializerList) {
            for (CInitializer initializer : pInitializerList.getInitializers()) {
                initializer.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CDesignatedInitializer pCStructInitializerPart) {
            pCStructInitializerPart.getRightHandSide().accept(this);
            for (CDesignator designator : pCStructInitializerPart.getDesignators()) {
                designator.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CFunctionCallExpression pIastFunctionCallExpression) {
            pIastFunctionCallExpression.getFunctionNameExpression().accept(this);
            for (CExpression expression : pIastFunctionCallExpression.getParameterExpressions()) {
                expression.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CBinaryExpression pIastBinaryExpression) {
            pIastBinaryExpression.getOperand1().accept(this);
            pIastBinaryExpression.getOperand2().accept(this);
            return null;
        }

        @Override
        public Void visit(CCastExpression pIastCastExpression) {
            pIastCastExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CCharLiteralExpression pIastCharLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CFloatLiteralExpression pIastFloatLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CIntegerLiteralExpression pIastIntegerLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CStringLiteralExpression pIastStringLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CTypeIdExpression pIastTypeIdExpression) {
            return null;
        }

        @Override
        public Void visit(CUnaryExpression pIastUnaryExpression) {
            pIastUnaryExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CImaginaryLiteralExpression PIastLiteralExpression) {
            return null;
        }

        @Override
        public Void visit(CAddressOfLabelExpression pAddressOfLabelExpression) {
            return null;
        }

        @Override
        public Void visit(CArraySubscriptExpression pIastArraySubscriptExpression) {
            Mode prev = this.mode;
            pIastArraySubscriptExpression.getArrayExpression().accept(this);
            this.mode = Mode.USE;
            pIastArraySubscriptExpression.getSubscriptExpression().accept(this);
            this.mode = prev;
            if (this.mode == Mode.DEF) {
                this.partialDefs = true;
            }
            return null;
        }

        @Override
        public Void visit(CFieldReference pIastFieldReference) {
            if (pIastFieldReference.isPointerDereference()) {
                Mode prev = this.mode;
                this.mode = Mode.USE;
                pIastFieldReference.getFieldOwner().accept(this);
                this.mode = prev;
                if (this.considerPointees) {
                    Set<CExpression> pointeeSet = this.mode == Mode.USE ? this.pointeeUses : this.pointeeDefs;
                    pointeeSet.add(pIastFieldReference);
                }
            } else {
                pIastFieldReference.getFieldOwner().accept(this);
            }
            if (this.mode == Mode.DEF) {
                this.partialDefs = true;
            }
            CType type = pIastFieldReference.getFieldOwner().getExpressionType();
            while (type instanceof CPointerType) {
                type = ((CPointerType)type).getType();
            }
            if (type instanceof CComplexType) {
                String name = ((CComplexType)type).getQualifiedName();
                Set<MemoryLocation> set = this.mode == Mode.USE ? this.uses : this.defs;
                set.add(MemoryLocation.parseExtendedQualifiedName(name));
            }
            return null;
        }

        @Override
        public Void visit(CIdExpression pIastIdExpression) {
            CSimpleDeclaration declaration = pIastIdExpression.getDeclaration();
            if (declaration instanceof CVariableDeclaration || declaration instanceof CParameterDeclaration) {
                MemoryLocation memLoc = MemoryLocation.forDeclaration(declaration);
                Set<MemoryLocation> set = this.mode == Mode.USE ? this.uses : this.defs;
                set.add(memLoc);
            }
            return null;
        }

        @Override
        public Void visit(CPointerExpression pPointerExpression) {
            Mode prev = this.mode;
            this.mode = Mode.USE;
            pPointerExpression.getOperand().accept(this);
            this.mode = prev;
            if (this.considerPointees) {
                Set<CExpression> pointeeSet = this.mode == Mode.USE ? this.pointeeUses : this.pointeeDefs;
                pointeeSet.add(pPointerExpression);
            }
            return null;
        }

        @Override
        public Void visit(CComplexCastExpression pComplexCastExpression) {
            pComplexCastExpression.getOperand().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionDeclaration pDecl) {
            for (CParameterDeclaration declaration : pDecl.getParameters()) {
                declaration.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CComplexTypeDeclaration pDecl) {
            return null;
        }

        @Override
        public Void visit(CTypeDefDeclaration pDecl) {
            return null;
        }

        @Override
        public Void visit(CVariableDeclaration pDecl) {
            MemoryLocation memLoc = MemoryLocation.forDeclaration(pDecl);
            this.defs.add(memLoc);
            CInitializer initializer = pDecl.getInitializer();
            if (initializer != null) {
                this.mode = Mode.USE;
                initializer.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CParameterDeclaration pDecl) {
            if (pDecl.getQualifiedName() != null) {
                pDecl.asVariableDeclaration().accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CEnumType.CEnumerator pDecl) {
            return null;
        }

        @Override
        public Void visit(CExpressionStatement pIastExpressionStatement) {
            pIastExpressionStatement.getExpression().accept(this);
            return null;
        }

        @Override
        public Void visit(CExpressionAssignmentStatement pIastExpressionAssignmentStatement) {
            this.mode = Mode.DEF;
            pIastExpressionAssignmentStatement.getLeftHandSide().accept(this);
            this.mode = Mode.USE;
            pIastExpressionAssignmentStatement.getRightHandSide().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionCallAssignmentStatement pIastFunctionCallAssignmentStatement) {
            this.mode = Mode.DEF;
            pIastFunctionCallAssignmentStatement.getLeftHandSide().accept(this);
            this.mode = Mode.USE;
            pIastFunctionCallAssignmentStatement.getRightHandSide().accept(this);
            return null;
        }

        @Override
        public Void visit(CFunctionCallStatement pIastFunctionCallStatement) {
            List<CExpression> paramExpressions = pIastFunctionCallStatement.getFunctionCallExpression().getParameterExpressions();
            for (CExpression expression : paramExpressions) {
                expression.accept(this);
            }
            CFunctionDeclaration declaration = pIastFunctionCallStatement.getFunctionCallExpression().getDeclaration();
            if (declaration != null) {
                declaration.accept(this);
            }
            return null;
        }

        @Override
        public Void visit(CReturnStatement pNode) {
            Optional<CExpression> optExpression = pNode.getReturnValue();
            if (optExpression.isPresent()) {
                return optExpression.orElseThrow().accept(this);
            }
            return null;
        }
    }

    public static final class CachingExtractor
    implements Extractor {
        private final Extractor delegateExtractor;
        private final Map<Equivalence.Wrapper<Object>, EdgeDefUseData> cache;

        public CachingExtractor(Extractor pDelegateExtractor) {
            this.delegateExtractor = pDelegateExtractor;
            this.cache = new HashMap<Equivalence.Wrapper<Object>, EdgeDefUseData>();
        }

        @Override
        public EdgeDefUseData extract(CFAEdge pEdge) {
            return this.cache.computeIfAbsent((Equivalence.Wrapper<Object>)Equivalence.identity().wrap((Object)pEdge), key -> this.delegateExtractor.extract(pEdge));
        }

        @Override
        public EdgeDefUseData extract(CAstNode pAstNode) {
            return this.cache.computeIfAbsent((Equivalence.Wrapper<Object>)Equivalence.identity().wrap((Object)pAstNode), key -> this.delegateExtractor.extract(pAstNode));
        }
    }

    public static interface Extractor {
        public EdgeDefUseData extract(CFAEdge var1);

        public EdgeDefUseData extract(CAstNode var1);
    }
}

