/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AParameterDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.AVariableDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.FunctionEntryNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionExitNode;
import org.sosy_lab.cpachecker.cfa.model.FunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CDeclarationEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionCallEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryStatementEdge;
import org.sosy_lab.cpachecker.cfa.types.c.CComplexType;
import org.sosy_lab.cpachecker.cfa.types.c.CPointerType;
import org.sosy_lab.cpachecker.cfa.types.c.CType;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.EdgeDefUseData;
import org.sosy_lab.cpachecker.util.dependencegraph.ForeignDefUseData;
import org.sosy_lab.cpachecker.util.dependencegraph.GlobalPointerState;
import org.sosy_lab.cpachecker.util.dependencegraph.ReachDefAnalysis;
import org.sosy_lab.cpachecker.util.graph.dominance.DomFrontiers;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

final class FlowDepAnalysis
extends ReachDefAnalysis<MemoryLocation, CFANode, CFAEdge> {
    private final FunctionEntryNode entryNode;
    private final List<CFAEdge> globalEdges;
    private final EdgeDefUseData.Extractor defUseExtractor;
    private final GlobalPointerState pointerState;
    private final ForeignDefUseData foreignDefUseData;
    private final ImmutableMultimap<String, CFAEdge> complexTypeDeclarationEdges;
    private final DependenceConsumer dependenceConsumer;
    private final Multimap<CFAEdge, ReachDefAnalysis.Def<MemoryLocation, CFAEdge>> flowDeps;
    private final Multimap<CFAEdge, ReachDefAnalysis.Def<MemoryLocation, CFAEdge>> declDeps;
    private final Multimap<CFAEdge, MemoryLocation> maybeDefs;

    FlowDepAnalysis(DomTree<CFANode> pDomTree, DomFrontiers<CFANode> pDomFrontiers, FunctionEntryNode pEntryNode, List<CFAEdge> pGlobalEdges, EdgeDefUseData.Extractor pDefUseExtractor, GlobalPointerState pPointerState, ForeignDefUseData pForeignDefUseData, ImmutableMultimap<String, CFAEdge> pComplexTypeDeclarationEdges, DependenceConsumer pDependenceConsumer) {
        super(SingleFunctionGraph.INSTANCE, pDomTree, pDomFrontiers);
        this.entryNode = pEntryNode;
        this.globalEdges = pGlobalEdges;
        this.defUseExtractor = pDefUseExtractor;
        this.pointerState = pPointerState;
        this.foreignDefUseData = pForeignDefUseData;
        this.complexTypeDeclarationEdges = pComplexTypeDeclarationEdges;
        this.dependenceConsumer = pDependenceConsumer;
        this.flowDeps = ArrayListMultimap.create();
        this.declDeps = ArrayListMultimap.create();
        this.maybeDefs = HashMultimap.create();
    }

    private CFunctionCallEdge getFunctionCallEdge(CFunctionSummaryEdge pSummaryEdge) {
        for (CFAEdge edge : CFAUtils.leavingEdges(pSummaryEdge.getPredecessor())) {
            if (!(edge instanceof CFunctionCallEdge)) continue;
            return (CFunctionCallEdge)edge;
        }
        throw new AssertionError((Object)"CFunctionSummaryEdge has no corresponding CFunctionCallEdge");
    }

    private Set<MemoryLocation> getCallEdgeDefs(CFunctionCallEdge pCallEdge) {
        HashSet<MemoryLocation> defs = new HashSet<MemoryLocation>();
        AFunctionDeclaration function = pCallEdge.getSuccessor().getFunction();
        defs.addAll((Collection<MemoryLocation>)this.foreignDefUseData.getForeignUses(function));
        for (AParameterDeclaration aParameterDeclaration : function.getParameters()) {
            defs.add(MemoryLocation.forDeclaration(aParameterDeclaration));
        }
        return defs;
    }

    private Set<MemoryLocation> getSummaryEdgeDefs(CFunctionSummaryEdge pSummaryEdge) {
        HashSet<MemoryLocation> defs = new HashSet<MemoryLocation>();
        AFunctionDeclaration function = pSummaryEdge.getFunctionEntry().getFunction();
        CFunctionCallEdge callEdge = this.getFunctionCallEdge(pSummaryEdge);
        EdgeDefUseData edgeDefUseData = this.defUseExtractor.extract(callEdge);
        defs.addAll((Collection<MemoryLocation>)edgeDefUseData.getDefs());
        defs.addAll((Collection<MemoryLocation>)this.foreignDefUseData.getForeignDefs(function));
        this.maybeDefs.putAll((Object)pSummaryEdge, this.foreignDefUseData.getForeignDefs(function));
        for (CExpression expression : edgeDefUseData.getPointeeDefs()) {
            ImmutableSet<MemoryLocation> possibleDefs = this.pointerState.getPossiblePointees(callEdge, expression);
            assert (possibleDefs != null && !possibleDefs.isEmpty()) : "No possible pointees";
            defs.addAll((Collection<MemoryLocation>)possibleDefs);
            if (possibleDefs.size() <= 1) continue;
            this.maybeDefs.putAll((Object)pSummaryEdge, possibleDefs);
        }
        return defs;
    }

    private Set<MemoryLocation> getSummaryEdgeUses(CFunctionSummaryEdge pSummaryEdge) {
        HashSet<MemoryLocation> uses = new HashSet<MemoryLocation>();
        AFunctionDeclaration function = pSummaryEdge.getFunctionEntry().getFunction();
        CFunctionCallEdge callEdge = this.getFunctionCallEdge(pSummaryEdge);
        EdgeDefUseData edgeDefUseData = this.defUseExtractor.extract(callEdge);
        uses.addAll((Collection<MemoryLocation>)edgeDefUseData.getUses());
        uses.addAll((Collection<MemoryLocation>)this.foreignDefUseData.getForeignUses(function));
        for (CExpression expression : edgeDefUseData.getPointeeUses()) {
            ImmutableSet<MemoryLocation> possibleUses = this.pointerState.getPossiblePointees(callEdge, expression);
            assert (possibleUses != null && !possibleUses.isEmpty()) : "No possible pointees";
            uses.addAll((Collection<MemoryLocation>)possibleUses);
        }
        return uses;
    }

    private Set<MemoryLocation> getOtherEdgeDefs(CFAEdge pEdge) {
        HashSet<MemoryLocation> defs = new HashSet<MemoryLocation>();
        EdgeDefUseData edgeDefUseData = this.defUseExtractor.extract(pEdge);
        defs.addAll((Collection<MemoryLocation>)edgeDefUseData.getDefs());
        for (CExpression expression : edgeDefUseData.getPointeeDefs()) {
            ImmutableSet<MemoryLocation> possibleDefs = this.pointerState.getPossiblePointees(pEdge, expression);
            assert (possibleDefs != null && !possibleDefs.isEmpty()) : "No possible pointees";
            defs.addAll((Collection<MemoryLocation>)possibleDefs);
            if (possibleDefs.size() <= 1) continue;
            this.maybeDefs.putAll((Object)pEdge, possibleDefs);
        }
        return defs;
    }

    private Set<MemoryLocation> getOtherEdgeUses(CFAEdge pEdge) {
        HashSet<MemoryLocation> uses = new HashSet<MemoryLocation>();
        EdgeDefUseData edgeDefUseData = this.defUseExtractor.extract(pEdge);
        uses.addAll((Collection<MemoryLocation>)edgeDefUseData.getUses());
        for (CExpression expression : edgeDefUseData.getPointeeUses()) {
            ImmutableSet<MemoryLocation> possibleUses = this.pointerState.getPossiblePointees(pEdge, expression);
            assert (possibleUses != null && !possibleUses.isEmpty()) : "No possible pointees";
            uses.addAll((Collection<MemoryLocation>)possibleUses);
        }
        return uses;
    }

    @Override
    protected Set<MemoryLocation> getEdgeDefs(CFAEdge pEdge) {
        if (pEdge instanceof CFunctionCallEdge) {
            return this.getCallEdgeDefs((CFunctionCallEdge)pEdge);
        }
        if (pEdge instanceof CFunctionSummaryEdge) {
            return this.getSummaryEdgeDefs((CFunctionSummaryEdge)pEdge);
        }
        return this.getOtherEdgeDefs(pEdge);
    }

    private Set<MemoryLocation> getEdgeUses(CFAEdge pEdge) {
        if (pEdge instanceof CFunctionCallEdge) {
            return ImmutableSet.of();
        }
        if (pEdge instanceof CFunctionSummaryEdge) {
            return this.getSummaryEdgeUses((CFunctionSummaryEdge)pEdge);
        }
        return this.getOtherEdgeUses(pEdge);
    }

    @Override
    protected Collection<ReachDefAnalysis.Def<MemoryLocation, CFAEdge>> getReachDefs(MemoryLocation pVariable) {
        ArrayList<ReachDefAnalysis.Def<MemoryLocation, CFAEdge>> reachDefs = new ArrayList<ReachDefAnalysis.Def<MemoryLocation, CFAEdge>>();
        for (ReachDefAnalysis.Def def : this.iterateDefsNewestFirst(pVariable)) {
            CFAEdge edge;
            reachDefs.add(def);
            Optional optEdge = def.getEdge();
            if (optEdge.isPresent() && (this.maybeDefs.get((Object)(edge = (CFAEdge)optEdge.orElseThrow())).contains(pVariable) || this.defUseExtractor.extract(edge).hasPartialDefs())) continue;
            break;
        }
        return reachDefs;
    }

    @Override
    protected void insertCombiners(DomFrontiers<CFANode> pDomFrontiers) {
        for (AParameterDeclaration aParameterDeclaration : this.entryNode.getFunctionParameters()) {
            MemoryLocation variable = MemoryLocation.forDeclaration(aParameterDeclaration);
            this.insertCombiner(this.entryNode, variable);
        }
        for (MemoryLocation memoryLocation : this.foreignDefUseData.getForeignUses(this.entryNode.getFunction())) {
            this.insertCombiner(this.entryNode, memoryLocation);
        }
        super.insertCombiners(pDomFrontiers);
    }

    @Override
    protected void traverseDomTree(Graph<CFANode> pDomTree, CFANode pRootNode) {
        this.globalEdges.forEach(this::pushEdge);
        for (CFAEdge callEdge : CFAUtils.allEnteringEdges(pRootNode)) {
            this.pushEdge(callEdge);
            this.popEdge(callEdge);
        }
        super.traverseDomTree(pDomTree, pRootNode);
    }

    private void handleDependence(CFAEdge pEdge, ReachDefAnalysis.Def<MemoryLocation, CFAEdge> pDef, boolean pIsDeclaration) {
        MemoryLocation variable = pDef.getVariable();
        HashSet defs = new HashSet();
        pDef.collect(defs);
        for (ReachDefAnalysis.Def def : defs) {
            Optional optDefEdge = def.getEdge();
            if (!optDefEdge.isPresent()) continue;
            this.dependenceConsumer.accept((CFAEdge)optDefEdge.orElseThrow(), pEdge, variable, pIsDeclaration);
        }
    }

    @Override
    public void run() {
        super.run();
        for (Map.Entry entry : this.flowDeps.entries()) {
            this.handleDependence((CFAEdge)entry.getKey(), (ReachDefAnalysis.Def)entry.getValue(), false);
        }
        for (Map.Entry entry : this.declDeps.entries()) {
            this.handleDependence((CFAEdge)entry.getKey(), (ReachDefAnalysis.Def)entry.getValue(), true);
        }
        this.addFunctionUseDependences();
        this.addReturnValueDependences();
        this.addForeignDefDependences();
    }

    private ReachDefAnalysis.Def<MemoryLocation, CFAEdge> getDeclaration(MemoryLocation pVariable) {
        for (ReachDefAnalysis.Def<MemoryLocation, CFAEdge> def : this.iterateDefsOldestFirst(pVariable)) {
            Optional optEdge = def.getEdge();
            if (!optEdge.isPresent() || !(optEdge.orElseThrow() instanceof CDeclarationEdge)) continue;
            return def;
        }
        return null;
    }

    @Override
    protected void pushNode(CFANode pNode) {
        super.pushNode(pNode);
        if (pNode instanceof FunctionExitNode) {
            for (MemoryLocation defVar : this.foreignDefUseData.getForeignDefs(pNode.getFunction())) {
                for (ReachDefAnalysis.Def<MemoryLocation, CFAEdge> def : this.getReachDefs(defVar)) {
                    for (CFAEdge returnEdge : CFAUtils.leavingEdges(pNode)) {
                        this.flowDeps.put((Object)returnEdge, def);
                    }
                }
            }
        }
    }

    @Override
    protected void pushEdge(CFAEdge pEdge) {
        for (MemoryLocation useVar : this.getEdgeUses(pEdge)) {
            for (ReachDefAnalysis.Def<MemoryLocation, CFAEdge> def : this.getReachDefs(useVar)) {
                assert (def != null) : String.format("Variable is missing definition: %s @ %s", useVar, pEdge);
                this.flowDeps.put((Object)pEdge, def);
            }
        }
        for (MemoryLocation defVar : this.getEdgeDefs(pEdge)) {
            ReachDefAnalysis.Def<MemoryLocation, CFAEdge> declaration = this.getDeclaration(defVar);
            if (declaration == null) continue;
            this.declDeps.put((Object)pEdge, declaration);
        }
        if (pEdge instanceof CDeclarationEdge) {
            CDeclaration declaration = ((CDeclarationEdge)pEdge).getDeclaration();
            CType type = declaration.getType();
            while (type instanceof CPointerType) {
                type = ((CPointerType)type).getType();
            }
            if (!declaration.isGlobal() && type instanceof CComplexType) {
                CComplexType complexType = (CComplexType)type;
                for (CFAEdge typeDeclarationEdge : this.complexTypeDeclarationEdges.get((Object)complexType.getQualifiedName())) {
                    this.dependenceConsumer.accept(typeDeclarationEdge, pEdge, MemoryLocation.parseExtendedQualifiedName(complexType.getQualifiedName()), true);
                }
            }
        }
        super.pushEdge(pEdge);
    }

    private void addFunctionUseDependences() {
        for (CFAEdge callEdge : CFAUtils.allEnteringEdges(this.entryNode)) {
            FunctionSummaryEdge summaryEdge = callEdge.getPredecessor().getLeavingSummaryEdge();
            assert (summaryEdge != null) : "Missing summary edge for call edge: " + callEdge;
            for (MemoryLocation parameter : this.getEdgeDefs(callEdge)) {
                this.dependenceConsumer.accept(summaryEdge, callEdge, parameter, false);
            }
        }
    }

    private void addForeignDefDependences() {
        AFunctionDeclaration function = this.entryNode.getFunction();
        for (CFAEdge returnEdge : CFAUtils.leavingEdges(this.entryNode.getExitNode())) {
            FunctionSummaryEdge summaryEdge = returnEdge.getSuccessor().getEnteringSummaryEdge();
            assert (summaryEdge != null) : "Missing summary edge for return edge: " + returnEdge;
            for (MemoryLocation defVar : this.foreignDefUseData.getForeignDefs(function)) {
                this.dependenceConsumer.accept(returnEdge, summaryEdge, defVar, false);
            }
        }
    }

    private void addReturnValueDependences() {
        Optional<? extends AVariableDeclaration> optRetVar = this.entryNode.getReturnVariable();
        if (optRetVar.isPresent()) {
            MemoryLocation returnVar = MemoryLocation.forDeclaration(optRetVar.get());
            for (CFAEdge defEdge : CFAUtils.allEnteringEdges(this.entryNode.getExitNode())) {
                for (CFAEdge returnEdge : CFAUtils.allLeavingEdges(this.entryNode.getExitNode())) {
                    this.dependenceConsumer.accept(defEdge, returnEdge, returnVar, false);
                }
            }
            for (CFAEdge returnEdge : CFAUtils.allLeavingEdges(this.entryNode.getExitNode())) {
                FunctionSummaryEdge summaryEdge = returnEdge.getSuccessor().getEnteringSummaryEdge();
                assert (summaryEdge != null) : "Missing summary edge for return edge: " + returnEdge;
                this.dependenceConsumer.accept(returnEdge, summaryEdge, returnVar, false);
            }
        }
    }

    private static final class SingleFunctionGraph
    implements ReachDefAnalysis.InputGraph<CFANode, CFAEdge> {
        private static final SingleFunctionGraph INSTANCE = new SingleFunctionGraph();

        private SingleFunctionGraph() {
        }

        @Override
        public CFANode getPredecessor(CFAEdge pEdge) {
            return pEdge.getPredecessor();
        }

        @Override
        public CFANode getSuccessor(CFAEdge pEdge) {
            return pEdge.getSuccessor();
        }

        @Override
        public Optional<CFAEdge> getEdge(CFANode pPredecessor, CFANode pSuccessor) {
            for (CFAEdge edge : this.getLeavingEdges(pPredecessor)) {
                if (!edge.getSuccessor().equals(pSuccessor)) continue;
                return Optional.of(edge);
            }
            return Optional.empty();
        }

        private boolean ignoreEdge(CFAEdge pEdge) {
            return !(pEdge instanceof CFunctionCallEdge) && !(pEdge instanceof CFunctionReturnEdge) && !(pEdge instanceof CFunctionSummaryStatementEdge);
        }

        @Override
        public Iterable<CFAEdge> getLeavingEdges(CFANode pNode) {
            return () -> Iterators.filter((Iterator)CFAUtils.allLeavingEdges(pNode).iterator(), this::ignoreEdge);
        }

        @Override
        public Iterable<CFAEdge> getEnteringEdges(CFANode pNode) {
            return () -> Iterators.filter((Iterator)CFAUtils.allEnteringEdges(pNode).iterator(), this::ignoreEdge);
        }
    }

    @FunctionalInterface
    public static interface DependenceConsumer {
        public void accept(CFAEdge var1, CFAEdge var2, MemoryLocation var3, boolean var4);
    }
}

