/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.ast.AFunctionDeclaration;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionSummaryEdge;
import org.sosy_lab.cpachecker.util.CFAUtils;
import org.sosy_lab.cpachecker.util.dependencegraph.EdgeDefUseData;
import org.sosy_lab.cpachecker.util.dependencegraph.GlobalPointerState;
import org.sosy_lab.cpachecker.util.states.MemoryLocation;

final class ForeignDefUseData {
    private final ImmutableMap<AFunctionDeclaration, ImmutableSet<MemoryLocation>> foreignDefs;
    private final ImmutableMap<AFunctionDeclaration, ImmutableSet<MemoryLocation>> foreignUses;

    private ForeignDefUseData(ImmutableMap<AFunctionDeclaration, ImmutableSet<MemoryLocation>> pForeignDefs, ImmutableMap<AFunctionDeclaration, ImmutableSet<MemoryLocation>> pForeignUses) {
        this.foreignDefs = pForeignDefs;
        this.foreignUses = pForeignUses;
    }

    public ImmutableSet<MemoryLocation> getForeignDefs(AFunctionDeclaration pFunction) {
        return (ImmutableSet)this.foreignDefs.get((Object)pFunction);
    }

    public ImmutableSet<MemoryLocation> getForeignUses(AFunctionDeclaration pFunction) {
        return (ImmutableSet)this.foreignUses.get((Object)pFunction);
    }

    public static ForeignDefUseData extract(CFA pCfa, EdgeDefUseData.Extractor pDefUseExtractor, GlobalPointerState pPointerState) {
        ArrayList<CFAEdge> edges = new ArrayList<CFAEdge>();
        for (CFANode cFANode : pCfa.getAllNodes()) {
            Iterables.addAll(edges, CFAUtils.allLeavingEdges(cFANode));
        }
        HashMap<AFunctionDeclaration, Set<AFunctionDeclaration>> calledFunctions = new HashMap<AFunctionDeclaration, Set<AFunctionDeclaration>>();
        for (CFAEdge edge : edges) {
            if (!(edge instanceof CFunctionSummaryEdge)) continue;
            CFunctionSummaryEdge summaryEdge = (CFunctionSummaryEdge)edge;
            AFunctionDeclaration function = summaryEdge.getPredecessor().getFunction();
            AFunctionDeclaration calledFunction = summaryEdge.getFunctionEntry().getFunction();
            calledFunctions.computeIfAbsent(function, key -> new HashSet()).add(calledFunction);
        }
        HashMap<AFunctionDeclaration, Set<MemoryLocation>> hashMap = new HashMap<AFunctionDeclaration, Set<MemoryLocation>>();
        HashMap<AFunctionDeclaration, Set<MemoryLocation>> foreignUses = new HashMap<AFunctionDeclaration, Set<MemoryLocation>>();
        ForeignDefUseData.collectDirectForeign(hashMap, foreignUses, edges, pDefUseExtractor, pPointerState);
        ForeignDefUseData.collectIndirectForeign(hashMap, foreignUses, calledFunctions);
        return new ForeignDefUseData(ForeignDefUseData.createImmutable(hashMap), ForeignDefUseData.createImmutable(foreignUses));
    }

    private static <K, V> ImmutableMap<K, ImmutableSet<V>> createImmutable(Map<K, Set<V>> pMap) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builderWithExpectedSize((int)pMap.size());
        for (Map.Entry<K, Set<V>> entry : pMap.entrySet()) {
            mapBuilder.put(entry.getKey(), (Object)ImmutableSet.copyOf((Collection)entry.getValue()));
        }
        return mapBuilder.buildOrThrow();
    }

    private static boolean isForeignMemoryLocation(MemoryLocation pMemoryLocation, AFunctionDeclaration pFunction) {
        return !pMemoryLocation.isOnFunctionStack() || !pMemoryLocation.getFunctionName().equals(pFunction.getQualifiedName());
    }

    private static void collectForeignMemoryLocations(AFunctionDeclaration pFunction, CFAEdge pEdge, Set<CExpression> pPointees, GlobalPointerState pPointerState, Set<MemoryLocation> pForeignMemoryLocations) {
        for (CExpression expression : pPointees) {
            ImmutableSet<MemoryLocation> possibleDefs = pPointerState.getPossiblePointees(pEdge, expression);
            assert (possibleDefs != null && !possibleDefs.isEmpty()) : "No possible pointees";
            for (MemoryLocation memoryLocation : possibleDefs) {
                if (!ForeignDefUseData.isForeignMemoryLocation(memoryLocation, pFunction)) continue;
                pForeignMemoryLocations.add(memoryLocation);
            }
        }
    }

    private static void collectDirectForeign(Map<AFunctionDeclaration, Set<MemoryLocation>> pForeignDefs, Map<AFunctionDeclaration, Set<MemoryLocation>> pForeignUses, List<CFAEdge> pEdges, EdgeDefUseData.Extractor pDefUseExtractor, GlobalPointerState pPointerState) {
        for (CFAEdge edge : pEdges) {
            AFunctionDeclaration function = edge.getPredecessor().getFunction();
            EdgeDefUseData defUseData = pDefUseExtractor.extract(edge);
            Set foreignDefs = pForeignDefs.computeIfAbsent(function, key -> new HashSet());
            ForeignDefUseData.collectForeignMemoryLocations(function, edge, defUseData.getPointeeDefs(), pPointerState, foreignDefs);
            for (MemoryLocation def : defUseData.getDefs()) {
                if (def.isOnFunctionStack()) continue;
                foreignDefs.add(def);
            }
            Set foreignUses = pForeignUses.computeIfAbsent(function, key -> new HashSet());
            ForeignDefUseData.collectForeignMemoryLocations(function, edge, defUseData.getPointeeUses(), pPointerState, foreignUses);
            for (MemoryLocation use : defUseData.getUses()) {
                if (use.isOnFunctionStack()) continue;
                foreignUses.add(use);
            }
        }
    }

    private static void collectIndirectForeign(Map<AFunctionDeclaration, Set<MemoryLocation>> pForeignDefs, Map<AFunctionDeclaration, Set<MemoryLocation>> pForeignUses, Map<AFunctionDeclaration, Set<AFunctionDeclaration>> pCalledFunctions) {
        boolean changed = true;
        while (changed) {
            changed = false;
            for (Map.Entry<AFunctionDeclaration, Set<AFunctionDeclaration>> entry : pCalledFunctions.entrySet()) {
                AFunctionDeclaration function = entry.getKey();
                Set<MemoryLocation> functionDefs = pForeignDefs.get(function);
                for (AFunctionDeclaration calledFunction : entry.getValue()) {
                    Set<MemoryLocation> calledFunctionDefs = pForeignDefs.get(calledFunction);
                    for (MemoryLocation defVar : calledFunctionDefs) {
                        if (!ForeignDefUseData.isForeignMemoryLocation(defVar, function) || !functionDefs.add(defVar)) continue;
                        changed = true;
                    }
                    Set<MemoryLocation> functionUses = pForeignUses.get(function);
                    Set<MemoryLocation> calledFunctionUses = pForeignUses.get(calledFunction);
                    for (MemoryLocation useVar : calledFunctionUses) {
                        if (!ForeignDefUseData.isForeignMemoryLocation(useVar, function) || !functionUses.add(useVar)) continue;
                        changed = true;
                    }
                }
            }
        }
    }

    public String toString() {
        return String.format("[foreign-defs: %s, foreign-uses: %s]", this.foreignDefs, this.foreignUses);
    }
}

