/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multimap;
import com.google.common.graph.Graph;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.sosy_lab.cpachecker.util.graph.dominance.DomFrontiers;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;

abstract class ReachDefAnalysis<D, N, E> {
    private final InputGraph<N, E> graph;
    private final DomTree<N> domTree;
    private final DomFrontiers<N> domFrontiers;
    private final Multimap<D, E> variableDefEdges;
    private final Multimap<N, Def.Combiner<D, E>> nodeDefCombiners;
    private final Map<D, Deque<Def<D, E>>> variableDefStacks;

    protected ReachDefAnalysis(InputGraph<N, E> pGraph, DomTree<N> pDomTree, DomFrontiers<N> pDomFrontiers) {
        this.graph = pGraph;
        this.domTree = pDomTree;
        this.domFrontiers = pDomFrontiers;
        this.variableDefEdges = ArrayListMultimap.create();
        this.nodeDefCombiners = ArrayListMultimap.create();
        this.variableDefStacks = new HashMap<D, Deque<Def<D, E>>>();
    }

    protected abstract Set<D> getEdgeDefs(E var1);

    private Deque<Def<D, E>> getDefStack(D pVariable) {
        return this.variableDefStacks.computeIfAbsent(pVariable, key -> new ArrayDeque());
    }

    protected final Iterable<Def<D, E>> iterateDefsNewestFirst(D pVariable) {
        Iterator iterator = this.getDefStack(pVariable).iterator();
        return () -> Iterators.unmodifiableIterator((Iterator)iterator);
    }

    protected final Iterable<Def<D, E>> iterateDefsOldestFirst(D pVariable) {
        Iterator descIterator = this.getDefStack(pVariable).descendingIterator();
        return () -> Iterators.unmodifiableIterator((Iterator)descIterator);
    }

    protected Collection<Def<D, E>> getReachDefs(D pVariable) {
        return Collections.singleton(this.getDefStack(pVariable).peek());
    }

    protected final void insertCombiner(N pNode, D pVariable) {
        this.nodeDefCombiners.put(pNode, new Def.Combiner(pVariable));
    }

    protected void insertCombiners(DomFrontiers<N> pDomFrontiers) {
        for (Object variable : this.variableDefEdges.keySet()) {
            HashSet<N> defNodes = new HashSet<N>();
            for (Object defEdge : this.variableDefEdges.get(variable)) {
                defNodes.add(this.graph.getPredecessor(defEdge));
            }
            for (Object node : pDomFrontiers.getIteratedFrontier(defNodes)) {
                this.insertCombiner(node, variable);
            }
        }
    }

    protected void pushEdge(E pEdge) {
        for (D edgeDefVar : this.getEdgeDefs(pEdge)) {
            Deque<Def<D, Def.Wrapper<D, E>>> defStack = this.getDefStack(edgeDefVar);
            defStack.push(new Def.Wrapper<D, E>(edgeDefVar, pEdge));
        }
        for (Def.Combiner combiner : this.nodeDefCombiners.get(this.graph.getSuccessor(pEdge))) {
            for (Def def : this.getReachDefs(combiner.getVariable())) {
                combiner.add(def);
            }
        }
    }

    protected void popEdge(E pEdge) {
        for (D variable : this.getEdgeDefs(pEdge)) {
            this.getDefStack(variable).pop();
        }
    }

    protected void pushNode(N pNode) {
        for (Def.Combiner combiner : this.nodeDefCombiners.get(pNode)) {
            this.getDefStack(combiner.getVariable()).push(combiner);
        }
    }

    protected void popNode(N pNode) {
        for (Def.Combiner combiner : this.nodeDefCombiners.get(pNode)) {
            this.getDefStack(combiner.getVariable()).pop();
        }
    }

    private boolean hasMultipleEnteringEdges(N pNode) {
        Iterator<E> iterator = this.graph.getEnteringEdges(pNode).iterator();
        if (iterator.hasNext()) {
            iterator.next();
            return iterator.hasNext();
        }
        return false;
    }

    private boolean isDanglingEdge(Graph<N> pDomTree, N pParentNode, E pEdge) {
        N edgeSuccessor = this.graph.getSuccessor(pEdge);
        if (this.hasMultipleEnteringEdges(edgeSuccessor)) {
            for (Object successor : pDomTree.successors(pParentNode)) {
                if (!successor.equals(edgeSuccessor)) continue;
                return false;
            }
        } else {
            return false;
        }
        return true;
    }

    protected void traverseDomTree(Graph<N> pDomTree, N pRootNode) {
        ArrayDeque stack = new ArrayDeque();
        Object currentNode = pRootNode;
        stack.push(pDomTree.successors(currentNode).iterator());
        this.pushNode(currentNode);
        while (true) {
            Optional<E> optEdge;
            Iterator children;
            if ((children = (Iterator)stack.peek()).hasNext()) {
                Object nextNode = children.next();
                optEdge = this.graph.getEdge(currentNode, nextNode);
                if (optEdge.isPresent()) {
                    this.pushEdge(optEdge.orElseThrow());
                }
                stack.push(pDomTree.successors(nextNode).iterator());
                this.pushNode(nextNode);
                for (E edge : this.graph.getLeavingEdges(nextNode)) {
                    if (!this.isDanglingEdge(pDomTree, nextNode, edge)) continue;
                    this.pushEdge(edge);
                    this.popEdge(edge);
                }
                currentNode = nextNode;
                continue;
            }
            N prevNode = currentNode;
            currentNode = Iterables.getOnlyElement((Iterable)pDomTree.predecessors(currentNode), null);
            this.popNode(prevNode);
            stack.pop();
            if (currentNode == null) break;
            optEdge = this.graph.getEdge(currentNode, prevNode);
            if (!optEdge.isPresent()) continue;
            this.popEdge(optEdge.orElseThrow());
        }
        assert (stack.isEmpty());
    }

    private void registerDefs() {
        for (N node : this.domTree) {
            for (E edge : this.graph.getLeavingEdges(node)) {
                for (D varDef : this.getEdgeDefs(edge)) {
                    this.variableDefEdges.put(varDef, edge);
                }
            }
        }
    }

    public void run() {
        this.registerDefs();
        this.insertCombiners(this.domFrontiers);
        this.domTree.getRoot().ifPresent(rootNode -> this.traverseDomTree((Graph<N>)this.domTree.asGraph(), (N)rootNode));
    }

    public static abstract class Def<V, E> {
        private final V variable;

        private Def(V pVariable) {
            this.variable = pVariable;
        }

        final V getVariable() {
            return this.variable;
        }

        public abstract Optional<E> getEdge();

        public abstract void collect(Set<Def<V, E>> var1);

        private static final class Combiner<V, E>
        extends Def<V, E> {
            private final List<Def<V, E>> defs = new ArrayList<Def<V, E>>();

            private Combiner(V pVariable) {
                super(pVariable);
            }

            private void add(Def<V, E> pDef) {
                this.defs.add(pDef);
            }

            @Override
            public Optional<E> getEdge() {
                return Optional.empty();
            }

            @Override
            public void collect(Set<Def<V, E>> pDefs) {
                for (Def<V, E> def : this.defs) {
                    if (!pDefs.add(def) || !(def instanceof Combiner)) continue;
                    def.collect(pDefs);
                }
            }
        }

        private static class Wrapper<V, E>
        extends Def<V, E> {
            private final E edge;

            private Wrapper(V pVariable, E pEdge) {
                super(pVariable);
                this.edge = pEdge;
            }

            @Override
            public Optional<E> getEdge() {
                return Optional.of(this.edge);
            }

            @Override
            public void collect(Set<Def<V, E>> pDefs) {
                pDefs.add(this);
            }
        }
    }

    public static interface InputGraph<N, E> {
        public N getPredecessor(E var1);

        public N getSuccessor(E var1);

        public Optional<E> getEdge(N var1, N var2);

        public Iterable<E> getLeavingEdges(N var1);

        public Iterable<E> getEnteringEdges(N var1);
    }
}

