/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMap;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Level;
import org.sosy_lab.common.io.IO;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.util.dependencegraph.SystemDependenceGraph;

abstract class SdgDotExporter<P, T, V, N extends SystemDependenceGraph.Node<P, T, V>> {
    private static final ImmutableMap<SystemDependenceGraph.EdgeType, String> edgeStyles;
    private static final ImmutableMap<SystemDependenceGraph.EdgeType, String> edgeLabels;

    SdgDotExporter() {
    }

    protected abstract String getProcedureLabel(P var1);

    protected abstract String getNodeStyle(SystemDependenceGraph.Node<P, T, V> var1);

    protected abstract String getNodeLabel(SystemDependenceGraph.Node<P, T, V> var1);

    protected abstract boolean isHighlighted(SystemDependenceGraph.Node<P, T, V> var1);

    protected abstract boolean isHighlighted(SystemDependenceGraph.EdgeType var1, SystemDependenceGraph.Node<P, T, V> var2, SystemDependenceGraph.Node<P, T, V> var3);

    private String escape(String pLabel) {
        return pLabel.replace("\"", "\\\"");
    }

    private String nodeId(Map<SystemDependenceGraph.Node<P, T, V>, Long> pVisitedNodes, SystemDependenceGraph.Node<P, T, V> pNode) {
        return "n" + pVisitedNodes.get(pNode);
    }

    private static void writeLegend(Writer pWriter) throws IOException {
        pWriter.write("subgraph cluster_legend {\n");
        pWriter.write("label=\"Legend\\nY depends on X\";\n");
        pWriter.write("key1 [");
        pWriter.write("penwidth=\"0\",");
        pWriter.write("label=");
        pWriter.write("<<table ");
        pWriter.write("border=\"0\" ");
        pWriter.write("cellpadding=\"8\" ");
        pWriter.write("cellspacing=\"0\" ");
        pWriter.write("cellborder=\"0\">\n");
        int i = 1;
        for (String label : edgeLabels.values()) {
            pWriter.write("<tr>");
            pWriter.write("<td ");
            pWriter.write("align=\"right\" ");
            pWriter.write("port=\"i");
            pWriter.write(String.valueOf(i));
            pWriter.write("\">");
            pWriter.write(label);
            pWriter.write("      X ");
            pWriter.write("</td>");
            pWriter.write("</tr>\n");
            ++i;
        }
        pWriter.write("</table>>]\n");
        pWriter.write("key2 [");
        pWriter.write("penwidth=\"0\",");
        pWriter.write("label=");
        pWriter.write("<<table ");
        pWriter.write("border=\"0\" ");
        pWriter.write("cellpadding=\"8\" ");
        pWriter.write("cellspacing=\"0\" ");
        pWriter.write("cellborder=\"0\">\n");
        for (i = 1; i <= edgeLabels.size(); ++i) {
            pWriter.write("<tr>");
            pWriter.write("<td ");
            pWriter.write("port=\"i");
            pWriter.write(String.valueOf(i));
            pWriter.write("\">");
            pWriter.write(" Y");
            pWriter.write("</td>");
            pWriter.write("</tr>\n");
        }
        pWriter.write("</table>>]\n");
        i = 1;
        for (SystemDependenceGraph.EdgeType edgeType : edgeLabels.keySet()) {
            String edgeStyle = ((String)edgeStyles.get((Object)edgeType)).replace("{color}", "black");
            pWriter.write("key1:i");
            pWriter.write(String.valueOf(i));
            pWriter.write(":e");
            pWriter.write(" -> ");
            pWriter.write("key2:i");
            pWriter.write(String.valueOf(i));
            pWriter.write(":w");
            pWriter.write(" [");
            pWriter.write(edgeStyle);
            pWriter.write("]\n");
            ++i;
        }
        pWriter.write("}\n");
    }

    private void writeEdges(Writer pWriter, SystemDependenceGraph<V, N> pSdg, final Map<SystemDependenceGraph.Node<P, T, V>, Long> pVisitedNodes) throws IOException {
        final StringBuilder sb = new StringBuilder();
        for (SystemDependenceGraph.Node node : pSdg.getNodes()) {
            sb.setLength(0);
            pSdg.traverse((Collection<N>)ImmutableSet.of((Object)node), new SystemDependenceGraph.ForwardsVisitor<N>(){

                @Override
                public SystemDependenceGraph.VisitResult visitNode(N pNode) {
                    return SystemDependenceGraph.VisitResult.CONTINUE;
                }

                @Override
                public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, N pPredecessor, N pSuccessor) {
                    sb.append(SdgDotExporter.this.nodeId(pVisitedNodes, pPredecessor));
                    sb.append(" -> ");
                    sb.append(SdgDotExporter.this.nodeId(pVisitedNodes, pSuccessor));
                    sb.append(' ');
                    String color = SdgDotExporter.this.isHighlighted(pType, pPredecessor, pSuccessor) ? "red" : "black";
                    String edgeStyle = ((String)edgeStyles.get((Object)pType)).replace("{color}", color);
                    sb.append('[');
                    sb.append(edgeStyle);
                    sb.append("]\n");
                    return SystemDependenceGraph.VisitResult.SKIP;
                }
            });
            pWriter.write(sb.toString());
        }
    }

    private void write(Writer pWriter, SystemDependenceGraph<V, N> pSdg) throws IOException {
        pWriter.write("digraph SystemDependenceGraph {\n");
        pWriter.write("rankdir=LR;\n");
        SdgDotExporter.writeLegend(pWriter);
        HashMap<SystemDependenceGraph.Node<P, T, Long>, Long> visitedNodes = new HashMap<SystemDependenceGraph.Node<P, T, Long>, Long>();
        ArrayListMultimap procedureNodes = ArrayListMultimap.create();
        long counter = 0L;
        for (SystemDependenceGraph.Node node : pSdg.getNodes()) {
            visitedNodes.put(node, counter);
            ++counter;
            procedureNodes.put(node.getProcedure(), (Object)node);
        }
        for (Optional procedure : procedureNodes.keySet()) {
            pWriter.write("subgraph cluster_f");
            pWriter.write(String.valueOf(counter));
            pWriter.write(" {\n");
            ++counter;
            String procedureLabel = procedure.isPresent() ? this.getProcedureLabel(procedure.orElseThrow()) : "";
            pWriter.write("label=\"");
            pWriter.write(this.escape(procedureLabel));
            pWriter.write("\";\n");
            for (SystemDependenceGraph.Node node : procedureNodes.get((Object)procedure)) {
                String color = this.isHighlighted(node) ? "red" : "black";
                String style = this.getNodeStyle(node).replace("{color}", color);
                pWriter.write(this.nodeId(visitedNodes, node));
                pWriter.write(" [");
                pWriter.write(style);
                pWriter.write(style.trim().isEmpty() ? "" : ",");
                pWriter.write("label=\"");
                pWriter.write(this.escape(this.getNodeLabel(node)));
                pWriter.write("\"]\n");
            }
            pWriter.write("}\n");
        }
        this.writeEdges(pWriter, pSdg, visitedNodes);
        pWriter.write("\n}\n");
    }

    void export(SystemDependenceGraph<V, N> pSdg, Path pPath, LogManager pLogger) {
        try (Writer writer = IO.openOutputFile((Path)pPath, (Charset)Charset.defaultCharset(), (OpenOption[])new OpenOption[0]);){
            this.write(writer, pSdg);
        }
        catch (IOException ex) {
            pLogger.logUserException(Level.WARNING, (Throwable)ex, "Failed writing system dependence graph to dot file");
        }
    }

    static {
        ImmutableSortedMap.Builder edgeLabelBuilder = ImmutableSortedMap.naturalOrder();
        edgeLabelBuilder.put((Object)SystemDependenceGraph.EdgeType.FLOW_DEPENDENCY, (Object)"Flow Dependency");
        edgeLabelBuilder.put((Object)SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, (Object)"Control Dependency");
        edgeLabelBuilder.put((Object)SystemDependenceGraph.EdgeType.DECLARATION_EDGE, (Object)"Declaration Edge");
        edgeLabelBuilder.put((Object)SystemDependenceGraph.EdgeType.CALL_EDGE, (Object)"Call Edge");
        edgeLabelBuilder.put((Object)SystemDependenceGraph.EdgeType.PARAMETER_EDGE, (Object)"Parameter Edge");
        edgeLabelBuilder.put((Object)SystemDependenceGraph.EdgeType.SUMMARY_EDGE, (Object)"Summary Edge");
        edgeLabels = edgeLabelBuilder.buildOrThrow();
        ImmutableMap.Builder edgeStyleBuilder = ImmutableMap.builderWithExpectedSize((int)SystemDependenceGraph.EdgeType.values().length);
        edgeStyleBuilder.put((Object)SystemDependenceGraph.EdgeType.FLOW_DEPENDENCY, (Object)"style=\"bold\",color=\"{color}\"");
        edgeStyleBuilder.put((Object)SystemDependenceGraph.EdgeType.CONTROL_DEPENDENCY, (Object)"style=\"bold,dashed\",color=\"{color}\"");
        edgeStyleBuilder.put((Object)SystemDependenceGraph.EdgeType.DECLARATION_EDGE, (Object)"color=\"{color}\"");
        edgeStyleBuilder.put((Object)SystemDependenceGraph.EdgeType.CALL_EDGE, (Object)"style=\"dashed\",color=\"{color}\"");
        edgeStyleBuilder.put((Object)SystemDependenceGraph.EdgeType.PARAMETER_EDGE, (Object)"style=\"bold,dotted\",color=\"{color}\"");
        edgeStyleBuilder.put((Object)SystemDependenceGraph.EdgeType.SUMMARY_EDGE, (Object)"style=\"bold\",peripheries=\"2\",color=\"{color}:invis:{color}\"");
        edgeStyles = edgeStyleBuilder.buildOrThrow();
    }
}

