/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.List;
import org.sosy_lab.cpachecker.util.dependencegraph.CallGraph;
import org.sosy_lab.cpachecker.util.dependencegraph.SystemDependenceGraph;

final class SummaryEdgeBuilder {
    private SummaryEdgeBuilder() {
    }

    static <P, N extends SystemDependenceGraph.Node<P, ?, ?>> void insertSummaryEdges(SystemDependenceGraph.Builder<P, ?, ?, N> pBuilder, CallGraph<P> pCallGraph, P pStartProcedure, Method pMethod) {
        int batchSize;
        SummaryEdgeFinder summaryEdgeFinder;
        ArrayListMultimap formalOutNodesPerProcedure = ArrayListMultimap.create();
        for (SystemDependenceGraph.Node node : pBuilder.getNodes()) {
            if (node.getType() != SystemDependenceGraph.NodeType.FORMAL_OUT) continue;
            formalOutNodesPerProcedure.put(node.getProcedure().orElseThrow(), (Object)node);
        }
        ArrayList orderedFormalOutNodes = new ArrayList();
        for (Object procedure : pCallGraph.getPostOrder(pStartProcedure)) {
            orderedFormalOutNodes.addAll(formalOutNodesPerProcedure.get(procedure));
        }
        ImmutableSet<P> recursiveProcedures = pCallGraph.getRecursiveProcedures();
        int[] procedureIds = pBuilder.createIds(SystemDependenceGraph.Node::getProcedure);
        if (pMethod == Method.BATCH) {
            summaryEdgeFinder = new BatchSummaryEdgeFinder<N>(pBuilder, procedureIds);
            batchSize = 64;
        } else {
            summaryEdgeFinder = new SingleSummaryEdgeFinder<N>(pBuilder, procedureIds);
            batchSize = 1;
        }
        ArrayList<SystemDependenceGraph.Node> selectedFormalOutNodes = new ArrayList<SystemDependenceGraph.Node>();
        for (int index = 0; index < orderedFormalOutNodes.size(); ++index) {
            SystemDependenceGraph.Node nextNode;
            SystemDependenceGraph.Node node = (SystemDependenceGraph.Node)orderedFormalOutNodes.get(index);
            int procedureId = procedureIds[node.getId()];
            selectedFormalOutNodes.add(node);
            while (index + 1 < orderedFormalOutNodes.size() && selectedFormalOutNodes.size() < batchSize && procedureIds[(nextNode = (SystemDependenceGraph.Node)orderedFormalOutNodes.get(index + 1)).getId()] == procedureId) {
                selectedFormalOutNodes.add(nextNode);
                ++index;
            }
            boolean recursive = recursiveProcedures.contains(node.getProcedure().orElseThrow());
            summaryEdgeFinder.run(selectedFormalOutNodes, recursive, pBuilder::insertActualSummaryEdges);
            selectedFormalOutNodes.clear();
        }
    }

    private static final class BatchSummaryEdgeFinder<N extends SystemDependenceGraph.Node<?, ?, ?>>
    extends SummaryEdgeFinder<N>
    implements SystemDependenceGraph.BackwardsVisitor<N> {
        private static final int MAX_BATCH_SIZE = 64;
        private static final int EMPTY_STATE = 0;
        private int procedureId;
        private boolean recursive;
        private final long[] states;
        private int statesDirtyMin;
        private int statesDirtyMax;

        private BatchSummaryEdgeFinder(SystemDependenceGraph.Builder<?, ?, ?, N> pBuilder, int[] pProcedureIds) {
            super(pBuilder, pProcedureIds);
            this.states = new long[pBuilder.getNodeCount()];
        }

        private void setStateDirty(int pNodeId) {
            this.statesDirtyMin = Math.min(this.statesDirtyMin, pNodeId);
            this.statesDirtyMax = Math.max(this.statesDirtyMax, pNodeId);
        }

        private boolean isFormalOutReachable(N pNode, int pFormalOutBit) {
            return (this.states[((SystemDependenceGraph.Node)pNode).getId()] & 1L << pFormalOutBit) != 0L;
        }

        private void setFormalOutReachable(N pNode, int pFormalOutBit) {
            int nodeId = ((SystemDependenceGraph.Node)pNode).getId();
            this.states[nodeId] = 1L << pFormalOutBit;
            this.setStateDirty(nodeId);
        }

        @Override
        public void run(List<N> pFormalOutNodes, boolean pRecursive, SummaryEdgeConsumer<N> pConsumer) {
            Preconditions.checkArgument((!pFormalOutNodes.isEmpty() ? 1 : 0) != 0, (Object)"pFormalOutNodes must not be empty");
            Preconditions.checkArgument((pFormalOutNodes.size() <= 64 ? 1 : 0) != 0, (Object)"pFormalOutNodes must not contain more than MAX_BATCH_SIZE nodes");
            this.procedureId = this.getProcedureId(((SystemDependenceGraph.Node)pFormalOutNodes.get(0)).getId());
            this.recursive = pRecursive;
            this.statesDirtyMin = this.states.length - 1;
            this.statesDirtyMax = 0;
            for (int formalOutBit = 0; formalOutBit < pFormalOutNodes.size(); ++formalOutBit) {
                assert (((SystemDependenceGraph.Node)pFormalOutNodes.get(formalOutBit)).getType() == SystemDependenceGraph.NodeType.FORMAL_OUT);
                assert (this.getProcedureId(((SystemDependenceGraph.Node)pFormalOutNodes.get(formalOutBit)).getId()) == this.procedureId);
                this.setFormalOutReachable((SystemDependenceGraph.Node)pFormalOutNodes.get(formalOutBit), formalOutBit);
            }
            this.traverse(pFormalOutNodes, this);
            for (SystemDependenceGraph.Node formalInNode : this.getReachedFormalInNodes()) {
                for (int formalOutBit = 0; formalOutBit < pFormalOutNodes.size(); ++formalOutBit) {
                    if (!this.isFormalOutReachable(formalInNode, formalOutBit)) continue;
                    pConsumer.accept(formalInNode, (SystemDependenceGraph.Node)pFormalOutNodes.get(formalOutBit));
                }
            }
            Arrays.fill(this.states, this.statesDirtyMin, this.statesDirtyMax + 1, 0L);
            for (SystemDependenceGraph.Node formalOutNode : pFormalOutNodes) {
                this.setFormalOutFinished(formalOutNode.getId());
            }
            this.clearReachedFormalInNodes();
        }

        @Override
        public SystemDependenceGraph.VisitResult visitNode(N pNode) {
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, N pPredecessor, N pSuccessor) {
            int predId = ((SystemDependenceGraph.Node)pPredecessor).getId();
            int succId = ((SystemDependenceGraph.Node)pSuccessor).getId();
            if (((SystemDependenceGraph.Node)pPredecessor).getType() != SystemDependenceGraph.NodeType.FORMAL_OUT) {
                int succProcedureId;
                int predProcedureId = this.getProcedureId(predId);
                if (predProcedureId != (succProcedureId = this.getProcedureId(succId))) {
                    if (pType != SystemDependenceGraph.EdgeType.PARAMETER_EDGE) {
                        return SystemDependenceGraph.VisitResult.SKIP;
                    }
                    if (succProcedureId == this.procedureId && !this.recursive) {
                        return SystemDependenceGraph.VisitResult.SKIP;
                    }
                }
                if (((SystemDependenceGraph.Node)pPredecessor).getType() == SystemDependenceGraph.NodeType.FORMAL_IN && this.states[predId] == 0L && predProcedureId == this.procedureId) {
                    this.addReachedFormalInNode(pPredecessor);
                }
            } else if (this.isFormalOutFinished(predId)) {
                return SystemDependenceGraph.VisitResult.SKIP;
            }
            long oldPredState = this.states[predId];
            int n = predId;
            long l = this.states[n] | this.states[succId];
            this.states[n] = l;
            long newPredState = l;
            if (oldPredState != newPredState) {
                this.setStateDirty(predId);
                return SystemDependenceGraph.VisitResult.CONTINUE;
            }
            return SystemDependenceGraph.VisitResult.SKIP;
        }
    }

    private static final class SingleSummaryEdgeFinder<N extends SystemDependenceGraph.Node<?, ?, ?>>
    extends SummaryEdgeFinder<N>
    implements SystemDependenceGraph.BackwardsVisitor<N> {
        private final SystemDependenceGraph.BackwardsVisitOnceVisitor<N> visitor;
        private int procedureId;
        private boolean recursive;

        private SingleSummaryEdgeFinder(SystemDependenceGraph.Builder<?, ?, ?, N> pBuilder, int[] pProcedureIds) {
            super(pBuilder, pProcedureIds);
            this.visitor = new SystemDependenceGraph.BackwardsVisitOnceVisitor(this, pBuilder.getNodeCount());
        }

        @Override
        public void run(List<N> pFormalOutNodes, boolean pRecursive, SummaryEdgeConsumer<N> pConsumer) {
            for (SystemDependenceGraph.Node formalOutNode : pFormalOutNodes) {
                this.procedureId = this.getProcedureId(formalOutNode.getId());
                this.recursive = pRecursive;
                this.traverse(ImmutableList.of((Object)formalOutNode), this.visitor);
                this.visitor.reset();
                for (SystemDependenceGraph.Node formalInNode : this.getReachedFormalInNodes()) {
                    pConsumer.accept(formalInNode, formalOutNode);
                }
                this.setFormalOutFinished(formalOutNode.getId());
                this.clearReachedFormalInNodes();
            }
        }

        @Override
        public SystemDependenceGraph.VisitResult visitNode(N pNode) {
            if (((SystemDependenceGraph.Node)pNode).getType() == SystemDependenceGraph.NodeType.FORMAL_IN && this.getProcedureId(((SystemDependenceGraph.Node)pNode).getId()) == this.procedureId) {
                this.addReachedFormalInNode(pNode);
            }
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }

        @Override
        public SystemDependenceGraph.VisitResult visitEdge(SystemDependenceGraph.EdgeType pType, N pPredecessor, N pSuccessor) {
            int predId = ((SystemDependenceGraph.Node)pPredecessor).getId();
            int succId = ((SystemDependenceGraph.Node)pSuccessor).getId();
            if (((SystemDependenceGraph.Node)pPredecessor).getType() != SystemDependenceGraph.NodeType.FORMAL_OUT) {
                int succProcedureId;
                int predProcedureId = this.getProcedureId(predId);
                if (predProcedureId != (succProcedureId = this.getProcedureId(succId))) {
                    if (pType != SystemDependenceGraph.EdgeType.PARAMETER_EDGE) {
                        return SystemDependenceGraph.VisitResult.SKIP;
                    }
                    if (succProcedureId == this.procedureId && !this.recursive) {
                        return SystemDependenceGraph.VisitResult.SKIP;
                    }
                }
            } else if (this.isFormalOutFinished(predId)) {
                return SystemDependenceGraph.VisitResult.SKIP;
            }
            return SystemDependenceGraph.VisitResult.CONTINUE;
        }
    }

    private static abstract class SummaryEdgeFinder<N extends SystemDependenceGraph.Node<?, ?, ?>> {
        private final SystemDependenceGraph.Builder<?, ?, ?, N> builder;
        private final int[] procedureIds;
        private final BitSet finished;
        private final List<N> reachedFormalInNodes;

        private SummaryEdgeFinder(SystemDependenceGraph.Builder<?, ?, ?, N> pBuilder, int[] pProcedureIds) {
            this.builder = pBuilder;
            this.procedureIds = pProcedureIds;
            this.finished = new BitSet(pBuilder.getNodeCount());
            this.reachedFormalInNodes = new ArrayList<N>();
        }

        protected abstract void run(List<N> var1, boolean var2, SummaryEdgeConsumer<N> var3);

        protected void traverse(Collection<N> pStartNodes, SystemDependenceGraph.BackwardsVisitor<N> pVisitor) {
            this.builder.traverse(pStartNodes, pVisitor);
        }

        protected int getProcedureId(int pNodeTd) {
            return this.procedureIds[pNodeTd];
        }

        protected boolean isFormalOutFinished(int pNodeId) {
            return this.finished.get(pNodeId);
        }

        protected void setFormalOutFinished(int pNodeId) {
            this.finished.set(pNodeId);
        }

        protected List<N> getReachedFormalInNodes() {
            return this.reachedFormalInNodes;
        }

        protected void addReachedFormalInNode(N pFormalInNode) {
            this.reachedFormalInNodes.add(pFormalInNode);
        }

        protected void clearReachedFormalInNodes() {
            this.reachedFormalInNodes.clear();
        }
    }

    @FunctionalInterface
    private static interface SummaryEdgeConsumer<N extends SystemDependenceGraph.Node<?, ?, ?>> {
        public void accept(N var1, N var2);
    }

    public static enum Method {
        SINGLE,
        BATCH;

    }
}

