/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.dependencegraph;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;

public class SystemDependenceGraph<V, N extends Node<?, ?, V>> {
    private final ImmutableList<N> nodes;
    private final ImmutableList<GraphNode.ImmutableGraphNode<V, N>> graphNodes;
    private final TypeCounter<NodeType> nodeTypeCounter;
    private final TypeCounter<EdgeType> edgeTypeCounter;

    private SystemDependenceGraph(ImmutableList<N> pNodes, ImmutableList<GraphNode.ImmutableGraphNode<V, N>> pGraphNodes, TypeCounter<NodeType> pNodeTypeCounter, TypeCounter<EdgeType> pEdgeTypeCounter) {
        this.nodes = pNodes;
        this.graphNodes = pGraphNodes;
        this.nodeTypeCounter = pNodeTypeCounter;
        this.edgeTypeCounter = pEdgeTypeCounter;
    }

    protected SystemDependenceGraph(SystemDependenceGraph<V, N> pSdg) {
        this(pSdg.nodes, pSdg.graphNodes, pSdg.nodeTypeCounter, pSdg.edgeTypeCounter);
    }

    private static <N extends Node<?, ?, ?>> void throwExceptionForUnknownNode(N pNode) {
        throw new IllegalArgumentException("SystemDependenceGraph does not contain node: " + pNode);
    }

    private static <V, N extends Node<?, ?, V>> GraphNode<V, N> getGraphNode(List<? extends GraphNode<V, N>> pGraphNodes, N pNode) {
        GraphNode<V, N> graphNode;
        Objects.requireNonNull(pNode, "node must not be null");
        if (pNode.getId() >= pGraphNodes.size()) {
            SystemDependenceGraph.throwExceptionForUnknownNode(pNode);
        }
        if (!((Node)(graphNode = pGraphNodes.get(pNode.getId())).getNode()).equals(pNode)) {
            SystemDependenceGraph.throwExceptionForUnknownNode(pNode);
        }
        return graphNode;
    }

    public static <V, N extends Node<?, ?, V>> SystemDependenceGraph<V, N> empty() {
        return new SystemDependenceGraph<V, N>(ImmutableList.of(), ImmutableList.of(), new TypeCounter<NodeType>(NodeType.values().length), new TypeCounter<EdgeType>(EdgeType.values().length));
    }

    public static <P, T, V> Builder<P, T, V, Node<P, T, V>> builder() {
        return new Builder(Function.identity());
    }

    public static <P, T, V, N extends Node<P, T, V>> Builder<P, T, V, N> builder(Function<Node<P, T, V>, N> pNodeCreationFunction) {
        return new Builder<P, T, V, N>(pNodeCreationFunction);
    }

    public final int getNodeCount() {
        return this.nodes.size();
    }

    public final int getNodeCount(NodeType pType) {
        Objects.requireNonNull(pType, "pType must not be null");
        return this.nodeTypeCounter.getCount(pType);
    }

    public final int getEdgeCount(EdgeType pType) {
        Objects.requireNonNull(pType, "pType must not be null");
        return this.edgeTypeCounter.getCount(pType);
    }

    public final ImmutableCollection<N> getNodes() {
        return this.nodes;
    }

    public final N getNodeById(int pId) {
        if (pId < 0 || pId >= this.getNodeCount()) {
            throw new IllegalArgumentException("SDG does not contain node with id: " + pId);
        }
        return (N)((Node)this.nodes.get(pId));
    }

    public final ImmutableSet<V> getDefs(N pNode) {
        return ImmutableSet.copyOf(SystemDependenceGraph.getGraphNode(this.graphNodes, pNode).getDefs());
    }

    public final ImmutableSet<V> getUses(N pNode) {
        return ImmutableSet.copyOf(SystemDependenceGraph.getGraphNode(this.graphNodes, pNode).getUses());
    }

    private static <V, N extends Node<?, ?, V>> void traverse(List<? extends GraphNode<V, N>> pGraphNodes, Collection<N> pStartNodes, Visitor<N> pVisitor, boolean pForwards) {
        Objects.requireNonNull(pStartNodes, "pStartNodes must not be null");
        Objects.requireNonNull(pVisitor, "pVisitor must not be null");
        ArrayDeque waitlist = new ArrayDeque();
        for (Node node : pStartNodes) {
            waitlist.add(SystemDependenceGraph.getGraphNode(pGraphNodes, node));
        }
        while (!waitlist.isEmpty()) {
            GraphNode graphNode = (GraphNode)waitlist.remove();
            VisitResult nodeVisitResult = pVisitor.visitNode(graphNode.getNode());
            if (nodeVisitResult == VisitResult.CONTINUE) {
                List edges = pForwards ? graphNode.getLeavingEdges() : graphNode.getEnteringEdges();
                for (GraphEdge edge : edges) {
                    GraphNode predecessor = edge.getPredecessor();
                    GraphNode successor = edge.getSuccessor();
                    VisitResult edgeVisitResult = pVisitor.visitEdge(edge.getType(), predecessor.getNode(), successor.getNode());
                    if (edgeVisitResult == VisitResult.CONTINUE) {
                        GraphNode next = pForwards ? successor : predecessor;
                        waitlist.add(next);
                        continue;
                    }
                    if (nodeVisitResult != VisitResult.TERMINATE) continue;
                    return;
                }
                continue;
            }
            if (nodeVisitResult != VisitResult.TERMINATE) continue;
            return;
        }
    }

    public final void traverse(Collection<N> pStartNodes, ForwardsVisitor<N> pVisitor) {
        SystemDependenceGraph.traverse(this.graphNodes, pStartNodes, pVisitor, true);
    }

    public final void traverse(Collection<N> pStartNodes, BackwardsVisitor<N> pVisitor) {
        SystemDependenceGraph.traverse(this.graphNodes, pStartNodes, pVisitor, false);
    }

    public final ForwardsVisitOnceVisitor<N> createVisitOnceVisitor(ForwardsVisitor<N> pDelegateVisitor) {
        Objects.requireNonNull(pDelegateVisitor, "pDelegateVisitor must not be null");
        return new ForwardsVisitOnceVisitor<N>(pDelegateVisitor, this.getNodeCount());
    }

    public final BackwardsVisitOnceVisitor<N> createVisitOnceVisitor(BackwardsVisitor<N> pDelegateVisitor) {
        Objects.requireNonNull(pDelegateVisitor, "pDelegateVisitor must not be null");
        return new BackwardsVisitOnceVisitor<N>(pDelegateVisitor, this.getNodeCount());
    }

    public static final class BackwardsVisitOnceVisitor<N extends Node<?, ?, ?>>
    extends VisitOnceVisitor<N>
    implements BackwardsVisitor<N> {
        BackwardsVisitOnceVisitor(BackwardsVisitor<N> pDelegateVisitor, int pNodeCount) {
            super(false, pDelegateVisitor, pNodeCount);
        }

        public void reset() {
            super.reset();
        }

        @Override
        public VisitResult visitNode(N pNode) {
            return super.visitNode(pNode);
        }

        @Override
        public VisitResult visitEdge(EdgeType pType, N pPredecessor, N pSuccessor) {
            return super.visitEdge(pType, pPredecessor, pSuccessor);
        }
    }

    public static final class ForwardsVisitOnceVisitor<N extends Node<?, ?, ?>>
    extends VisitOnceVisitor<N>
    implements ForwardsVisitor<N> {
        ForwardsVisitOnceVisitor(ForwardsVisitor<N> pDelegateVisitor, int pNodeCount) {
            super(true, pDelegateVisitor, pNodeCount);
        }

        public void reset() {
            super.reset();
        }

        @Override
        public VisitResult visitNode(N pNode) {
            return super.visitNode(pNode);
        }

        @Override
        public VisitResult visitEdge(EdgeType pType, N pPredecessor, N pSuccessor) {
            return super.visitEdge(pType, pPredecessor, pSuccessor);
        }
    }

    private static abstract class VisitOnceVisitor<N extends Node<?, ?, ?>>
    implements Visitor<N> {
        private final boolean forwards;
        private final Visitor<N> delegateVisitor;
        private final byte[] visited;
        private byte visitedMarker;

        private VisitOnceVisitor(boolean pForwards, Visitor<N> pDelegateVisitor, int pNodeCount) {
            this.forwards = pForwards;
            this.delegateVisitor = pDelegateVisitor;
            this.visited = new byte[pNodeCount];
            this.visitedMarker = 1;
        }

        private void reset() {
            this.visitedMarker = (byte)(this.visitedMarker + 1);
            if (this.visitedMarker == 0) {
                Arrays.fill(this.visited, (byte)0);
                this.visitedMarker = 1;
            }
        }

        private boolean isVisited(N pNode) {
            return this.visited[((Node)pNode).getId()] == this.visitedMarker;
        }

        @Override
        public VisitResult visitNode(N pNode) {
            if (!this.isVisited(pNode)) {
                this.visited[((Node)pNode).getId()] = this.visitedMarker;
                return this.delegateVisitor.visitNode(pNode);
            }
            return VisitResult.SKIP;
        }

        @Override
        public VisitResult visitEdge(EdgeType pType, N pPredecessor, N pSuccessor) {
            VisitResult visitResult = this.delegateVisitor.visitEdge(pType, pPredecessor, pSuccessor);
            if (visitResult == VisitResult.CONTINUE) {
                N nextNode;
                N n = nextNode = this.forwards ? pSuccessor : pPredecessor;
                if (this.isVisited(nextNode)) {
                    return VisitResult.SKIP;
                }
            }
            return visitResult;
        }
    }

    public static interface BackwardsVisitor<N extends Node<?, ?, ?>>
    extends Visitor<N> {
    }

    public static interface ForwardsVisitor<N extends Node<?, ?, ?>>
    extends Visitor<N> {
    }

    public static interface Visitor<N extends Node<?, ?, ?>> {
        public VisitResult visitNode(N var1);

        public VisitResult visitEdge(EdgeType var1, N var2, N var3);
    }

    public static enum VisitResult {
        CONTINUE,
        TERMINATE,
        SKIP;

    }

    private static final class TypeCounter<T extends Enum<T>> {
        private final int[] counters;

        private TypeCounter(int[] pCounters) {
            this.counters = pCounters;
        }

        private TypeCounter(int pTypeCount) {
            this(new int[pTypeCount]);
        }

        private int getCount(T pType) {
            return this.counters[((Enum)pType).ordinal()];
        }

        private void increment(T pType) {
            int n = ((Enum)pType).ordinal();
            this.counters[n] = this.counters[n] + 1;
        }

        private TypeCounter<T> copy() {
            return new TypeCounter<T>(Arrays.copyOf(this.counters, this.counters.length));
        }
    }

    private static final class NodeMapKey<P, T, V> {
        private final NodeType type;
        private final Optional<P> procedure;
        private final Optional<T> statement;
        private final Optional<V> variable;
        private final int hash;

        private NodeMapKey(NodeType pType, Optional<P> pProcedure, Optional<T> pStatement, Optional<V> pVariable) {
            this.type = pType;
            this.procedure = pProcedure;
            this.statement = pStatement;
            this.variable = pVariable;
            this.hash = Objects.hash(new Object[]{this.type, this.procedure, this.statement, this.variable});
        }

        private Node<P, T, V> createNode(int pId) {
            return new Node<P, T, V>(pId, this.type, this.procedure, this.statement, this.variable);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (pObject == null) {
                return false;
            }
            if (this.getClass() != pObject.getClass()) {
                return false;
            }
            NodeMapKey other = (NodeMapKey)pObject;
            return this.hash == other.hash && this.type == other.type && Objects.equals(this.procedure, other.procedure) && Objects.equals(this.statement, other.statement) && Objects.equals(this.variable, other.variable);
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "%s[type=%s, procedure=%s, statement=%s, variable=%s]", new Object[]{this.getClass().getName(), this.type, this.procedure, this.statement, this.variable});
        }
    }

    public static final class Builder<P, T, V, N extends Node<P, T, V>> {
        private final Function<Node<P, T, V>, N> nodeCreationFunction;
        private final List<N> nodes;
        private final List<GraphNode.MutableGraphNode<V, N>> graphNodes;
        private final Map<NodeMapKey<P, T, V>, GraphNode.MutableGraphNode<V, N>> nodeMap;
        private final TypeCounter<NodeType> nodeTypeCounter;
        private final TypeCounter<EdgeType> edgeTypeCounter;

        private Builder(Function<Node<P, T, V>, N> pNodeCreationFunction) {
            this.nodeCreationFunction = pNodeCreationFunction;
            this.nodes = new ArrayList<N>();
            this.graphNodes = new ArrayList<GraphNode.MutableGraphNode<V, N>>();
            this.nodeMap = new HashMap<NodeMapKey<P, T, V>, GraphNode.MutableGraphNode<V, N>>();
            this.nodeTypeCounter = new TypeCounter(NodeType.values().length);
            this.edgeTypeCounter = new TypeCounter(EdgeType.values().length);
        }

        private GraphNode.MutableGraphNode<V, N> newGraphNode(NodeMapKey<P, T, V> pNodeKey) {
            Node<P, T, V> node = pNodeKey.createNode(this.nodes.size());
            return new GraphNode.MutableGraphNode((Node)this.nodeCreationFunction.apply(node));
        }

        private GraphNode.MutableGraphNode<V, N> graphNode(NodeType pType, Optional<P> pProcedure, Optional<T> pStatement, Optional<V> pVariable) {
            NodeMapKey<P, T, V> nodeKey = new NodeMapKey<P, T, V>(pType, pProcedure, pStatement, pVariable);
            GraphNode.MutableGraphNode graphNode = this.nodeMap.computeIfAbsent(nodeKey, this::newGraphNode);
            Object node = graphNode.getNode();
            if (((Node)node).getId() == this.nodes.size()) {
                this.nodes.add(node);
                this.graphNodes.add(graphNode);
                this.nodeTypeCounter.increment(pType);
            }
            return graphNode;
        }

        private void insertEdge(GraphNode.MutableGraphNode<V, N> pPredecessor, GraphNode.MutableGraphNode<V, N> pSuccessor, EdgeType pType, Optional<V> pCause) {
            boolean insertEdge = true;
            if (pSuccessor.getEnteringEdgeCount() < pPredecessor.getLeavingEdgeCount()) {
                insertEdge = !pSuccessor.hasEnteringEdgeFrom(pType, pPredecessor);
            } else {
                boolean bl = insertEdge = !pPredecessor.hasLeavingEdgeTo(pType, pSuccessor);
            }
            if (insertEdge) {
                GraphEdge<V, N> edge = new GraphEdge<V, N>(pType, pPredecessor, pSuccessor);
                pPredecessor.addLeavingEdge(edge);
                pSuccessor.addEnteringEdge(edge);
            }
            if (pCause.isPresent()) {
                V variable = pCause.orElseThrow();
                pPredecessor.addDef(variable);
                pSuccessor.addUse(variable);
            }
            this.edgeTypeCounter.increment(pType);
        }

        int getNodeCount() {
            return this.nodes.size();
        }

        ImmutableList<N> getNodes() {
            return ImmutableList.copyOf(this.nodes);
        }

        void traverse(Collection<N> pStartNodes, ForwardsVisitor<N> pVisitor) {
            SystemDependenceGraph.traverse(this.graphNodes, pStartNodes, pVisitor, true);
        }

        void traverse(Collection<N> pStartNodes, BackwardsVisitor<N> pVisitor) {
            SystemDependenceGraph.traverse(this.graphNodes, pStartNodes, pVisitor, false);
        }

        int[] createIds(Function<Node<P, T, V>, Optional<?>> pFunction) {
            Objects.requireNonNull(pFunction, "pFunction must not be null");
            HashMap<Object, Integer> resultMap = new HashMap<Object, Integer>();
            int[] ids = new int[this.nodes.size()];
            for (int nodeId = 0; nodeId < ids.length; ++nodeId) {
                int id;
                Node node = (Node)this.nodes.get(nodeId);
                Optional<?> result = pFunction.apply(node);
                ids[nodeId] = result != null && result.isPresent() ? (id = resultMap.computeIfAbsent(result.orElseThrow(), key -> resultMap.size()).intValue()) : -1;
            }
            return ids;
        }

        void insertActualSummaryEdges(N pFormalInNode, N pFormalOutNode) {
            Objects.requireNonNull(pFormalInNode, "pFormalInNode must not be null");
            Objects.requireNonNull(pFormalInNode, "pFormalOutNode must not be null");
            Preconditions.checkArgument((((Node)pFormalInNode).getType() == NodeType.FORMAL_IN ? 1 : 0) != 0, (Object)"pFormalInNode does not have type FORMAL_IN");
            Preconditions.checkArgument((((Node)pFormalOutNode).getType() == NodeType.FORMAL_OUT ? 1 : 0) != 0, (Object)"pFormalOutNode does not have type FORMAL_OUT");
            GraphNode formalOutGraphNode = this.graphNodes.get(((Node)pFormalOutNode).getId());
            Preconditions.checkArgument((boolean)((Node)formalOutGraphNode.getNode()).equals(pFormalOutNode), (Object)"pFormalOutNode does not belong to this SDG builder");
            for (GraphEdge outEdge : formalOutGraphNode.getLeavingEdges()) {
                if (outEdge.getType() != EdgeType.PARAMETER_EDGE) continue;
                GraphNode.MutableGraphNode actualOutGraphNode = (GraphNode.MutableGraphNode)outEdge.getSuccessor();
                assert (((Node)actualOutGraphNode.getNode()).getType() == NodeType.ACTUAL_OUT);
                NodeMapKey actualInNodeKey = new NodeMapKey(NodeType.ACTUAL_IN, ((Node)actualOutGraphNode.getNode()).getProcedure(), ((Node)actualOutGraphNode.getNode()).getStatement(), ((Node)pFormalInNode).getVariable());
                GraphNode.MutableGraphNode<V, N> actualInGraphNode = this.nodeMap.get(actualInNodeKey);
                if (actualInGraphNode == null) continue;
                this.insertEdge(actualInGraphNode, actualOutGraphNode, EdgeType.SUMMARY_EDGE, Optional.empty());
            }
        }

        public EdgeChooser node(NodeType pType, Optional<P> pProcedure, Optional<T> pStatement, Optional<V> pVariable) {
            Objects.requireNonNull(pType, "pType must not be null");
            Objects.requireNonNull(pProcedure, "pProcedure must not be null");
            Objects.requireNonNull(pStatement, "pStatement must not be null");
            Objects.requireNonNull(pVariable, "pVariable must not be null");
            return new EdgeChooser(this.graphNode(pType, pProcedure, pStatement, pVariable));
        }

        /*
         * WARNING - void declaration
         */
        public SystemDependenceGraph<V, N> build() {
            void var5_8;
            ImmutableList.Builder immutableGraphNodesBuilder = ImmutableList.builderWithExpectedSize((int)this.graphNodes.size());
            ArrayList<ImmutableList.Builder> immutableEnteringEdges = new ArrayList<ImmutableList.Builder>(this.graphNodes.size());
            ArrayList<ImmutableList.Builder> immutableLeavingEdges = new ArrayList<ImmutableList.Builder>(this.graphNodes.size());
            for (GraphNode.MutableGraphNode<V, N> mutableGraphNode : this.graphNodes) {
                immutableGraphNodesBuilder.add(new GraphNode.ImmutableGraphNode(mutableGraphNode.getNode(), ImmutableSet.copyOf(mutableGraphNode.getDefs()), ImmutableSet.copyOf(mutableGraphNode.getUses())));
                immutableEnteringEdges.add(ImmutableList.builderWithExpectedSize((int)mutableGraphNode.getEnteringEdgeCount()));
                immutableLeavingEdges.add(ImmutableList.builderWithExpectedSize((int)mutableGraphNode.getLeavingEdgeCount()));
            }
            ImmutableList immutableGraphNodes = immutableGraphNodesBuilder.build();
            for (GraphNode.MutableGraphNode<V, N> mutableGraphNode : this.graphNodes) {
                int predecessorId = ((Node)mutableGraphNode.getNode()).getId();
                for (GraphEdge<V, N> graphEdge : mutableGraphNode.getLeavingEdges()) {
                    int successorId = ((Node)graphEdge.getSuccessor().getNode()).getId();
                    GraphEdge immutableGraphEdge = new GraphEdge(graphEdge.getType(), (GraphNode)immutableGraphNodes.get(predecessorId), (GraphNode)immutableGraphNodes.get(successorId));
                    ((ImmutableList.Builder)immutableLeavingEdges.get(predecessorId)).add(immutableGraphEdge);
                    ((ImmutableList.Builder)immutableEnteringEdges.get(successorId)).add(immutableGraphEdge);
                }
            }
            boolean bl = false;
            while (var5_8 < immutableGraphNodes.size()) {
                GraphNode.ImmutableGraphNode immutableGraphNode = (GraphNode.ImmutableGraphNode)immutableGraphNodes.get((int)var5_8);
                immutableGraphNode.enteringEdges = ((ImmutableList.Builder)immutableEnteringEdges.get((int)var5_8)).build();
                immutableGraphNode.leavingEdges = ((ImmutableList.Builder)immutableLeavingEdges.get((int)var5_8)).build();
                ++var5_8;
            }
            return new SystemDependenceGraph(ImmutableList.copyOf(this.nodes), immutableGraphNodes, this.nodeTypeCounter.copy(), this.edgeTypeCounter.copy());
        }

        public final class DependencyChooser {
            private final GraphNode.MutableGraphNode<V, N> graphNode;
            private final EdgeType edgeType;
            private final Optional<V> cause;

            private DependencyChooser(GraphNode.MutableGraphNode<V, N> pGraphNode, EdgeType pEdgeType, Optional<V> pCause) {
                this.graphNode = pGraphNode;
                this.edgeType = pEdgeType;
                this.cause = pCause;
            }

            public void on(NodeType pType, Optional<P> pProcedure, Optional<T> pStatement, Optional<V> pVariable) {
                Objects.requireNonNull(pType, "pType must not be null");
                Objects.requireNonNull(pProcedure, "pProcedure must not be null");
                Objects.requireNonNull(pStatement, "pStatement must not be null");
                Objects.requireNonNull(pVariable, "pVariable must not be null");
                Builder.this.insertEdge(Builder.this.graphNode(pType, pProcedure, pStatement, pVariable), this.graphNode, this.edgeType, this.cause);
            }
        }

        public final class EdgeChooser {
            private final GraphNode.MutableGraphNode<V, N> graphNode;

            private EdgeChooser(GraphNode.MutableGraphNode<V, N> pGraphNode) {
                this.graphNode = pGraphNode;
            }

            public DependencyChooser depends(EdgeType pType, Optional<V> pCause) {
                Objects.requireNonNull(pType, "pType must not be null");
                Objects.requireNonNull(pCause, "pCause must not be null");
                return new DependencyChooser(this.graphNode, pType, pCause);
            }

            public N getNode() {
                return this.graphNode.getNode();
            }
        }
    }

    private static final class GraphEdge<V, N extends Node<?, ?, V>> {
        private final EdgeType type;
        private final GraphNode<V, N> predecessor;
        private final GraphNode<V, N> successor;

        private GraphEdge(EdgeType pType, GraphNode<V, N> pPredecessor, GraphNode<V, N> pSuccessor) {
            this.type = pType;
            this.predecessor = pPredecessor;
            this.successor = pSuccessor;
        }

        private EdgeType getType() {
            return this.type;
        }

        private GraphNode<V, N> getPredecessor() {
            return this.predecessor;
        }

        private GraphNode<V, N> getSuccessor() {
            return this.successor;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.predecessor, this.successor});
        }

        public boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (pObject == null) {
                return false;
            }
            if (this.getClass() != pObject.getClass()) {
                return false;
            }
            GraphEdge other = (GraphEdge)pObject;
            return this.type == other.type && Objects.equals(this.predecessor, other.predecessor) && Objects.equals(this.successor, other.successor);
        }

        public String toString() {
            return String.format(Locale.ENGLISH, "%s[type=%s, predecessor=%s, successor=%s]", new Object[]{this.getClass().getName(), this.type, this.predecessor, this.successor});
        }
    }

    private static abstract class GraphNode<V, N extends Node<?, ?, V>> {
        private final N node;

        private GraphNode(N pNode) {
            this.node = pNode;
        }

        final N getNode() {
            return this.node;
        }

        abstract List<GraphEdge<V, N>> getEnteringEdges();

        abstract List<GraphEdge<V, N>> getLeavingEdges();

        abstract Set<V> getDefs();

        abstract Set<V> getUses();

        public final int hashCode() {
            return ((Node)this.node).hashCode();
        }

        public final boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (!(pObject instanceof GraphNode)) {
                return false;
            }
            GraphNode other = (GraphNode)pObject;
            return ((Node)this.node).equals(other.node);
        }

        public final String toString() {
            return String.format(Locale.ENGLISH, "%s[node=%s, enteringEdges=%s, leavingEdges=%s, defs=%s, uses=%s]", this.getClass().getName(), this.node, this.getEnteringEdges(), this.getLeavingEdges(), this.getDefs(), this.getUses());
        }

        private static class ImmutableGraphNode<V, N extends Node<?, ?, V>>
        extends GraphNode<V, N> {
            private ImmutableList<GraphEdge<V, N>> enteringEdges;
            private ImmutableList<GraphEdge<V, N>> leavingEdges;
            private ImmutableSet<V> defs;
            private ImmutableSet<V> uses;

            private ImmutableGraphNode(N pNode, ImmutableSet<V> pDefs, ImmutableSet<V> pUses) {
                super(pNode);
                this.defs = pDefs;
                this.uses = pUses;
            }

            @Override
            ImmutableList<GraphEdge<V, N>> getEnteringEdges() {
                return this.enteringEdges;
            }

            @Override
            ImmutableList<GraphEdge<V, N>> getLeavingEdges() {
                return this.leavingEdges;
            }

            @Override
            ImmutableSet<V> getDefs() {
                return this.defs;
            }

            @Override
            ImmutableSet<V> getUses() {
                return this.uses;
            }
        }

        private static class MutableGraphNode<V, N extends Node<?, ?, V>>
        extends GraphNode<V, N> {
            private final List<GraphEdge<V, N>> enteringEdges = new ArrayList<GraphEdge<V, N>>();
            private final List<GraphEdge<V, N>> leavingEdges = new ArrayList<GraphEdge<V, N>>();
            private final Set<V> defs = new HashSet<V>();
            private final Set<V> uses = new HashSet<V>();

            private MutableGraphNode(N pNode) {
                super(pNode);
            }

            private int getEnteringEdgeCount() {
                return this.enteringEdges.size();
            }

            @Override
            List<GraphEdge<V, N>> getEnteringEdges() {
                return this.enteringEdges;
            }

            private boolean hasEnteringEdgeFrom(EdgeType pType, GraphNode<V, N> pPredecessor) {
                for (GraphEdge<V, N> graphEdge : this.enteringEdges) {
                    if (graphEdge.getType() != pType || graphEdge.getPredecessor() != pPredecessor) continue;
                    return true;
                }
                return false;
            }

            private void addEnteringEdge(GraphEdge<V, N> pEdge) {
                this.enteringEdges.add(pEdge);
            }

            private int getLeavingEdgeCount() {
                return this.leavingEdges.size();
            }

            @Override
            List<GraphEdge<V, N>> getLeavingEdges() {
                return this.leavingEdges;
            }

            private boolean hasLeavingEdgeTo(EdgeType pType, GraphNode<V, N> pSuccessor) {
                for (GraphEdge<V, N> graphEdge : this.leavingEdges) {
                    if (graphEdge.getType() != pType || graphEdge.getSuccessor() != pSuccessor) continue;
                    return true;
                }
                return false;
            }

            private void addLeavingEdge(GraphEdge<V, N> pEdge) {
                this.leavingEdges.add(pEdge);
            }

            @Override
            Set<V> getDefs() {
                return this.defs;
            }

            private void addDef(V pVariable) {
                this.defs.add(pVariable);
            }

            @Override
            Set<V> getUses() {
                return this.uses;
            }

            private void addUse(V pVariable) {
                this.uses.add(pVariable);
            }
        }
    }

    public static class Node<P, T, V> {
        private final int id;
        private final NodeType type;
        private final Optional<P> procedure;
        private final Optional<T> statement;
        private final Optional<V> variable;
        private final int hash;

        private Node(int pId, NodeType pType, Optional<P> pProcedure, Optional<T> pStatement, Optional<V> pVariable) {
            this.id = pId;
            this.type = pType;
            this.procedure = pProcedure;
            this.statement = pStatement;
            this.variable = pVariable;
            this.hash = Objects.hash(new Object[]{this.id, this.type, this.procedure, this.statement, this.variable});
        }

        protected Node(Node<P, T, V> pNode) {
            this(pNode.id, pNode.type, pNode.procedure, pNode.statement, pNode.variable);
        }

        public final int getId() {
            return this.id;
        }

        public final NodeType getType() {
            return this.type;
        }

        public final Optional<P> getProcedure() {
            return this.procedure;
        }

        public final Optional<T> getStatement() {
            return this.statement;
        }

        public final Optional<V> getVariable() {
            return this.variable;
        }

        public final int hashCode() {
            return this.hash;
        }

        public final boolean equals(Object pObject) {
            if (this == pObject) {
                return true;
            }
            if (!(pObject instanceof Node)) {
                return false;
            }
            Node other = (Node)pObject;
            return this.id == other.id && this.hash == other.hash && this.type == other.type && Objects.equals(this.procedure, other.procedure) && Objects.equals(this.statement, other.statement) && Objects.equals(this.variable, other.variable);
        }

        public final String toString() {
            return String.format(Locale.ENGLISH, "%s[id=%d, type=%s, procedure=%s, statement=%s, variable=%s]", new Object[]{this.getClass().getName(), this.id, this.type, this.procedure, this.statement, this.variable});
        }
    }

    public static enum EdgeType {
        FLOW_DEPENDENCY,
        CONTROL_DEPENDENCY,
        DECLARATION_EDGE,
        CALL_EDGE,
        PARAMETER_EDGE,
        SUMMARY_EDGE;

    }

    public static enum NodeType {
        ENTRY,
        STATEMENT,
        FORMAL_IN,
        FORMAL_OUT,
        ACTUAL_IN,
        ACTUAL_OUT;

    }
}

