/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Iterator;
import org.sosy_lab.cpachecker.util.expressions.AbstractExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public class And<LeafType>
extends AbstractExpressionTree<LeafType>
implements Iterable<ExpressionTree<LeafType>> {
    private final ImmutableSet<ExpressionTree<LeafType>> operands;
    private final int hashCode;

    private And(ImmutableSet<ExpressionTree<LeafType>> pOperands) {
        assert (Iterables.size(pOperands) >= 2);
        assert (!Iterables.contains(pOperands, ExpressionTrees.getFalse()));
        assert (!Iterables.contains(pOperands, ExpressionTrees.getTrue()));
        assert (!FluentIterable.from(pOperands).anyMatch(Predicates.instanceOf(And.class)));
        this.operands = pOperands;
        this.hashCode = this.operands.hashCode();
    }

    @Override
    public Iterator<ExpressionTree<LeafType>> iterator() {
        return this.operands.iterator();
    }

    @Override
    public <T, E extends Throwable> T accept(ExpressionTreeVisitor<LeafType, T, E> pVisitor) throws E {
        return pVisitor.visit(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof And) {
            And other = (And)pObj;
            return this.hashCode == other.hashCode && this.operands.equals(other.operands);
        }
        return false;
    }

    public static <LeafType> ExpressionTree<LeafType> of(ExpressionTree<LeafType> pOp1, ExpressionTree<LeafType> pOp2) {
        return And.of(ImmutableList.of(pOp1, pOp2));
    }

    public static <LeafType> ExpressionTree<LeafType> of(Iterable<ExpressionTree<LeafType>> pOperands) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (ExpressionTree<LeafType> operand : pOperands) {
            if (ExpressionTrees.getFalse().equals(operand)) {
                return ExpressionTrees.getFalse();
            }
            if (ExpressionTrees.getTrue().equals(operand)) continue;
            if (operand instanceof And) {
                builder.addAll(((And)operand).operands);
                continue;
            }
            builder.add(operand);
        }
        ImmutableSet operands = builder.build();
        if (operands.isEmpty()) {
            return ExpressionTrees.getTrue();
        }
        if (operands.size() == 1) {
            return (ExpressionTree)operands.iterator().next();
        }
        return new And<LeafType>(operands);
    }
}

