/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;

public class CachingExpressionTreeFactory<LeafType>
implements ExpressionTreeFactory<LeafType> {
    private final Map<ExpressionTree<LeafType>, ExpressionTree<LeafType>> leafCache = new HashMap<ExpressionTree<LeafType>, ExpressionTree<LeafType>>();
    private final Map<Set<ExpressionTree<LeafType>>, ExpressionTree<LeafType>> andCache = new HashMap<Set<ExpressionTree<LeafType>>, ExpressionTree<LeafType>>();
    private final Map<Set<ExpressionTree<LeafType>>, ExpressionTree<LeafType>> orCache = new HashMap<Set<ExpressionTree<LeafType>>, ExpressionTree<LeafType>>();

    @Override
    public ExpressionTree<LeafType> leaf(LeafType pLeafType) {
        return this.leaf(pLeafType, true);
    }

    @Override
    public ExpressionTree<LeafType> leaf(LeafType pLeafExpression, boolean pAssumeTruth) {
        ExpressionTree potentialResult = LeafExpression.of(pLeafExpression, pAssumeTruth);
        return this.leafCache.computeIfAbsent(potentialResult, ignore -> potentialResult);
    }

    @Override
    public ExpressionTree<LeafType> and(ExpressionTree<LeafType> pOp1, ExpressionTree<LeafType> pOp2) {
        return this.and((Collection<ExpressionTree<LeafType>>)ImmutableSet.of(pOp1, pOp2));
    }

    @Override
    public ExpressionTree<LeafType> and(Collection<ExpressionTree<LeafType>> pOperands) {
        switch (pOperands.size()) {
            case 0: {
                return ExpressionTrees.getTrue();
            }
            case 1: {
                return (ExpressionTree)Iterables.getOnlyElement(pOperands);
            }
        }
        ImmutableSet key = ImmutableSet.copyOf(pOperands);
        return this.andCache.computeIfAbsent((Set<ExpressionTree<LeafType>>)key, (Function<Set<ExpressionTree<LeafType>>, ExpressionTree<LeafType>>)((Function<Set, ExpressionTree>)arg_0 -> CachingExpressionTreeFactory.lambda$and$1((Set)key, arg_0)));
    }

    @Override
    public ExpressionTree<LeafType> or(ExpressionTree<LeafType> pOp1, ExpressionTree<LeafType> pOp2) {
        return this.or((Collection<ExpressionTree<LeafType>>)ImmutableSet.of(pOp1, pOp2));
    }

    @Override
    public ExpressionTree<LeafType> or(Collection<ExpressionTree<LeafType>> pOperands) {
        switch (pOperands.size()) {
            case 0: {
                return ExpressionTrees.getFalse();
            }
            case 1: {
                return (ExpressionTree)Iterables.getOnlyElement(pOperands);
            }
        }
        ImmutableSet key = ImmutableSet.copyOf(pOperands);
        return this.orCache.computeIfAbsent((Set<ExpressionTree<LeafType>>)key, (Function<Set<ExpressionTree<LeafType>>, ExpressionTree<LeafType>>)((Function<Set, ExpressionTree>)arg_0 -> CachingExpressionTreeFactory.lambda$or$2((Set)key, arg_0)));
    }

    private static /* synthetic */ ExpressionTree lambda$or$2(Set key, Set ignore) {
        return Or.of(key);
    }

    private static /* synthetic */ ExpressionTree lambda$and$1(Set key, Set ignore) {
        return And.of(key);
    }
}

