/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import java.util.HashMap;
import java.util.Map;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.DefaultExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;

public abstract class CachingVisitor<LeafType, T, E extends Throwable>
extends DefaultExpressionTreeVisitor<LeafType, T, E> {
    private final Map<ExpressionTree<LeafType>, T> memo = new HashMap<ExpressionTree<LeafType>, T>();

    @Override
    protected T visitDefault(ExpressionTree<LeafType> pExpressionTree) throws E {
        T result = this.memo.get(pExpressionTree);
        if (result != null) {
            return result;
        }
        result = pExpressionTree.accept(new ExpressionTreeVisitor<LeafType, T, E>(){

            @Override
            public T visit(And<LeafType> pAnd) throws Throwable {
                return CachingVisitor.this.cacheMissAnd(pAnd);
            }

            @Override
            public T visit(Or<LeafType> pOr) throws Throwable {
                return CachingVisitor.this.cacheMissOr(pOr);
            }

            @Override
            public T visit(LeafExpression<LeafType> pLeafExpression) throws Throwable {
                return CachingVisitor.this.cacheMissLeaf(pLeafExpression);
            }

            @Override
            public T visitTrue() throws Throwable {
                return CachingVisitor.this.cacheMissTrue();
            }

            @Override
            public T visitFalse() throws Throwable {
                return CachingVisitor.this.cacheMissFalse();
            }
        });
        this.memo.put(pExpressionTree, result);
        return result;
    }

    protected abstract T cacheMissAnd(And<LeafType> var1) throws E;

    protected abstract T cacheMissOr(Or<LeafType> var1) throws E;

    protected abstract T cacheMissLeaf(LeafExpression<LeafType> var1) throws E;

    protected abstract T cacheMissTrue() throws E;

    protected abstract T cacheMissFalse() throws E;
}

