/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import org.sosy_lab.cpachecker.util.expressions.DefaultExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;

public class DownwardCastingVisitor<ActualType, DesiredType extends ActualType>
extends DefaultExpressionTreeVisitor<ActualType, ExpressionTree<DesiredType>, IncompatibleLeafTypesException> {
    private final Class<DesiredType> desiredClass;

    public DownwardCastingVisitor(Class<DesiredType> pDesiredClass) {
        this.desiredClass = pDesiredClass;
    }

    @Override
    protected ExpressionTree<DesiredType> visitDefault(ExpressionTree<ActualType> pExpressionTree) throws IncompatibleLeafTypesException {
        ExpressionTree<ActualType> expressionTreeAny = pExpressionTree;
        return expressionTreeAny;
    }

    @Override
    public ExpressionTree<DesiredType> visit(LeafExpression<ActualType> pLeafExpression) throws IncompatibleLeafTypesException {
        if (!this.desiredClass.isInstance(pLeafExpression.getExpression())) {
            throw new IncompatibleLeafTypesException(pLeafExpression.getExpression().getClass(), this.desiredClass);
        }
        return this.visitDefault((ExpressionTree)pLeafExpression);
    }

    public static class IncompatibleLeafTypesException
    extends Exception {
        private static final long serialVersionUID = -2173628713139897329L;
        private final Class<?> actual;
        private final Class<?> desired;

        private IncompatibleLeafTypesException(Class<?> pActual, Class<?> pDesired) {
            super("Cannot cast from " + pActual + "to " + pDesired.getName());
            this.actual = pActual;
            this.desired = pDesired;
        }

        public Class<?> getActualClass() {
            return this.actual;
        }

        public Class<?> getDesiredClass() {
            return this.desired;
        }
    }
}

