/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Comparators;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.graph.Traverser;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.expressions.AbstractExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.CachingExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.CachingVisitor;
import org.sosy_lab.cpachecker.util.expressions.DefaultExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeFactory;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.expressions.Simplifier;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaToCVisitor;
import org.sosy_lab.java_smt.api.BooleanFormula;
import org.sosy_lab.java_smt.api.Formula;

public final class ExpressionTrees {
    private static final String FUNCTION_DELIMITER = "::";
    private static final ExpressionTree<Object> TRUE = new AbstractExpressionTree<Object>(){

        @Override
        public <T, E extends Throwable> T accept(ExpressionTreeVisitor<Object, T, E> pVisitor) throws E {
            return pVisitor.visitTrue();
        }

        public int hashCode() {
            return 1;
        }

        public boolean equals(Object pObj) {
            return this == pObj;
        }
    };
    private static final ExpressionTree<Object> FALSE = new AbstractExpressionTree<Object>(){

        @Override
        public <T, E extends Throwable> T accept(ExpressionTreeVisitor<Object, T, E> pVisitor) throws E {
            return pVisitor.visitFalse();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object pObj) {
            return this == pObj;
        }
    };
    private static final ExpressionTreeVisitor<Object, Integer, NoException> TYPE_ORDER_VISITOR = new ExpressionTreeVisitor<Object, Integer, NoException>(){

        @Override
        public Integer visitFalse() {
            return 0;
        }

        @Override
        public Integer visitTrue() {
            return 1;
        }

        @Override
        public Integer visit(LeafExpression<Object> pLeafExpression) {
            return 2;
        }

        @Override
        public Integer visit(Or<Object> pOr) {
            return 3;
        }

        @Override
        public Integer visit(And<Object> pAnd) {
            return 4;
        }
    };

    public static <LeafType> ExpressionTree<LeafType> getTrue() {
        return TRUE;
    }

    public static <LeafType> ExpressionTree<LeafType> getFalse() {
        return FALSE;
    }

    private ExpressionTrees() {
    }

    public static <LeafType> boolean isConstant(ExpressionTree<LeafType> pExpressionTree) {
        DefaultExpressionTreeVisitor visitor = new DefaultExpressionTreeVisitor<LeafType, Boolean, NoException>(){

            @Override
            protected Boolean visitDefault(ExpressionTree<LeafType> pExprTree) {
                return false;
            }

            @Override
            public Boolean visitTrue() {
                return true;
            }

            @Override
            public Boolean visitFalse() {
                return true;
            }
        };
        return (Boolean)pExpressionTree.accept(visitor);
    }

    public static <LeafType> boolean isLeaf(ExpressionTree<LeafType> pExpressionTree) {
        DefaultExpressionTreeVisitor visitor = new DefaultExpressionTreeVisitor<LeafType, Boolean, NoException>(){

            @Override
            protected Boolean visitDefault(ExpressionTree<LeafType> pExprTree) {
                return false;
            }

            @Override
            public Boolean visit(LeafExpression<LeafType> pLeafExpression) {
                return true;
            }

            @Override
            public Boolean visitTrue() {
                return true;
            }

            @Override
            public Boolean visitFalse() {
                return true;
            }
        };
        return (Boolean)pExpressionTree.accept(visitor);
    }

    public static <LeafType> boolean isOr(ExpressionTree<LeafType> pExpressionTree) {
        DefaultExpressionTreeVisitor visitor = new DefaultExpressionTreeVisitor<LeafType, Boolean, NoException>(){

            @Override
            protected Boolean visitDefault(ExpressionTree<LeafType> pExprTree) {
                return false;
            }

            @Override
            public Boolean visit(Or<LeafType> pOr) {
                return true;
            }
        };
        return (Boolean)pExpressionTree.accept(visitor);
    }

    public static <LeafType> boolean isAnd(ExpressionTree<LeafType> pExpressionTree) {
        DefaultExpressionTreeVisitor visitor = new DefaultExpressionTreeVisitor<LeafType, Boolean, NoException>(){

            @Override
            protected Boolean visitDefault(ExpressionTree<LeafType> pExprTree) {
                return false;
            }

            @Override
            public Boolean visit(And<LeafType> pAnd) {
                return true;
            }
        };
        return (Boolean)pExpressionTree.accept(visitor);
    }

    public static <LeafType> Iterable<ExpressionTree<LeafType>> traverseRecursively(ExpressionTree<LeafType> pExpressionTree) {
        return Traverser.forTree(node -> ExpressionTrees.getChildren(node)).depthFirstPreOrder(pExpressionTree);
    }

    public static <LeafType> boolean isInCNF(ExpressionTree<LeafType> pExpressionTree) {
        ExpressionTreeVisitor visitor = new ExpressionTreeVisitor<LeafType, Boolean, NoException>(){

            @Override
            public Boolean visit(And<LeafType> pAnd) {
                assert (ExpressionTrees.getChildren(pAnd).allMatch(pClause -> !ExpressionTrees.isAnd(pClause))) : "A conjunction must not contain child conjunctions";
                return ExpressionTrees.getChildren(pAnd).allMatch(pClause -> ExpressionTrees.isCNFClause(pClause));
            }

            @Override
            public Boolean visit(Or<LeafType> pOr) {
                return ExpressionTrees.getChildren(pOr).allMatch(ExpressionTrees::isLeaf);
            }

            @Override
            public Boolean visit(LeafExpression<LeafType> pLeafExpression) {
                return true;
            }

            @Override
            public Boolean visitTrue() {
                return true;
            }

            @Override
            public Boolean visitFalse() {
                return true;
            }
        };
        return (Boolean)pExpressionTree.accept(visitor);
    }

    public static <LeafType> boolean isInDNF(ExpressionTree<LeafType> pExpressionTree) {
        ExpressionTreeVisitor visitor = new ExpressionTreeVisitor<LeafType, Boolean, NoException>(){

            @Override
            public Boolean visit(And<LeafType> pAnd) {
                return ExpressionTrees.getChildren(pAnd).allMatch(ExpressionTrees::isLeaf);
            }

            @Override
            public Boolean visit(Or<LeafType> pOr) {
                assert (ExpressionTrees.getChildren(pOr).allMatch(pClause -> !ExpressionTrees.isOr(pClause))) : "A disjunction must not contain child disjunctions";
                return ExpressionTrees.getChildren(pOr).allMatch(pClause -> ExpressionTrees.isDNFClause(pClause));
            }

            @Override
            public Boolean visit(LeafExpression<LeafType> pLeafExpression) {
                return true;
            }

            @Override
            public Boolean visitTrue() {
                return true;
            }

            @Override
            public Boolean visitFalse() {
                return true;
            }
        };
        return (Boolean)pExpressionTree.accept(visitor);
    }

    public static <LeafType> ExpressionTree<LeafType> toDNF(ExpressionTree<LeafType> pExpressionTree) {
        if (ExpressionTrees.isInDNF(pExpressionTree)) {
            return pExpressionTree;
        }
        if (ExpressionTrees.isOr(pExpressionTree)) {
            return Or.of(ExpressionTrees.getChildren(pExpressionTree).transform(pExprTree -> ExpressionTrees.toDNF(pExprTree)));
        }
        assert (ExpressionTrees.isAnd(pExpressionTree));
        Iterator elementIterator = ExpressionTrees.getChildren(pExpressionTree).iterator();
        if (!elementIterator.hasNext()) {
            return ExpressionTrees.getTrue();
        }
        ExpressionTree first = (ExpressionTree)elementIterator.next();
        if (!elementIterator.hasNext()) {
            return first;
        }
        ArrayList rest = new ArrayList();
        Iterators.addAll(rest, (Iterator)elementIterator);
        ExpressionTree<LeafType> firstDNF = ExpressionTrees.toDNF(first);
        ExpressionTree restDNF = ExpressionTrees.toDNF(And.of(rest));
        Set<ExpressionTree<LeafType>> combinatorsA = ExpressionTrees.isLeaf(firstDNF) ? Collections.singleton(firstDNF) : ExpressionTrees.getChildren(firstDNF);
        Set combinatorsB = ExpressionTrees.isLeaf(restDNF) ? Collections.singleton(restDNF) : ExpressionTrees.getChildren(restDNF);
        ArrayList newClauses = new ArrayList();
        for (ExpressionTree expressionTree : combinatorsA) {
            for (ExpressionTree expressionTree2 : combinatorsB) {
                newClauses.add(And.of(ImmutableList.of((Object)expressionTree, (Object)expressionTree2)));
            }
        }
        return Or.of(newClauses);
    }

    public static <LeafType> ExpressionTree<LeafType> toCNF(ExpressionTree<LeafType> pExpressionTree) {
        if (ExpressionTrees.isInCNF(pExpressionTree)) {
            return pExpressionTree;
        }
        if (ExpressionTrees.isAnd(pExpressionTree)) {
            return And.of(ExpressionTrees.getChildren(pExpressionTree).transform(pExprTree -> ExpressionTrees.toCNF(pExprTree)));
        }
        assert (ExpressionTrees.isOr(pExpressionTree));
        Iterator elementIterator = ExpressionTrees.getChildren(pExpressionTree).iterator();
        if (!elementIterator.hasNext()) {
            return ExpressionTrees.getFalse();
        }
        ExpressionTree first = (ExpressionTree)elementIterator.next();
        if (!elementIterator.hasNext()) {
            return first;
        }
        ArrayList rest = new ArrayList();
        Iterators.addAll(rest, (Iterator)elementIterator);
        ExpressionTree<LeafType> firstCNF = ExpressionTrees.toCNF(first);
        ExpressionTree restCNF = ExpressionTrees.toCNF(And.of(rest));
        Set<ExpressionTree<LeafType>> combinatorsA = ExpressionTrees.isLeaf(firstCNF) ? Collections.singleton(firstCNF) : ExpressionTrees.getChildren(firstCNF);
        Set combinatorsB = ExpressionTrees.isLeaf(restCNF) ? Collections.singleton(restCNF) : ExpressionTrees.getChildren(restCNF);
        ArrayList newClauses = new ArrayList();
        for (ExpressionTree expressionTree : combinatorsA) {
            for (ExpressionTree expressionTree2 : combinatorsB) {
                newClauses.add(Or.of(ImmutableList.of((Object)expressionTree, (Object)expressionTree2)));
            }
        }
        return And.of(newClauses);
    }

    public static <LeafType> boolean isCNFClause(ExpressionTree<LeafType> pExpressionTree) {
        return ExpressionTrees.isLeaf(pExpressionTree) || ExpressionTrees.isOr(pExpressionTree) && ExpressionTrees.getChildren(pExpressionTree).allMatch(ExpressionTrees::isLeaf);
    }

    public static <LeafType> boolean isDNFClause(ExpressionTree<LeafType> pExpressionTree) {
        return ExpressionTrees.isLeaf(pExpressionTree) || ExpressionTrees.isAnd(pExpressionTree) && ExpressionTrees.getChildren(pExpressionTree).allMatch(ExpressionTrees::isLeaf);
    }

    public static <LeafType> FluentIterable<ExpressionTree<LeafType>> getChildren(ExpressionTree<LeafType> pExpressionTree) {
        return FluentIterable.from((Iterable)((Iterable)pExpressionTree.accept(new DefaultExpressionTreeVisitor<LeafType, Iterable<ExpressionTree<LeafType>>, NoException>(){

            @Override
            protected Iterable<ExpressionTree<LeafType>> visitDefault(ExpressionTree<LeafType> pExprTree) {
                return ImmutableSet.of();
            }

            @Override
            public Iterable<ExpressionTree<LeafType>> visit(And<LeafType> pAnd) {
                return pAnd;
            }

            @Override
            public Iterable<ExpressionTree<LeafType>> visit(Or<LeafType> pOr) {
                return pOr;
            }
        })));
    }

    public static <LeafType> Simplifier<LeafType> newSimplifier() {
        return ExpressionTrees.newSimplifier(ExpressionTrees.newFactory());
    }

    public static <LeafType> Simplifier<LeafType> newSimplifier(final ExpressionTreeFactory<LeafType> pFactory) {
        return new Simplifier<LeafType>(){
            private final Map<Set<ExpressionTree<LeafType>>, ExpressionTreeVisitor<LeafType, ExpressionTree<LeafType>, NoException>> simplificationVisitors = new HashMap();

            @Override
            public ExpressionTree<LeafType> simplify(ExpressionTree<LeafType> pExpressionTree) {
                return ExpressionTrees.simplify(pExpressionTree, ImmutableSet.of(), this.simplificationVisitors, pFactory, true);
            }
        };
    }

    public static <LeafType> ExpressionTree<LeafType> simplify(ExpressionTree<LeafType> pExpressionTree) {
        return ExpressionTrees.simplify(pExpressionTree, ExpressionTrees.newFactory());
    }

    private static <LeafType> ExpressionTree<LeafType> simplify(ExpressionTree<LeafType> pExpressionTree, ExpressionTreeFactory<LeafType> pFactory) {
        return ExpressionTrees.simplify(pExpressionTree, ImmutableSet.of(), new HashMap<Set<ExpressionTree<LeafType>>, ExpressionTreeVisitor<LeafType, ExpressionTree<LeafType>, NoException>>(), pFactory, true);
    }

    private static <LeafType> ExpressionTree<LeafType> simplify(ExpressionTree<LeafType> pExpressionTree, Set<ExpressionTree<LeafType>> pExternalKnowledge, Map<Set<ExpressionTree<LeafType>>, ExpressionTreeVisitor<LeafType, ExpressionTree<LeafType>, NoException>> pVisitorCache, ExpressionTreeFactory<LeafType> pFactory, boolean pThorough) {
        LeafExpression negated;
        ExpressionTree<LeafType> expressionTree = pExpressionTree;
        if (ExpressionTrees.isConstant(expressionTree)) {
            return pExpressionTree;
        }
        if (pExternalKnowledge.contains(expressionTree)) {
            return ExpressionTrees.getTrue();
        }
        if (expressionTree instanceof LeafExpression && pExternalKnowledge.contains(negated = ((LeafExpression)expressionTree).negate())) {
            return ExpressionTrees.getFalse();
        }
        ExpressionTreeVisitor<LeafType, ExpressionTree<LeafType>, NoException> visitor = pVisitorCache.get(pExternalKnowledge);
        if (visitor == null) {
            visitor = new SimplificationVisitor<LeafType>(pExternalKnowledge, pFactory, pVisitorCache, pThorough);
            pVisitorCache.put(pExternalKnowledge, visitor);
        }
        return expressionTree.accept(visitor);
    }

    public static <S, T> ExpressionTree<T> convert(ExpressionTree<S> pSource, final Function<? super S, ? extends T> pLeafConverter) {
        final Function convert = pTree -> ExpressionTrees.convert(pTree, pLeafConverter);
        CachingVisitor converter = new CachingVisitor<S, ExpressionTree<T>, NoException>(){

            @Override
            public ExpressionTree<T> cacheMissAnd(And<S> pAnd) {
                return And.of(FluentIterable.from(pAnd).transform(convert));
            }

            @Override
            public ExpressionTree<T> cacheMissOr(Or<S> pOr) {
                return Or.of(FluentIterable.from(pOr).transform(convert));
            }

            @Override
            public ExpressionTree<T> cacheMissLeaf(LeafExpression<S> pLeafExpression) {
                return LeafExpression.of(Preconditions.checkNotNull((Object)pLeafConverter.apply(pLeafExpression.getExpression())), pLeafExpression.assumeTruth());
            }

            @Override
            public ExpressionTree<T> cacheMissTrue() {
                return ExpressionTrees.getTrue();
            }

            @Override
            public ExpressionTree<T> cacheMissFalse() {
                return ExpressionTrees.getFalse();
            }

            @Override
            public ExpressionTree<T> visitTrue() {
                return ExpressionTrees.getTrue();
            }

            @Override
            public ExpressionTree<T> visitFalse() {
                return ExpressionTrees.getFalse();
            }
        };
        return (ExpressionTree)pSource.accept(converter);
    }

    public static ExpressionTree<Object> fromFormula(BooleanFormula formula, FormulaManagerView fMgr, CFANode location) throws InterruptedException {
        FormulaToCVisitor v;
        BooleanFormula inv = formula;
        String prefix = location.getFunctionName() + FUNCTION_DELIMITER;
        boolean isValid = fMgr.visit((Formula)(inv = fMgr.filterLiterals(inv, (Predicate<BooleanFormula>)((Predicate)e -> {
            for (String name : fMgr.extractVariableNames((Formula)e)) {
                if (!name.contains(FUNCTION_DELIMITER) || name.startsWith(prefix)) continue;
                return false;
            }
            return true;
        }))), v = new FormulaToCVisitor(fMgr));
        if (isValid) {
            return LeafExpression.of(v.getString());
        }
        return ExpressionTrees.getTrue();
    }

    public static <LeafTypeS extends LeafTypeT, LeafTypeT> ExpressionTree<LeafTypeT> cast(ExpressionTree<LeafTypeS> pToCast) {
        return pToCast;
    }

    public static <LeafType> ExpressionTreeFactory<LeafType> newFactory() {
        return new CachingExpressionTreeFactory();
    }

    public static <LeafType> Comparator<ExpressionTree<LeafType>> getComparator() {
        return new ExpressionTreeComparator();
    }

    private static class SimplificationVisitor<LeafType>
    extends CachingVisitor<LeafType, ExpressionTree<LeafType>, NoException> {
        private final Set<ExpressionTree<LeafType>> externalKnowledge;
        private final ExpressionTreeFactory<LeafType> factory;
        private final Map<Set<ExpressionTree<LeafType>>, ExpressionTreeVisitor<LeafType, ExpressionTree<LeafType>, NoException>> visitorCache;
        private final boolean thorough;

        private SimplificationVisitor(Set<ExpressionTree<LeafType>> pExternalKnowledge, ExpressionTreeFactory<LeafType> pFactory, Map<Set<ExpressionTree<LeafType>>, ExpressionTreeVisitor<LeafType, ExpressionTree<LeafType>, NoException>> pVisitorCache, boolean pThorough) {
            this.externalKnowledge = pExternalKnowledge;
            this.factory = pFactory;
            this.visitorCache = pVisitorCache;
            this.thorough = pThorough;
        }

        @Override
        public ExpressionTree<LeafType> cacheMissAnd(And<LeafType> pAnd) {
            LinkedList operands = Lists.newLinkedList(pAnd);
            boolean changedGlobally = false;
            boolean changed = false;
            Set<ExpressionTree<LeafType>> knowledgeBase = this.externalKnowledge;
            do {
                changed = false;
                ListIterator<ExpressionTree<LeafType>> operandIt = operands.listIterator();
                block1: while (operandIt.hasNext()) {
                    ExpressionTree<LeafType> current = (ExpressionTree<LeafType>)operandIt.next();
                    ExpressionTree<LeafType> simplifiedCurrent = ExpressionTrees.simplify(current, knowledgeBase, this.visitorCache, this.factory, this.thorough);
                    if (!simplifiedCurrent.equals(current)) {
                        if (ExpressionTrees.getFalse().equals(simplifiedCurrent)) {
                            return simplifiedCurrent;
                        }
                        changed = true;
                        operandIt.remove();
                        if (ExpressionTrees.getTrue().equals(simplifiedCurrent)) continue;
                        operandIt.add(simplifiedCurrent);
                        current = simplifiedCurrent;
                    }
                    for (ExpressionTree other : operands) {
                        boolean newFact;
                        if (other == current || !(newFact = !knowledgeBase.contains(other))) continue;
                        simplifiedCurrent = current instanceof LeafExpression && other instanceof LeafExpression ? (current.equals(other) ? ExpressionTrees.getTrue() : current) : ExpressionTrees.simplify(current, Collections.singleton(other), this.visitorCache, this.factory, false);
                        if (simplifiedCurrent.equals(current)) continue;
                        if (ExpressionTrees.getFalse().equals(simplifiedCurrent)) {
                            return simplifiedCurrent;
                        }
                        changed = true;
                        ExpressionTree prev = (ExpressionTree)operandIt.previous();
                        assert (prev == current);
                        operandIt.remove();
                        if (ExpressionTrees.getTrue().equals(simplifiedCurrent)) continue block1;
                        operandIt.add(simplifiedCurrent);
                        continue block1;
                    }
                }
                changedGlobally |= changed;
            } while (changed);
            if (!changedGlobally) {
                return pAnd;
            }
            return this.factory.and(operands);
        }

        @Override
        public ExpressionTree<LeafType> cacheMissOr(Or<LeafType> pOr) {
            Iterator<ExpressionTree<LeafType>> opIt = pOr.iterator();
            if (opIt.hasNext()) {
                int nOperands = 1;
                HashSet commonFacts = Sets.newHashSet(this.asFacts(opIt.next()));
                if (opIt.hasNext()) {
                    while (!commonFacts.isEmpty() && opIt.hasNext()) {
                        Iterable<ExpressionTree<LeafType>> facts = this.asFacts(opIt.next());
                        commonFacts.retainAll(facts instanceof Collection ? (Collection)facts : Lists.newArrayList(facts));
                        ++nOperands;
                    }
                    if (!commonFacts.isEmpty()) {
                        ExpressionTree commonFactsTree = And.of(commonFacts);
                        commonFacts.addAll(this.externalKnowledge);
                        ArrayList simplifiedOperands = new ArrayList(nOperands);
                        ArrayList operands = new ArrayList(nOperands);
                        for (ExpressionTree<LeafType> operand : pOr) {
                            ExpressionTree<LeafType> simplified = ExpressionTrees.simplify(operand, commonFacts, this.visitorCache, this.factory, this.thorough);
                            if (!simplified.equals(ExpressionTrees.getFalse())) {
                                operands.add(operand);
                            }
                            simplifiedOperands.add(simplified);
                        }
                        if (operands.size() < simplifiedOperands.size()) {
                            return ExpressionTrees.simplify(this.factory.or(operands), this.externalKnowledge, this.visitorCache, this.factory, this.thorough);
                        }
                        return this.factory.and(ExpressionTrees.simplify(commonFactsTree, this.externalKnowledge, this.visitorCache, this.factory, this.thorough), this.factory.or(simplifiedOperands));
                    }
                }
            }
            ArrayList operands = new ArrayList();
            HashSet<ExpressionTree<LeafType>> changedOps = new HashSet<ExpressionTree<LeafType>>();
            boolean changed = false;
            for (ExpressionTree<LeafType> operandToAdd : pOr) {
                ExpressionTree<LeafType> simplified = ExpressionTrees.simplify(operandToAdd, this.externalKnowledge, this.visitorCache, this.factory, this.thorough);
                if (ExpressionTrees.getTrue().equals(simplified)) {
                    return simplified;
                }
                if (!ExpressionTrees.getFalse().equals(simplified)) {
                    operands.add(simplified);
                }
                if (simplified == operandToAdd) continue;
                changed = true;
                if (this.thorough) continue;
                if (changedOps.isEmpty()) {
                    changedOps = new HashSet();
                }
                changedOps.add(simplified);
            }
            if (changed || this.thorough) {
                Iterator operandIt = operands.iterator();
                while (operandIt.hasNext()) {
                    ArrayList relevantInnerOperands;
                    ExpressionTree operand = (ExpressionTree)operandIt.next();
                    AbstractCollection abstractCollection = relevantInnerOperands = this.thorough || changedOps.contains(operand) ? operands : changedOps;
                    if (operand instanceof LeafExpression && this.isImplied(operand, relevantInnerOperands, true)) {
                        return ExpressionTrees.getTrue();
                    }
                    if (!this.isImplied(operand, relevantInnerOperands, false)) continue;
                    changed = true;
                    operandIt.remove();
                }
            }
            if (!changed) {
                return pOr;
            }
            return this.factory.or(operands);
        }

        private boolean isImplied(ExpressionTree<LeafType> originalOperand, Iterable<ExpressionTree<LeafType>> relevantInnerOperands, boolean negate) {
            ExpressionTree<LeafType> operandForCheck = originalOperand;
            if (negate) {
                operandForCheck = ((LeafExpression)originalOperand).negate();
            }
            if (!this.externalKnowledge.contains(operandForCheck)) {
                for (ExpressionTree<LeafType> op : relevantInnerOperands) {
                    if (op == originalOperand || !ExpressionTrees.getTrue().equals(ExpressionTrees.simplify(op, Collections.singleton(operandForCheck), this.visitorCache, this.factory, false))) continue;
                    return true;
                }
            }
            return false;
        }

        private Iterable<ExpressionTree<LeafType>> asFacts(ExpressionTree<LeafType> pExprTree) {
            if (ExpressionTrees.isAnd(pExprTree)) {
                return ExpressionTrees.getChildren(pExprTree);
            }
            return Collections.singleton(pExprTree);
        }

        @Override
        public ExpressionTree<LeafType> cacheMissLeaf(LeafExpression<LeafType> pLeafExpression) {
            return pLeafExpression;
        }

        @Override
        public ExpressionTree<LeafType> cacheMissTrue() {
            return ExpressionTrees.getTrue();
        }

        @Override
        public ExpressionTree<LeafType> cacheMissFalse() {
            return ExpressionTrees.getFalse();
        }
    }

    private static class ExpressionTreeComparator<LeafType>
    implements Comparator<ExpressionTree<LeafType>>,
    Serializable {
        private static final long serialVersionUID = -8004131077972723263L;
        private final Comparator<Iterable<ExpressionTree<LeafType>>> lexicographicalOrdering = Comparators.lexicographical((Comparator)this);

        private ExpressionTreeComparator() {
        }

        @Override
        public int compare(ExpressionTree<LeafType> pO1, final ExpressionTree<LeafType> pO2) {
            int typeOrder1 = pO1.accept(TYPE_ORDER_VISITOR);
            int typeOrder2 = pO2.accept(TYPE_ORDER_VISITOR);
            final int typeOrderComp = Integer.compare(typeOrder1, typeOrder2);
            return (Integer)pO1.accept(new CachingVisitor<LeafType, Integer, NoException>(){

                @Override
                protected Integer cacheMissAnd(And<LeafType> pAnd) {
                    if (pO2 instanceof And) {
                        And other = (And)pO2;
                        return lexicographicalOrdering.compare(pAnd, other);
                    }
                    return typeOrderComp;
                }

                @Override
                protected Integer cacheMissOr(Or<LeafType> pOr) {
                    if (pO2 instanceof Or) {
                        Or other = (Or)pO2;
                        return lexicographicalOrdering.compare(pOr, other);
                    }
                    return typeOrderComp;
                }

                @Override
                protected Integer cacheMissLeaf(LeafExpression<LeafType> pLeafExpression) {
                    if (pO2 instanceof LeafExpression) {
                        LeafExpression other = (LeafExpression)pO2;
                        Object o1 = pLeafExpression.getExpression();
                        Object o2 = other.getExpression();
                        int leafComp = Ordering.usingToString().compare(o1, o2);
                        if (leafComp != 0) {
                            return leafComp;
                        }
                        return Boolean.compare(pLeafExpression.assumeTruth(), other.assumeTruth());
                    }
                    return typeOrderComp;
                }

                @Override
                public Integer cacheMissTrue() {
                    if (pO2.equals(ExpressionTrees.getTrue())) {
                        return 0;
                    }
                    return typeOrderComp;
                }

                @Override
                public Integer cacheMissFalse() {
                    if (pO2.equals(ExpressionTrees.getFalse())) {
                        return 0;
                    }
                    return typeOrderComp;
                }
            });
        }
    }
}

