/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import com.google.common.truth.Truth;
import org.junit.Test;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.types.c.CNumericTypes;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.test.TestDataTools;

public class ExpressionTreesTest {
    private static final ExpressionTree<AExpression> LITERAL_A = LeafExpression.of(TestDataTools.makeVariable("a", CNumericTypes.INT));
    private static final ExpressionTree<AExpression> LITERAL_NOT_A = LeafExpression.of(TestDataTools.makeVariable("a", CNumericTypes.INT), false);
    private static final ExpressionTree<AExpression> LITERAL_B = LeafExpression.of(TestDataTools.makeVariable("b", CNumericTypes.INT));
    private static final ExpressionTree<AExpression> LITERAL_C = LeafExpression.of(TestDataTools.makeVariable("c", CNumericTypes.INT));
    private static final ExpressionTree<AExpression> COMPLEX_CNF = And.of(Or.of(LITERAL_A, LITERAL_B), Or.of(LITERAL_C, LITERAL_NOT_A));
    private static final ExpressionTree<AExpression> COMPLEX_DNF = Or.of(And.of(LITERAL_A, LITERAL_B), And.of(LITERAL_C, LITERAL_NOT_A));

    @Test
    public void testIsConstant() {
        Truth.assertThat((Boolean)ExpressionTrees.isConstant(ExpressionTrees.getTrue())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isConstant(ExpressionTrees.getFalse())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isConstant(LITERAL_A)).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isConstant(LITERAL_NOT_A)).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isConstant(And.of(LITERAL_B, LITERAL_C))).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isConstant(Or.of(LITERAL_B, LITERAL_C))).isFalse();
    }

    @Test
    public void testIsLeaf() {
        Truth.assertThat((Boolean)ExpressionTrees.isLeaf(ExpressionTrees.getTrue())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isLeaf(ExpressionTrees.getFalse())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isLeaf(LITERAL_A)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isLeaf(LITERAL_NOT_A)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isLeaf(And.of(LITERAL_B, LITERAL_C))).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isLeaf(Or.of(LITERAL_B, LITERAL_C))).isFalse();
    }

    @Test
    public void testIsOr() {
        Truth.assertThat((Boolean)ExpressionTrees.isOr(ExpressionTrees.getTrue())).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isOr(ExpressionTrees.getFalse())).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isOr(LITERAL_A)).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isOr(LITERAL_NOT_A)).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isOr(And.of(LITERAL_B, LITERAL_C))).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isOr(Or.of(LITERAL_B, LITERAL_C))).isTrue();
    }

    @Test
    public void testIsAnd() {
        Truth.assertThat((Boolean)ExpressionTrees.isAnd(ExpressionTrees.getTrue())).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isAnd(ExpressionTrees.getFalse())).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isAnd(LITERAL_A)).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isAnd(LITERAL_NOT_A)).isFalse();
        Truth.assertThat((Boolean)ExpressionTrees.isAnd(And.of(LITERAL_B, LITERAL_C))).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isAnd(Or.of(LITERAL_B, LITERAL_C))).isFalse();
    }

    @Test
    public void testIsInCNF() {
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(ExpressionTrees.getTrue())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(ExpressionTrees.getFalse())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(LITERAL_A)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(LITERAL_NOT_A)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(And.of(LITERAL_B, LITERAL_C))).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(Or.of(LITERAL_B, LITERAL_C))).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(COMPLEX_CNF)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(COMPLEX_DNF)).isFalse();
    }

    @Test
    public void testIsInDNF() {
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(ExpressionTrees.getTrue())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(ExpressionTrees.getFalse())).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(LITERAL_A)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(LITERAL_NOT_A)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(And.of(LITERAL_B, LITERAL_C))).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(Or.of(LITERAL_B, LITERAL_C))).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(COMPLEX_DNF)).isTrue();
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(COMPLEX_CNF)).isFalse();
    }

    @Test
    public void testToDNF() {
        Truth.assertThat(ExpressionTrees.toDNF(ExpressionTrees.getTrue())).isEqualTo(ExpressionTrees.getTrue());
        Truth.assertThat(ExpressionTrees.toDNF(ExpressionTrees.getFalse())).isEqualTo(ExpressionTrees.getFalse());
        Truth.assertThat(ExpressionTrees.toDNF(LITERAL_A)).isEqualTo(LITERAL_A);
        Truth.assertThat(ExpressionTrees.toDNF(LITERAL_NOT_A)).isEqualTo(LITERAL_NOT_A);
        Truth.assertThat(ExpressionTrees.toDNF(And.of(LITERAL_B, LITERAL_C))).isEqualTo(And.of(LITERAL_B, LITERAL_C));
        Truth.assertThat(ExpressionTrees.toDNF(Or.of(LITERAL_B, LITERAL_C))).isEqualTo(Or.of(LITERAL_B, LITERAL_C));
        Truth.assertThat(ExpressionTrees.toDNF(COMPLEX_DNF)).isEqualTo(COMPLEX_DNF);
        Truth.assertThat((Boolean)ExpressionTrees.isInDNF(ExpressionTrees.toDNF(COMPLEX_CNF))).isTrue();
    }

    @Test
    public void testToCNF() {
        Truth.assertThat(ExpressionTrees.toDNF(ExpressionTrees.getTrue())).isEqualTo(ExpressionTrees.getTrue());
        Truth.assertThat(ExpressionTrees.toDNF(ExpressionTrees.getFalse())).isEqualTo(ExpressionTrees.getFalse());
        Truth.assertThat(ExpressionTrees.toDNF(LITERAL_A)).isEqualTo(LITERAL_A);
        Truth.assertThat(ExpressionTrees.toDNF(LITERAL_NOT_A)).isEqualTo(LITERAL_NOT_A);
        Truth.assertThat(ExpressionTrees.toDNF(And.of(LITERAL_B, LITERAL_C))).isEqualTo(And.of(LITERAL_B, LITERAL_C));
        Truth.assertThat(ExpressionTrees.toDNF(Or.of(LITERAL_B, LITERAL_C))).isEqualTo(Or.of(LITERAL_B, LITERAL_C));
        Truth.assertThat(ExpressionTrees.toCNF(COMPLEX_CNF)).isEqualTo(COMPLEX_CNF);
        Truth.assertThat((Boolean)ExpressionTrees.isInCNF(ExpressionTrees.toCNF(COMPLEX_DNF))).isTrue();
    }
}

