/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import java.math.BigInteger;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.AExpressionStatement;
import org.sosy_lab.cpachecker.cfa.ast.AIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.ast.AStatement;
import org.sosy_lab.cpachecker.cfa.ast.c.CAssignment;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.util.expressions.AbstractExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTrees;

public class LeafExpression<LeafType>
extends AbstractExpressionTree<LeafType> {
    private final LeafType expression;
    private final boolean assumeTruth;
    private final int hashCode;

    public static ExpressionTree<AExpression> fromStatement(AStatement pStatement, CBinaryExpressionBuilder pBinaryExpressionBuilder) {
        CAssignment assignment;
        if (pStatement instanceof AExpressionStatement) {
            return LeafExpression.of(((AExpressionStatement)pStatement).getExpression());
        }
        if (pStatement instanceof CAssignment && (assignment = (CAssignment)pStatement).getRightHandSide() instanceof CExpression) {
            CExpression expression = (CExpression)assignment.getRightHandSide();
            CBinaryExpression assumeExp = pBinaryExpressionBuilder.buildBinaryExpressionUnchecked(assignment.getLeftHandSide(), expression, CBinaryExpression.BinaryOperator.EQUALS);
            return LeafExpression.of(assumeExp);
        }
        return ExpressionTrees.getTrue();
    }

    private LeafExpression(LeafType pExpression, boolean pAssumeTruth, int pHashCode) {
        this.expression = Objects.requireNonNull(pExpression);
        this.assumeTruth = pAssumeTruth;
        this.hashCode = pHashCode;
    }

    public LeafType getExpression() {
        return this.expression;
    }

    public boolean assumeTruth() {
        return this.assumeTruth;
    }

    @Override
    public <T, E extends Throwable> T accept(ExpressionTreeVisitor<LeafType, T, E> pVisitor) throws E {
        return pVisitor.visit(this);
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object pObj) {
        if (this == pObj) {
            return true;
        }
        if (pObj instanceof LeafExpression) {
            LeafExpression other = (LeafExpression)pObj;
            return this.assumeTruth == other.assumeTruth && this.expression.equals(other.expression);
        }
        return false;
    }

    public LeafExpression<LeafType> negate() {
        return new LeafExpression<LeafType>(this.expression, !this.assumeTruth, -this.hashCode);
    }

    public static <LeafType> ExpressionTree<LeafType> of(LeafType pLeafExpression) {
        return LeafExpression.of(pLeafExpression, true);
    }

    public static <LeafType> ExpressionTree<LeafType> of(LeafType pLeafExpression, boolean pAssumeTruth) {
        CBinaryExpression binaryExpression;
        Object leafExpression = pLeafExpression;
        boolean assumeTruth = pAssumeTruth;
        if (leafExpression instanceof CBinaryExpression && (binaryExpression = (CBinaryExpression)pLeafExpression).getOperator() == CBinaryExpression.BinaryOperator.NOT_EQUALS) {
            assumeTruth = !assumeTruth;
            leafExpression = new CBinaryExpression(binaryExpression.getFileLocation(), binaryExpression.getExpressionType(), binaryExpression.getCalculationType(), binaryExpression.getOperand1(), binaryExpression.getOperand2(), CBinaryExpression.BinaryOperator.EQUALS);
        }
        if (leafExpression instanceof AIntegerLiteralExpression) {
            AIntegerLiteralExpression expression = (AIntegerLiteralExpression)pLeafExpression;
            if (expression.getValue().equals(BigInteger.ZERO)) {
                return assumeTruth ? ExpressionTrees.getFalse() : ExpressionTrees.getTrue();
            }
            return assumeTruth ? ExpressionTrees.getTrue() : ExpressionTrees.getFalse();
        }
        if (leafExpression instanceof String) {
            String expressionString = (String)leafExpression;
            if (expressionString.equals("0")) {
                return assumeTruth ? ExpressionTrees.getFalse() : ExpressionTrees.getTrue();
            }
            if (expressionString.equals("1")) {
                return assumeTruth ? ExpressionTrees.getTrue() : ExpressionTrees.getFalse();
            }
        }
        return new LeafExpression<LeafType>(leafExpression, assumeTruth, assumeTruth ? leafExpression.hashCode() : -leafExpression.hashCode());
    }
}

