/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CBinaryExpressionBuilder;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.c.CIntegerLiteralExpression;
import org.sosy_lab.cpachecker.cfa.types.MachineModel;
import org.sosy_lab.cpachecker.exceptions.UnrecognizedCodeException;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.CachingVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;

public class ToCExpressionVisitor
extends CachingVisitor<AExpression, CExpression, UnrecognizedCodeException> {
    private final CBinaryExpressionBuilder builder;

    public ToCExpressionVisitor(MachineModel model, LogManager logger) {
        this.builder = new CBinaryExpressionBuilder(model, logger);
    }

    @Override
    protected CExpression cacheMissAnd(And<AExpression> pAnd) throws UnrecognizedCodeException {
        ArrayList<CExpression> elements = new ArrayList<CExpression>();
        for (ExpressionTree<AExpression> expressionTree : pAnd) {
            elements.add(expressionTree.accept(this));
        }
        CExpression result = (CExpression)elements.get(0);
        for (CExpression expr : Iterables.skip(elements, (int)1)) {
            result = this.builder.buildBinaryExpression(result, expr, CBinaryExpression.BinaryOperator.BINARY_AND);
        }
        return result;
    }

    @Override
    protected CExpression cacheMissOr(Or<AExpression> pOr) throws UnrecognizedCodeException {
        ArrayList<CExpression> elements = new ArrayList<CExpression>();
        for (ExpressionTree<AExpression> expressionTree : pOr) {
            elements.add(expressionTree.accept(this));
        }
        CExpression result = (CExpression)elements.get(0);
        for (CExpression expr : Iterables.skip(elements, (int)1)) {
            result = this.builder.buildBinaryExpression(result, expr, CBinaryExpression.BinaryOperator.BINARY_OR);
        }
        return result;
    }

    @Override
    protected CExpression cacheMissLeaf(LeafExpression<AExpression> pLeafExpression) throws UnrecognizedCodeException {
        if (pLeafExpression.getExpression() instanceof CExpression) {
            return (CExpression)pLeafExpression.getExpression();
        }
        throw new AssertionError((Object)"Unsupported expression type.");
    }

    @Override
    protected CExpression cacheMissTrue() throws UnrecognizedCodeException {
        return CIntegerLiteralExpression.ONE;
    }

    @Override
    protected CExpression cacheMissFalse() throws UnrecognizedCodeException {
        return CIntegerLiteralExpression.ZERO;
    }
}

