/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.FluentIterable;
import org.sosy_lab.cpachecker.exceptions.NoException;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.CachingVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTreeVisitor;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;

public class ToCodeVisitor<LeafType>
extends CachingVisitor<LeafType, String, NoException> {
    private final Function<? super LeafType, String> leafExpressionToCodeFunction;

    private static String wrapInParentheses(String pCode) {
        return "(" + pCode + ")";
    }

    public ToCodeVisitor(Function<? super LeafType, String> pLeafExpressionToCodeFunction) {
        this.leafExpressionToCodeFunction = pLeafExpressionToCodeFunction;
    }

    private String toParenthesizedCode(ExpressionTree<LeafType> pExpressionTree) {
        return (String)pExpressionTree.accept(new ExpressionTreeVisitor<LeafType, String, NoException>(){

            @Override
            public String visit(And<LeafType> pAnd) {
                return ToCodeVisitor.wrapInParentheses((String)pAnd.accept(ToCodeVisitor.this));
            }

            @Override
            public String visit(Or<LeafType> pOr) {
                return ToCodeVisitor.wrapInParentheses((String)pOr.accept(ToCodeVisitor.this));
            }

            @Override
            public String visit(LeafExpression<LeafType> pLeafExpression) {
                return (String)pLeafExpression.accept(ToCodeVisitor.this);
            }

            @Override
            public String visitTrue() {
                return (String)ToCodeVisitor.this.visitTrue();
            }

            @Override
            public String visitFalse() {
                return (String)ToCodeVisitor.this.visitFalse();
            }
        });
    }

    @Override
    protected String cacheMissAnd(And<LeafType> pAnd) {
        assert (pAnd.iterator().hasNext());
        return FluentIterable.from(pAnd).transform(this::toParenthesizedCode).join(Joiner.on((String)" && "));
    }

    @Override
    protected String cacheMissOr(Or<LeafType> pOr) {
        assert (pOr.iterator().hasNext());
        return FluentIterable.from(pOr).transform(this::toParenthesizedCode).join(Joiner.on((String)" || "));
    }

    @Override
    protected String cacheMissLeaf(LeafExpression<LeafType> pLeafExpression) {
        LeafType expression = pLeafExpression.getExpression();
        String expressionCode = (String)this.leafExpressionToCodeFunction.apply(expression);
        if (pLeafExpression.assumeTruth()) {
            return expressionCode;
        }
        expressionCode = ToCodeVisitor.wrapInParentheses(expressionCode);
        return "!" + expressionCode;
    }

    @Override
    protected String cacheMissTrue() {
        return "1";
    }

    @Override
    protected String cacheMissFalse() {
        return "0";
    }
}

