/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.expressions;

import java.util.ArrayList;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.ast.AExpression;
import org.sosy_lab.cpachecker.cfa.ast.FileLocation;
import org.sosy_lab.cpachecker.cfa.ast.c.CExpression;
import org.sosy_lab.cpachecker.cfa.ast.java.JExpression;
import org.sosy_lab.cpachecker.cfa.model.AssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cfa.model.c.CAssumeEdge;
import org.sosy_lab.cpachecker.cfa.model.java.JAssumeEdge;
import org.sosy_lab.cpachecker.exceptions.CPATransferException;
import org.sosy_lab.cpachecker.util.expressions.And;
import org.sosy_lab.cpachecker.util.expressions.CachingVisitor;
import org.sosy_lab.cpachecker.util.expressions.ExpressionTree;
import org.sosy_lab.cpachecker.util.expressions.LeafExpression;
import org.sosy_lab.cpachecker.util.expressions.Or;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormula;
import org.sosy_lab.cpachecker.util.predicates.pathformula.PathFormulaManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;
import org.sosy_lab.java_smt.api.BooleanFormula;

public class ToFormulaVisitor
extends CachingVisitor<AExpression, BooleanFormula, ToFormulaException> {
    private final FormulaManagerView formulaManagerView;
    private final PathFormulaManager pathFormulaManager;
    private final PathFormula context;

    public ToFormulaVisitor(FormulaManagerView pFormulaManagerView, PathFormulaManager pPathFormulaManager, PathFormula pClearContext) {
        this.formulaManagerView = Objects.requireNonNull(pFormulaManagerView);
        this.pathFormulaManager = Objects.requireNonNull(pPathFormulaManager);
        this.context = pClearContext;
    }

    @Override
    protected BooleanFormula cacheMissAnd(And<AExpression> pAnd) throws ToFormulaException {
        ArrayList<BooleanFormula> elements = new ArrayList<BooleanFormula>();
        for (ExpressionTree<AExpression> expressionTree : pAnd) {
            elements.add(expressionTree.accept(this));
        }
        return this.formulaManagerView.getBooleanFormulaManager().and(elements);
    }

    @Override
    protected BooleanFormula cacheMissOr(Or<AExpression> pOr) throws ToFormulaException {
        ArrayList<BooleanFormula> elements = new ArrayList<BooleanFormula>();
        for (ExpressionTree<AExpression> expressionTree : pOr) {
            elements.add(expressionTree.accept(this));
        }
        return this.formulaManagerView.getBooleanFormulaManager().or(elements);
    }

    @Override
    protected BooleanFormula cacheMissLeaf(LeafExpression<AExpression> pLeafExpression) throws ToFormulaException {
        PathFormula invariantPathFormula;
        AssumeEdge edge;
        AExpression expression = pLeafExpression.getExpression();
        if (expression instanceof CExpression) {
            edge = new CAssumeEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), (CExpression)expression, pLeafExpression.assumeTruth());
        } else if (expression instanceof JExpression) {
            edge = new JAssumeEdge("", FileLocation.DUMMY, CFANode.newDummyCFANode(), CFANode.newDummyCFANode(), (JExpression)expression, pLeafExpression.assumeTruth());
        } else {
            throw new AssertionError((Object)"Unsupported expression type.");
        }
        PathFormula clearContext = this.context == null ? this.pathFormulaManager.makeEmptyPathFormula() : this.pathFormulaManager.makeEmptyPathFormulaWithContextFrom(this.context);
        try {
            invariantPathFormula = this.pathFormulaManager.makeAnd(clearContext, edge);
        }
        catch (InterruptedException | CPATransferException e) {
            throw new ToFormulaException(e);
        }
        return this.formulaManagerView.uninstantiate(invariantPathFormula.getFormula());
    }

    @Override
    protected BooleanFormula cacheMissTrue() {
        return this.formulaManagerView.getBooleanFormulaManager().makeTrue();
    }

    @Override
    protected BooleanFormula cacheMissFalse() {
        return this.formulaManagerView.getBooleanFormulaManager().makeFalse();
    }

    public static class ToFormulaException
    extends Exception {
        private static final long serialVersionUID = -3849941975554955994L;

        private ToFormulaException(Exception pCause) {
            super(pCause);
        }
    }
}

