/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization;

import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;

public class Fault
extends ForwardingSet<FaultContribution>
implements Comparable<Fault> {
    private final Set<FaultContribution> errorSet;
    private final List<FaultInfo> infos;
    private int intendedIndex;
    private double score;

    public Fault(Collection<FaultContribution> pErrorSet) {
        this(pErrorSet, 0.0);
    }

    public Fault() {
        this(new LinkedHashSet<FaultContribution>(), 0.0);
    }

    public Fault(FaultContribution singleton) {
        this(Collections.singleton(singleton), 0.0);
    }

    public Fault(FaultContribution pContribs, double pScore) {
        this(Collections.singleton(pContribs), pScore);
    }

    public Fault(Collection<FaultContribution> pContribs, double pScore) {
        this.errorSet = new LinkedHashSet<FaultContribution>(pContribs);
        this.infos = new ArrayList<FaultInfo>();
        this.score = pScore;
    }

    public void addInfo(FaultInfo reason) {
        this.infos.add(reason);
    }

    public List<FaultInfo> getInfos() {
        return this.infos;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double pScore) {
        this.score = pScore;
    }

    public String toString() {
        ImmutableList copy = ImmutableList.sortedCopyOf(this.infos);
        StringBuilder out = new StringBuilder("Error suspected on line(s): " + this.listDistinctLinesAndJoin() + ".\n");
        for (FaultInfo faultInfo : copy) {
            switch (faultInfo.getType()) {
                case RANK_INFO: {
                    out.append(" ".repeat(2));
                    break;
                }
                case REASON: {
                    out.append(" ".repeat(5));
                    break;
                }
                case FIX: {
                    out.append(" ".repeat(8));
                }
            }
            out.append(faultInfo).append("\n");
        }
        return out.toString();
    }

    private String listDistinctLinesAndJoin() {
        String result;
        List lines = (List)this.errorSet.stream().mapToInt(l -> l.correspondingEdge().getFileLocation().getStartingLineInOrigin()).sorted().distinct().mapToObj(String::valueOf).collect(ImmutableList.toImmutableList());
        if (lines.size() <= 2) {
            result = String.join((CharSequence)" and ", lines);
        } else {
            int lastIndex = lines.size() - 1;
            result = String.join((CharSequence)", ", lines.subList(0, lastIndex) + " and " + (String)lines.get(lastIndex));
        }
        return result + " (Score: " + (int)(this.score * 100.0) + ")";
    }

    public void setIntendedIndex(int pIntendedIndex) {
        this.intendedIndex = pIntendedIndex;
    }

    public int getIntendedIndex() {
        return this.intendedIndex;
    }

    public boolean equals(Object q) {
        if (!(q instanceof Fault)) {
            return false;
        }
        Fault comp = (Fault)q;
        return this.errorSet.equals(comp.errorSet) && this.infos.equals(comp.infos);
    }

    public int hashCode() {
        return Objects.hash(this.errorSet, this.infos);
    }

    protected Set<FaultContribution> delegate() {
        return this.errorSet;
    }

    @Override
    public int compareTo(Fault o) {
        return Double.compare(o.score, this.score);
    }

    public void replaceErrorSet(Set<FaultContribution> pContributions) {
        this.errorSet.clear();
        this.errorSet.addAll(pContributions);
    }

    public static Fault merge(Fault f1, Fault f2) {
        LinkedHashSet<FaultContribution> contributions = new LinkedHashSet<FaultContribution>((Collection<FaultContribution>)((Object)f1));
        contributions.addAll((Collection<FaultContribution>)((Object)f2));
        ArrayList<FaultInfo> infos = new ArrayList<FaultInfo>(f1.infos);
        infos.addAll(f2.infos);
        Fault newFault = new Fault(contributions);
        infos.forEach(newFault::addInfo);
        newFault.intendedIndex = Integer.min(f1.intendedIndex, f2.intendedIndex);
        return newFault;
    }
}

