/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;

public class FaultContribution {
    protected final List<FaultInfo> infos = new ArrayList<FaultInfo>();
    private final CFAEdge correspondingEdge;
    private double score;

    public FaultContribution(CFAEdge pCorrespondingEdge) {
        this.correspondingEdge = pCorrespondingEdge;
        this.score = 0.0;
    }

    public double getScore() {
        return this.score;
    }

    public void setScore(double pScore) {
        this.score = pScore;
    }

    public void addInfo(FaultInfo pFaultInfo) {
        this.infos.add(pFaultInfo);
    }

    public List<FaultInfo> getInfos() {
        return this.infos;
    }

    public String toString() {
        ImmutableList copy = ImmutableList.sortedCopyOf(this.infos);
        StringBuilder out = new StringBuilder("Error suspected on line " + this.correspondingEdge().getFileLocation().getStartingLineInOrigin() + ".\n");
        for (FaultInfo faultInfo : copy) {
            switch (faultInfo.getType()) {
                case RANK_INFO: {
                    out.append(" ".repeat(2));
                    break;
                }
                case REASON: {
                    out.append(" ".repeat(5));
                    break;
                }
                case FIX: {
                    out.append(" ".repeat(8));
                }
            }
            out.append(faultInfo).append("\n");
        }
        return out.toString();
    }

    public boolean hasReasons() {
        return !this.infos.isEmpty();
    }

    public CFAEdge correspondingEdge() {
        return this.correspondingEdge;
    }

    public boolean equals(Object q) {
        FaultContribution casted;
        if (q instanceof FaultContribution && this.correspondingEdge.equals((casted = (FaultContribution)q).correspondingEdge()) && casted.getInfos().size() == this.getInfos().size()) {
            return ImmutableList.sortedCopyOf(this.infos).equals((Object)ImmutableList.sortedCopyOf(casted.infos));
        }
        return false;
    }

    public int hashCode() {
        int result = 5;
        result = Objects.hash(this.correspondingEdge, result);
        return result;
    }
}

