/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.sosy_lab.common.JSON;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.core.counterexample.CFAPathWithAdditionalInfo;
import org.sosy_lab.cpachecker.core.counterexample.CounterexampleInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultRankingUtils;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultReportWriter;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;

public class FaultLocalizationInfo
extends CounterexampleInfo {
    private final ImmutableList<Fault> rankedList;
    private FaultReportWriter htmlWriter;
    private Multimap<CFAEdge, Integer> mapEdgeToRankedFaultIndex;
    private Map<CFAEdge, FaultContribution> mapEdgeToFaultContribution;

    public FaultLocalizationInfo(List<Fault> pFaults, CounterexampleInfo pParent) {
        super(pParent.isSpurious(), pParent.getTargetPath(), pParent.getCFAPathWithAssignments(), pParent.isPreciseCounterExample(), CFAPathWithAdditionalInfo.empty());
        this.rankedList = ImmutableList.copyOf(pFaults);
        this.htmlWriter = new FaultReportWriter();
    }

    public FaultLocalizationInfo(Set<Fault> pFaults, FaultScoring pRanking, CounterexampleInfo pParent) {
        super(pParent.isSpurious(), pParent.getTargetPath(), pParent.getCFAPathWithAssignments(), pParent.isPreciseCounterExample(), CFAPathWithAdditionalInfo.empty());
        this.rankedList = FaultRankingUtils.rank(pRanking, pFaults);
        this.htmlWriter = new FaultReportWriter();
    }

    public final void prepare() {
        this.mapEdgeToFaultContribution = new HashMap<CFAEdge, FaultContribution>();
        this.mapEdgeToRankedFaultIndex = ArrayListMultimap.create();
        for (int i = 0; i < this.getRankedList().size(); ++i) {
            Iterator iterator = ((Fault)this.getRankedList().get(i)).iterator();
            while (iterator.hasNext()) {
                FaultContribution faultContribution = (FaultContribution)iterator.next();
                this.mapEdgeToRankedFaultIndex.put((Object)faultContribution.correspondingEdge(), (Object)i);
                this.mapEdgeToFaultContribution.put(faultContribution.correspondingEdge(), faultContribution);
            }
        }
    }

    public String toString() {
        StringBuilder toString = new StringBuilder();
        ImmutableList<Fault> faults = this.getRankedList();
        if (!faults.isEmpty()) {
            toString.append(faults.stream().map(Fault::toString).collect(Collectors.joining("\n\n")));
        }
        return toString.toString();
    }

    public static Set<Fault> transform(Set<Set<CFAEdge>> pErrorIndicators) {
        HashSet<Fault> transformed = new HashSet<Fault>();
        for (Set<CFAEdge> errorIndicator : pErrorIndicators) {
            transformed.add(new Fault((Collection<FaultContribution>)Collections3.transformedImmutableSetCopy(errorIndicator, FaultContribution::new)));
        }
        return transformed;
    }

    public void faultsToJSON(Writer pWriter) throws IOException {
        ArrayList faults = new ArrayList();
        ImmutableList<Fault> ranked = this.getRankedList();
        for (int i = 0; i < ranked.size(); ++i) {
            Fault fault = (Fault)ranked.get(i);
            HashMap<String, Object> faultMap = new HashMap<String, Object>();
            faultMap.put("rank", i + 1);
            faultMap.put("score", (int)(100.0 * fault.getScore()));
            faultMap.put("reason", this.htmlWriter.toHtml(fault));
            faults.add(faultMap);
        }
        JSON.writeJSONString(faults, (Appendable)pWriter);
    }

    @Override
    protected void addAdditionalInfo(Map<String, Object> elem, CFAEdge edge) {
        elem.put("additional", "");
        FaultContribution fc = this.mapEdgeToFaultContribution.get(edge);
        if (fc != null && fc.hasReasons()) {
            elem.put("additional", "<br><br><strong>Additional information provided:</strong><br>" + this.htmlWriter.toHtml(fc));
        }
        if (this.mapEdgeToRankedFaultIndex.containsKey((Object)edge)) {
            elem.put("faults", this.mapEdgeToRankedFaultIndex.get((Object)edge));
        }
        if (!elem.containsKey("faults")) {
            elem.put("faults", new ArrayList());
        }
    }

    public ImmutableList<Fault> getRankedList() {
        return this.rankedList;
    }

    public FaultReportWriter getHtmlWriter() {
        return this.htmlWriter;
    }

    public void replaceHtmlWriter(FaultReportWriter pFaultToHtml) {
        this.htmlWriter = pFaultToHtml;
    }

    public void apply() {
        super.getTargetPath().getLastState().replaceCounterexampleInformation(this);
    }
}

