/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class FaultRankingUtils {
    private static double computeScore(List<FaultInfo> faultInfos) {
        return faultInfos.stream().filter(c -> c.getType().equals((Object)FaultInfo.InfoType.RANK_INFO)).mapToDouble(FaultInfo::getScore).average().orElse(0.0);
    }

    public static FaultScoring concatHeuristics(final FaultScoring ... pRanking) {
        return new FaultScoring(){

            @Override
            public RankInfo scoreFault(Fault fault) {
                return FaultInfo.rankInfo("After concatenating rankings there is no need to call scoreFault.", 0.0);
            }

            @Override
            public void balancedScore(Set<Fault> faults) {
                for (FaultScoring faultScoring : pRanking) {
                    faultScoring.balancedScore(faults);
                }
            }
        };
    }

    public static ImmutableList<Fault> rank(FaultScoring scoring, Set<Fault> faults) {
        scoring.balancedScore(faults);
        ArrayList<Fault> rankedList = new ArrayList<Fault>();
        for (Fault fault : faults) {
            FaultRankingUtils.assignScoreTo(fault);
            Iterator iterator = fault.iterator();
            while (iterator.hasNext()) {
                FaultContribution faultContribution = (FaultContribution)iterator.next();
                FaultRankingUtils.assignScoreTo(faultContribution);
            }
            rankedList.add(fault);
        }
        return ImmutableList.sortedCopyOf(rankedList);
    }

    public static void assignScoreTo(Fault fault) {
        fault.setScore(FaultRankingUtils.computeScore(fault.getInfos()));
    }

    public static void assignScoreTo(FaultContribution faultContribution) {
        faultContribution.setScore(FaultRankingUtils.computeScore(faultContribution.getInfos()));
    }
}

