/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultReason;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.PotentialFix;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class FaultReportWriter {
    protected Set<FaultInfo.InfoType> hideTypes = new HashSet<FaultInfo.InfoType>();

    public FaultReportWriter() {
    }

    public FaultReportWriter(FaultInfo.InfoType ... pHideTypes) {
        this.hideTypes(pHideTypes);
    }

    public void hideTypes(FaultInfo.InfoType ... types) {
        this.hideTypes.clear();
        this.hideTypes.addAll(Arrays.asList(types));
    }

    public String toHtml(FaultInfo info) {
        String description = info.getDescription();
        if (info.getType().equals((Object)FaultInfo.InfoType.RANK_INFO)) {
            double likelihood = info.getScore();
            String percent = "<strong>" + (double)((int)(likelihood * 10000.0)) / 100.0 + "%</strong>";
            return description + " (" + percent + ")";
        }
        return description;
    }

    public String toHtml(FaultContribution faultContribution) {
        return this.toHtml(faultContribution.getInfos(), Collections.singletonList(faultContribution.correspondingEdge())) + (String)(faultContribution.getScore() > 0.0 ? "<br><i>Score: " + (int)(faultContribution.getScore() * 100.0) + "</i>" : "");
    }

    public String toHtml(Fault fault) {
        List edges = (List)fault.stream().map(FaultContribution::correspondingEdge).sorted(Comparator.comparingInt(l -> l.getFileLocation().getStartingLineInOrigin())).collect(ImmutableList.toImmutableList());
        return this.toHtml(fault.getInfos(), edges);
    }

    protected String toHtml(List<FaultInfo> infos, List<CFAEdge> correspondingEdges) {
        ArrayList<FaultReason> faultReasons = new ArrayList<FaultReason>();
        ArrayList<RankInfo> faultInfo = new ArrayList<RankInfo>();
        ArrayList<PotentialFix> faultFix = new ArrayList<PotentialFix>();
        for (FaultInfo info : infos) {
            switch (info.getType()) {
                case FIX: {
                    faultFix.add((PotentialFix)info);
                    break;
                }
                case REASON: {
                    faultReasons.add((FaultReason)info);
                    break;
                }
                case RANK_INFO: {
                    faultInfo.add((RankInfo)info);
                }
            }
        }
        Map<Integer, String> distinctRelevantStatements = this.getDistinctStatements(correspondingEdges);
        Object header = "Error suspected on line(s): <strong>" + this.listLineNumbersAndJoin(distinctRelevantStatements.keySet()) + "</strong><br>";
        StringBuilder html = new StringBuilder();
        if (!distinctRelevantStatements.isEmpty()) {
            html.append(" Relevant lines:\n<ul class=\"fault-lines\">\n");
            distinctRelevantStatements.entrySet().stream().sorted(Comparator.comparingInt(e -> (Integer)e.getKey())).forEach(e -> html.append("<li><span class=\"line-number\">" + e.getKey() + "</span><span class=\"line-content\">" + (String)e.getValue() + "</span></li>"));
            html.append("</ul>\n");
        } else {
            header = "Additional Information";
        }
        if (!faultReasons.isEmpty() && !this.hideTypes.contains((Object)FaultInfo.InfoType.REASON)) {
            html.append(this.printList("Detected <strong>" + faultReasons.size() + "</strong> possible reason" + (faultReasons.size() == 1 ? ":" : "s:"), "", faultReasons, true)).append("<br>");
        }
        if (!faultFix.isEmpty() && !this.hideTypes.contains((Object)FaultInfo.InfoType.FIX)) {
            html.append(this.printList("Found <strong>" + faultFix.size() + "</strong> possible bug-fix" + (faultFix.size() == 1 ? ":" : "es:"), "fix-list", faultFix, false)).append("<br>");
        }
        if (!faultInfo.isEmpty() && !this.hideTypes.contains((Object)FaultInfo.InfoType.RANK_INFO)) {
            html.append(this.printList("The score is obtained by:", "", faultInfo, true)).append("<br>");
        }
        return (String)header + "<br>" + html;
    }

    protected String printList(String headline, String htmlId, List<? extends FaultInfo> infos, boolean useOrderedList) {
        ImmutableList copy = ImmutableList.sortedCopyOf(infos);
        String listType = useOrderedList ? "ol" : "ul";
        Object id = "";
        if (!htmlId.isEmpty()) {
            id = " id=\"" + htmlId + "\"";
        }
        StringBuilder out = new StringBuilder(headline + "<br><" + listType + (String)id + ">");
        for (FaultInfo info : copy) {
            out.append("<li>").append(this.toHtml(info)).append("</li>");
        }
        out.append("</").append(listType).append(">");
        return out.toString();
    }

    protected Map<Integer, String> getDistinctStatements(List<CFAEdge> pEdges) {
        HashMap<Integer, String> statements = new HashMap<Integer, String>();
        for (CFAEdge e : pEdges) {
            int codeLineNumber = e.getFileLocation().getStartingLineInOrigin();
            String description = e.getDescription();
            statements.merge(codeLineNumber, description, (s1, s2) -> s1 + ", " + s2);
        }
        return statements;
    }

    private String listLineNumbersAndJoin(Collection<Integer> lineNumbers) {
        List sortedNumbers = (List)lineNumbers.stream().sorted().map(String::valueOf).collect(ImmutableList.toImmutableList());
        if (sortedNumbers.size() <= 2) {
            return String.join((CharSequence)" and ", sortedNumbers);
        }
        int lastIndex = sortedNumbers.size() - 1;
        return String.join((CharSequence)", ", sortedNumbers.subList(0, lastIndex)) + " and " + (String)sortedNumbers.get(lastIndex);
    }
}

