/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization;

import com.google.common.base.Splitter;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;

public class InformationProvider {
    public static void searchForAdditionalInformation(Collection<Fault> faults, List<CFAEdge> edges) {
        Pattern matchIteration = Pattern.compile(".+=.+[+\\-/*][ 1-9]+[0-9]+");
        Pattern matchArrayOperation = Pattern.compile(".+\\[.*[+\\-/*]+.*].*");
        Map<Object, Long> counts = edges.stream().map(CFAEdge::getDescription).collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        HashSet<String> iterationVariables = new HashSet<String>();
        for (Map.Entry<Object, Long> entry : counts.entrySet()) {
            String curr;
            Matcher itMatch;
            if (entry.getValue() <= 3L || !(itMatch = matchIteration.matcher(curr = (String)entry.getKey())).matches()) continue;
            List parts = Splitter.on((String)" ").splitToList((CharSequence)curr);
            parts.removeIf(String::isBlank);
            if (parts.size() <= 2 || !((String)parts.get(0)).equals(parts.get(2))) continue;
            iterationVariables.add((String)parts.get(0));
        }
        block1: for (Fault fault : faults) {
            Iterator iterator = fault.iterator();
            while (iterator.hasNext()) {
                FaultContribution faultContribution = (FaultContribution)iterator.next();
                String description = faultContribution.correspondingEdge().getDescription();
                boolean hasIter = false;
                for (String iterationVariable : iterationVariables) {
                    if (!description.contains(iterationVariable)) continue;
                    hasIter = true;
                    break;
                }
                boolean hasCalc = matchArrayOperation.matcher(description).matches();
                if (hasIter && hasCalc) {
                    fault.addInfo(FaultInfo.fix("Detected suspicious calculation within the array subscript using an iteration variable. Have a closer look to this line."));
                    continue block1;
                }
                if (hasIter) {
                    fault.addInfo(FaultInfo.fix("This line uses an iteration variable. This may be especially prone to errors."));
                    continue block1;
                }
                if (!hasCalc) continue;
                fault.addInfo(FaultInfo.fix("Detected suspicious calculation within the array subscript. This may be especially prone to errors"));
                continue block1;
            }
        }
    }

    public static void addDefaultPotentialFixesToFaults(Collection<Fault> result, int maxNumberOfHints) {
        boolean maxNumberOfHintsNegative = maxNumberOfHints < 0;
        HashSet<FaultContribution> alreadyAttached = new HashSet<FaultContribution>();
        for (Fault faultLocalizationOutputs : result) {
            int hints = 0;
            Iterator iterator = faultLocalizationOutputs.iterator();
            while (iterator.hasNext()) {
                FaultContribution faultContribution = (FaultContribution)iterator.next();
                FaultInfo potFix = FaultInfo.possibleFixFor(new Fault(faultContribution));
                if (maxNumberOfHintsNegative || hints < maxNumberOfHints) {
                    faultLocalizationOutputs.addInfo(potFix);
                }
                if (!alreadyAttached.contains(faultContribution)) {
                    faultContribution.addInfo(potFix);
                    alreadyAttached.add(faultContribution);
                }
                ++hints;
            }
        }
    }
}

