/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization.appendables;

import java.util.Comparator;
import java.util.Objects;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultReason;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.PotentialFix;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.ranking.NoContextExplanation;

public abstract class FaultInfo
implements Comparable<FaultInfo> {
    protected double score;
    protected String description;
    private final InfoType type;

    protected FaultInfo(InfoType pType) {
        this.type = pType;
    }

    public static FaultInfo possibleFixFor(Fault pFault) {
        return new PotentialFix(NoContextExplanation.getInstance().explanationFor(pFault));
    }

    public static PotentialFix fix(String pDescription) {
        return new PotentialFix(pDescription);
    }

    public static RankInfo rankInfo(String pDescription, double pLikelihood) {
        return new RankInfo(pDescription, pLikelihood);
    }

    public static FaultReason justify(String pDescription) {
        return new FaultReason(pDescription);
    }

    public double getScore() {
        return this.score;
    }

    public String getDescription() {
        return this.description;
    }

    public InfoType getType() {
        return this.type;
    }

    @Override
    public int compareTo(FaultInfo info) {
        return Comparator.comparing(FaultInfo::getType).thenComparingDouble(FaultInfo::getScore).compare(this, info);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{31, this.description, this.score, this.type});
    }

    public boolean equals(Object q) {
        if (q instanceof FaultInfo) {
            FaultInfo r = (FaultInfo)q;
            if (this.type.equals((Object)r.type)) {
                return r.description.equals(this.description) && this.score == r.score;
            }
        }
        return false;
    }

    public String toString() {
        String percent = (double)((int)(this.score * 10000.0)) / 100.0 + "%";
        return this.type + ": " + this.description + " (" + percent + ")";
    }

    public static enum InfoType {
        REASON,
        FIX,
        RANK_INFO;

    }
}

