/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization.ranking;

import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class MaximalLineDistanceScoring
implements FaultScoring {
    private final int errorLocation;

    public MaximalLineDistanceScoring(CFAEdge pErrorLocation) {
        this.errorLocation = pErrorLocation.getFileLocation().getStartingLineInOrigin();
    }

    @Override
    public RankInfo scoreFault(Fault fault) {
        int max = fault.stream().mapToInt(fc -> Math.abs(fc.correspondingEdge().getFileLocation().getStartingLineInOrigin() - this.errorLocation)).max().orElse(0);
        return FaultInfo.rankInfo("This line is " + max + " line(s) away from the error location", max);
    }
}

