/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization.ranking;

import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class MinimalLineDistanceScoring
implements FaultScoring {
    private final int errorLocation;

    public MinimalLineDistanceScoring(CFAEdge pErrorLocation) {
        this.errorLocation = pErrorLocation.getFileLocation().getStartingLineInOrigin();
    }

    @Override
    public RankInfo scoreFault(Fault fault) {
        int min = fault.stream().mapToInt(fc -> Math.abs(fc.correspondingEdge().getFileLocation().getStartingLineInOrigin() - this.errorLocation)).min().orElse(0);
        double likelihood = min == 0 ? 0.0 : 1.0 / (double)min;
        return FaultInfo.rankInfo("This line is " + min + " line(s) away from the error location", likelihood);
    }
}

