/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization.ranking;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import org.sosy_lab.cpachecker.cfa.model.CFAEdge;
import org.sosy_lab.cpachecker.cfa.model.c.CFunctionReturnEdge;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultContribution;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultExplanation;

public class NoContextExplanation
implements FaultExplanation {
    private static final NoContextExplanation instance = new NoContextExplanation();

    public static NoContextExplanation getInstance() {
        return instance;
    }

    private NoContextExplanation() {
    }

    @Override
    public String explanationFor(Fault subset) {
        return FluentIterable.from((Iterable)((Object)subset)).transform(this::explain).join(Joiner.on((String)"\n\n"));
    }

    private String explain(FaultContribution faultContribution) {
        CFAEdge pEdge = faultContribution.correspondingEdge();
        String description = pEdge.getDescription();
        switch (pEdge.getEdgeType()) {
            case AssumeEdge: {
                String[] ops = new String[]{"<=", "!=", "==", ">=", "<", ">"};
                String op = "";
                for (String o : ops) {
                    if (!description.contains(o)) continue;
                    op = o;
                    break;
                }
                return "Try to replace \"" + op + "\" in \"" + description + "\" with another boolean operator (<, >, <=, !=, ==, >=). This line may be prone to off-by-one errors!";
            }
            case StatementEdge: {
                return "Try to change the assigned value of \"" + (String)Iterables.get((Iterable)Splitter.on((String)" ").split((CharSequence)description), (int)0) + "\" in \"" + description + "\" to another value.";
            }
            case DeclarationEdge: {
                return "Try to declare the variable in \"" + description + "\" differently.";
            }
            case ReturnStatementEdge: {
                return "Try to change the return-value of \"" + description + "\" to another value.";
            }
            case FunctionCallEdge: {
                return "The function call \"" + description + "\" may have unwanted side effects or a wrong return value.";
            }
            case FunctionReturnEdge: {
                String functionName = ((CFunctionReturnEdge)pEdge).getFunctionEntry().getFunctionName();
                return "The function " + functionName + "(...) may have an unwanted return value.";
            }
        }
        return "No proposal found for the statement: \"" + description + "\".";
    }
}

