/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.faultlocalization.ranking;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sosy_lab.cpachecker.util.faultlocalization.Fault;
import org.sosy_lab.cpachecker.util.faultlocalization.FaultScoring;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.FaultInfo;
import org.sosy_lab.cpachecker.util.faultlocalization.appendables.RankInfo;

public class OverallOccurrenceScoring
implements FaultScoring {
    private final Map<Fault, Double> faultValue = new HashMap<Fault, Double>();

    @Override
    public RankInfo scoreFault(Fault fault) {
        return FaultInfo.rankInfo("Sorted by overall occurrence in all faults.", this.faultValue.get(fault));
    }

    @Override
    public void balancedScore(Set<Fault> faults) {
        for (Fault f1 : faults) {
            double value = 0.0;
            for (Fault f2 : faults) {
                HashSet intersection = new HashSet(f1);
                intersection.removeAll((Collection<?>)((Object)f2));
                value += (double)(f1.size() - intersection.size());
            }
            this.faultValue.put(f1, value);
        }
        double sum = this.faultValue.values().stream().mapToDouble(Double::valueOf).sum();
        if (sum == 0.0) {
            for (Fault f : faults) {
                f.addInfo(FaultInfo.rankInfo("Sorted by overall occurrence in all faults.", 1.0 / (double)faults.size()));
            }
        } else {
            for (Fault f : faults) {
                RankInfo info = this.scoreFault(f);
                info.setScore(info.getScore() / sum);
                f.addInfo(info);
            }
        }
    }
}

