/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.floatingpoint;

import org.sosy_lab.cpachecker.util.floatingpoint.CFloatWrapper;

public abstract class CFloat {
    public abstract CFloat add(CFloat var1);

    public abstract CFloat add(CFloat ... var1);

    public abstract CFloat multiply(CFloat var1);

    public abstract CFloat multiply(CFloat ... var1);

    public abstract CFloat subtract(CFloat var1);

    public abstract CFloat divideBy(CFloat var1);

    public abstract CFloat powTo(CFloat var1);

    public abstract CFloat powToIntegral(int var1);

    public abstract CFloat sqrt();

    public abstract CFloat round();

    public abstract CFloat trunc();

    public abstract CFloat ceil();

    public abstract CFloat floor();

    public abstract CFloat abs();

    public abstract boolean isZero();

    public abstract boolean isOne();

    public boolean isNan() {
        return false;
    }

    public boolean isInfinity() {
        return false;
    }

    public abstract boolean isNegative();

    public abstract CFloat copySignFrom(CFloat var1);

    public abstract CFloat castTo(int var1);

    public abstract Number castToOther(int var1);

    public abstract CFloatWrapper copyWrapper();

    protected abstract CFloatWrapper getWrapper();

    public abstract int getType();

    public abstract boolean greaterThan(CFloat var1);

    public final long getExponent() {
        return this.getWrapper().getExponent();
    }

    public final long getMantissa() {
        return this.getWrapper().getMantissa();
    }

    public final int getNormalizedMantissaLength() {
        int length = 0;
        switch (this.getType()) {
            case 0: {
                length = 24;
                break;
            }
            case 1: {
                length = 53;
                break;
            }
            case 2: {
                length = 64;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return length;
    }

    public final long getOverflowHighBitsMask() {
        long bits = 0L;
        switch (this.getType()) {
            case 0: {
                bits = -2199023255552L;
                break;
            }
            case 1: {
                bits = -4096L;
                break;
            }
            case 2: {
                bits = -1L;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return bits;
    }

    public final int getExponentLength() {
        int res = -1;
        switch (this.getType()) {
            case 0: {
                res = 8;
                break;
            }
            case 1: {
                res = 11;
                break;
            }
            case 2: {
                res = 15;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented floating point type: " + this.getType());
            }
        }
        return res;
    }

    public final long getBias() {
        long bias = 0L;
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 2: {
                bias = this.getExponentMask() / 2L;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return bias;
    }

    public final int getMantissaLength() {
        int res = -1;
        switch (this.getType()) {
            case 0: {
                res = 23;
                break;
            }
            case 1: {
                res = 52;
                break;
            }
            case 2: {
                res = 64;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented floating point type: " + this.getType());
            }
        }
        return res;
    }

    public final long getSignBitMask() {
        long signBit = 0L;
        switch (this.getType()) {
            case 0: {
                signBit = 256L;
                break;
            }
            case 1: {
                signBit = 2048L;
                break;
            }
            case 2: {
                signBit = 32768L;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return signBit;
    }

    public final long getExponentMask() {
        long exp = 0L;
        switch (this.getType()) {
            case 0: {
                exp = 255L;
                break;
            }
            case 1: {
                exp = 2047L;
                break;
            }
            case 2: {
                exp = 32767L;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return exp;
    }

    public final CFloatWrapper round(CFloatWrapper pWrapper, long pOverflow) {
        CFloatWrapper rWrapper = pWrapper.copy();
        if (pOverflow != 0L) {
            boolean isNormalized;
            long man = rWrapper.getMantissa();
            long exp = rWrapper.getExponent();
            boolean bl = isNormalized = this.getType() == 2 && (man & this.getNormalizationMask()) != 0L;
            if ((this.getHighestOrderOverflowBitMask() & pOverflow) != 0L && ((this.getLowerOrderOverflowBitsMask() & pOverflow) != 0L || (1L & man) != 0L)) {
                long nMan = man + 1L & this.getNormalizedMantissaMask();
                if (this.getType() != 2 && (nMan & this.getNormalizationMask()) != 0L || this.getType() == 2 && (nMan & this.getNormalizationMask()) == 0L && isNormalized) {
                    nMan >>>= 1;
                    nMan ^= this.getNormalizationMask();
                    nMan &= this.getNormalizedMantissaMask();
                    --exp;
                }
                rWrapper.setExponent(exp);
                rWrapper.setMantissa(nMan);
            }
        }
        return rWrapper;
    }

    public final long getLowerOrderOverflowBitsMask() {
        long bits = 0L;
        switch (this.getType()) {
            case 0: {
                bits = 9223369837831520256L;
                break;
            }
            case 1: {
                bits = 0x7FFFFFFFFFFFF000L;
                break;
            }
            case 2: {
                bits = Long.MAX_VALUE;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return bits;
    }

    public final long getHighestOrderOverflowBitMask() {
        return Long.MIN_VALUE;
    }

    public final long getMantissaMask() {
        long man = 0L;
        switch (this.getType()) {
            case 0: {
                man = 0x7FFFFFL;
                break;
            }
            case 1: {
                man = 0xFFFFFFFFFFFFFL;
                break;
            }
            case 2: {
                man = Long.MAX_VALUE;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return man;
    }

    public final long getNormalizationMask() {
        long oneBit = 0L;
        switch (this.getType()) {
            case 0: {
                oneBit = 0x800000L;
                break;
            }
            case 1: {
                oneBit = 0x10000000000000L;
                break;
            }
            case 2: {
                oneBit = Long.MIN_VALUE;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return oneBit;
    }

    public final long getNormalizedMantissaMask() {
        long man = 0L;
        switch (this.getType()) {
            case 0: 
            case 1: {
                return this.getMantissaMask();
            }
            case 2: {
                man = -1L;
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.getType());
            }
        }
        return man;
    }
}

