/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.floatingpoint;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloat;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatInf;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatNaN;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatNativeAPI;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatUtil;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatWrapper;

public class CFloatImpl
extends CFloat {
    private static final ImmutableList<String> DEFAULT_VALUES = ImmutableList.copyOf((Object[])new String[]{"-0.0", "-0", "-1", "0", "0.0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "nan", "-nan", "inf", "-inf"});
    private final CFloatWrapper wrapper;
    private final int type;

    public CFloatImpl(CFloatWrapper pWrapper, int pType) {
        this.wrapper = pWrapper;
        this.type = pType;
    }

    public CFloatImpl(String pRep, int pType) {
        this.type = pType;
        if (DEFAULT_VALUES.contains((Object)pRep.toLowerCase())) {
            this.wrapper = new CFloatWrapper();
            long exp = 0L;
            long man = 0L;
            switch (pRep.toLowerCase()) {
                case "0.0": 
                case "0": {
                    break;
                }
                case "1": {
                    exp = this.getBias();
                    man = this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "2": {
                    exp = this.getBias() + 1L;
                    man = this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "3": {
                    exp = this.getBias() + 1L;
                    man = (this.getNormalizationMask() >>> 1) + this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "4": {
                    exp = this.getBias() + 2L;
                    man = this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "5": {
                    exp = this.getBias() + 2L;
                    man = (this.getNormalizationMask() >>> 2) + this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "6": {
                    exp = this.getBias() + 2L;
                    man = (this.getNormalizationMask() >>> 1) + this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "7": {
                    exp = this.getBias() + 2L;
                    man = (this.getNormalizationMask() >>> 2) + (this.getNormalizationMask() >>> 1) + this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "8": {
                    exp = this.getBias() + 3L;
                    man = this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "9": {
                    exp = this.getBias() + 3L;
                    man = (this.getNormalizationMask() >>> 3) + this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "10": {
                    exp = this.getBias() + 3L;
                    man = (this.getNormalizationMask() >>> 2) + this.getNormalizationMask() & this.getNormalizedMantissaMask();
                    break;
                }
                case "-1": {
                    exp = this.getSignBitMask() + this.getBias();
                    man = pType == 2 ? this.getNormalizationMask() : 0L;
                    break;
                }
                case "nan": {
                    exp = 1L;
                    man = 0L;
                    break;
                }
                case "-nan": {
                    exp = this.getSignBitMask() + 1L;
                    man = 0L;
                    break;
                }
                case "inf": {
                    exp = this.getExponentMask();
                    man = 1L;
                    break;
                }
                case "-inf": {
                    exp = this.getExponentMask() + this.getSignBitMask();
                    man = 1L;
                    break;
                }
                case "-0.0": 
                case "-0": {
                    exp = this.getSignBitMask();
                    man = 0L;
                    break;
                }
                default: {
                    throw new RuntimeException("Default case '" + pRep + "' is not yet implemented!");
                }
            }
            this.wrapper.setExponent(exp);
            this.wrapper.setMantissa(man);
        } else {
            List parts = Splitter.on((char)'.').splitToList((CharSequence)pRep);
            boolean negative = pRep.startsWith("-");
            CFloat integral = null;
            CFloat fractional = null;
            if (!((String)parts.get(0)).isEmpty()) {
                integral = this.makeIntegralPart((String)parts.get(0), pType);
            }
            if (parts.size() > 1 && !((String)parts.get(1)).isEmpty()) {
                fractional = this.makeFractionalPart((String)parts.get(1), pType);
            }
            CFloat result = new CFloatImpl("0", pType);
            if (integral != null) {
                result = result.add(integral);
            }
            if (fractional != null) {
                result = result.add(fractional);
            }
            if (negative) {
                CFloatImpl nOne = new CFloatImpl("-1", pType);
                result = result.multiply((CFloat)nOne);
            }
            this.wrapper = result.castTo(pType).copyWrapper();
        }
    }

    private CFloat makeIntegralPart(String pRep, int pType) {
        String rep = null;
        rep = pRep.startsWith("-") ? pRep.substring(1) : pRep;
        List<String> digits = Arrays.asList(rep.split(""));
        CFloat result = this.fromString(pType, digits);
        return result;
    }

    private CFloat fromString(int pType, List<String> pDigits) {
        int[] decArray = new int[pDigits.size()];
        for (int i = 0; i < decArray.length; ++i) {
            decArray[i] = Byte.parseByte(pDigits.get(i));
        }
        int[] auxArray = new int[decArray.length];
        int[] bitArray = new int[this.getMantissaLength() * 2 + (pType == 2 ? 0 : 2)];
        int effectiveExponent = 0;
        if (this.decimalEqual(decArray, auxArray)) {
            return CFloatNativeAPI.ZERO_SINGLE;
        }
        boolean incrementExponent = true;
        boolean stillConverging = true;
        while (this.decimalAGreaterThanB(decArray, auxArray) && stillConverging) {
            int[] loopArray = new int[auxArray.length];
            loopArray[loopArray.length - 1] = 1;
            int[] bitAuxArray = new int[bitArray.length];
            if (effectiveExponent < bitAuxArray.length - 1) {
                bitAuxArray[effectiveExponent] = 1;
            }
            int safeCounter = effectiveExponent;
            stillConverging = false;
            while (this.decimalAGreaterThanB(decArray, this.decimalAdd(loopArray, auxArray))) {
                stillConverging = true;
                if (incrementExponent) {
                    ++effectiveExponent;
                } else if (safeCounter >= bitAuxArray.length) {
                    if (safeCounter == bitAuxArray.length) {
                        bitAuxArray[bitAuxArray.length - 1] = 1;
                    }
                    --safeCounter;
                } else {
                    bitAuxArray = this.binaryDouble(bitAuxArray);
                }
                loopArray = this.decimalDouble(loopArray);
            }
            if (this.decimalEqual(decArray, this.decimalAdd(loopArray, auxArray))) {
                bitArray = this.binaryAdd(bitAuxArray, bitArray);
                auxArray = this.decimalAdd(loopArray, auxArray);
            } else if (stillConverging) {
                if (incrementExponent) {
                    --effectiveExponent;
                } else {
                    this.binaryHalf(bitAuxArray);
                }
                this.decimalHalf(loopArray);
                bitArray = this.binaryAdd(bitAuxArray, bitArray);
                auxArray = this.decimalAdd(loopArray, auxArray);
            }
            incrementExponent = false;
        }
        long mantissa = 0L;
        long overflow = 0L;
        for (int i = 0; i < bitArray.length / 2; ++i) {
            mantissa ^= (long)bitArray[i] << bitArray.length / 2 - 1 - i;
            overflow ^= (long)bitArray[i + bitArray.length / 2] << 63 - i;
        }
        CFloatWrapper rWrapper = new CFloatWrapper((long)effectiveExponent + this.getBias(), mantissa);
        rWrapper = this.round(rWrapper, overflow);
        rWrapper.setMantissa(rWrapper.getMantissa() & this.getNormalizedMantissaMask());
        return new CFloatImpl(rWrapper, pType);
    }

    private void binaryHalf(int[] pArray) {
        this.digitwiseHalf(pArray, 2);
    }

    private void decimalHalf(int[] pArray) {
        this.digitwiseHalf(pArray, 10);
    }

    private void digitwiseHalf(int[] pArray, int pRadix) {
        for (int i = pArray.length - 1; i > 0; --i) {
            if (pArray[i - 1] % 2 != 0) {
                int n = i;
                pArray[n] = pArray[n] + pRadix;
            }
            int n = i;
            pArray[n] = pArray[n] / 2;
            if (i != 1) continue;
            pArray[0] = pArray[0] / 2;
        }
    }

    private int[] binaryAdd(int[] pArrayA, int[] pArrayB) {
        return this.digitwiseAdd(pArrayA, pArrayB, 2);
    }

    private int[] decimalAdd(int[] pArrayA, int[] pArrayB) {
        return this.digitwiseAdd(pArrayA, pArrayB, 10);
    }

    private int[] digitwiseAdd(int[] pArrayA, int[] pArrayB, int pRadix) {
        int[] rArray = new int[Math.max(pArrayB.length, pArrayA.length) + 1];
        for (int i = rArray.length - 1; i >= 0; --i) {
            int n = i;
            rArray[n] = rArray[n] + ((i - 1 < pArrayA.length && i > 0 ? pArrayA[i - 1] : 0) + (i - 1 < pArrayB.length && i > 0 ? pArrayB[i - 1] : 0));
            if (rArray[i] <= pRadix - 1) continue;
            if (i > 0) {
                int n2 = i - 1;
                rArray[n2] = rArray[n2] + rArray[i] / pRadix;
            }
            int n3 = i;
            rArray[n3] = rArray[n3] % pRadix;
        }
        if (rArray[0] == 0) {
            rArray = this.copyAllButFirstCell(rArray);
        }
        return rArray;
    }

    private boolean decimalEqual(int[] pA, int[] pB) {
        int diff = pB.length - pA.length;
        if (diff < 0) {
            int i;
            diff *= -1;
            for (i = 0; i < diff; ++i) {
                if (pA[i] <= 0) continue;
                return false;
            }
            for (i = 0; i < pB.length; ++i) {
                if (pA[i + diff] == pB[i]) continue;
                return false;
            }
        } else {
            int i;
            for (i = 0; i < diff; ++i) {
                if (pB[i] <= 0) continue;
                return false;
            }
            for (i = 0; i < pA.length; ++i) {
                if (pA[i] == pB[i + diff]) continue;
                return false;
            }
        }
        return true;
    }

    private boolean decimalAGreaterThanB(int[] pA, int[] pB) {
        int diff = pB.length - pA.length;
        if (diff < 0) {
            int i;
            diff *= -1;
            for (i = 0; i < diff; ++i) {
                if (pA[i] <= 0) continue;
                return true;
            }
            for (i = 0; i < pB.length; ++i) {
                if (pA[i + diff] > pB[i]) {
                    return true;
                }
                if (pA[i + diff] >= pB[i]) continue;
                return false;
            }
        } else {
            int i;
            for (i = 0; i < diff; ++i) {
                if (pB[i] <= 0) continue;
                return false;
            }
            for (i = 0; i < pA.length; ++i) {
                if (pA[i] > pB[i + diff]) {
                    return true;
                }
                if (pA[i] >= pB[i + diff]) continue;
                return false;
            }
        }
        return false;
    }

    private int[] binaryDouble(int[] pArray) {
        return this.digitwiseDouble(pArray, 2);
    }

    private int[] decimalDouble(int[] pDecimalArray) {
        return this.digitwiseDouble(pDecimalArray, 10);
    }

    private int[] digitwiseDouble(int[] pArray, int pRadix) {
        int i;
        int[] rArray = new int[pArray.length + 1];
        for (i = 1; i < rArray.length; ++i) {
            rArray[i] = (byte)(pArray[i - 1] * 2);
            if (rArray[i] <= pRadix - 1) continue;
            int n = i - 1;
            rArray[n] = rArray[n] + rArray[i] / pRadix;
            int n2 = i;
            rArray[n2] = rArray[n2] % pRadix;
        }
        if (rArray[0] == 0) {
            for (i = 0; i < rArray.length - 1; ++i) {
                rArray[i] = rArray[i + 1];
            }
            rArray = Arrays.copyOf(rArray, pArray.length);
        }
        return rArray;
    }

    private CFloat makeFractionalPart(String pRep, int pType) {
        List<String> digits = Arrays.asList(pRep.split(""));
        CFloatImpl ten = new CFloatImpl("10", 2);
        CFloat divisor = new CFloatImpl("1", 2);
        CFloat result = new CFloatImpl("0", pType);
        for (String pDigit : digits) {
            result = result.multiply((CFloat)ten);
            divisor = ((CFloat)divisor).multiply((CFloat)ten);
            CFloatImpl fD = new CFloatImpl(pDigit, pType);
            result = result.add((CFloat)fD);
        }
        result = result.divideBy(divisor);
        return result;
    }

    @Override
    public CFloat add(CFloat pSummand) {
        CFloat tSummand = this;
        CFloat oSummand = pSummand;
        if (tSummand.getType() != oSummand.getType()) {
            if (tSummand.getType() > oSummand.getType()) {
                oSummand = oSummand.castTo(tSummand.getType());
            } else {
                tSummand = tSummand.castTo(oSummand.getType());
            }
        }
        if (tSummand.isNan() || oSummand.isNan()) {
            return new CFloatNaN(tSummand.isNegative(), tSummand.getType());
        }
        if (tSummand.isInfinity()) {
            if (oSummand.isInfinity() && tSummand.isNegative() != oSummand.isNegative()) {
                return new CFloatNaN(true, tSummand.getType());
            }
            return new CFloatInf(tSummand.isNegative(), tSummand.getType());
        }
        if (oSummand.isInfinity()) {
            return new CFloatInf(oSummand.isNegative(), tSummand.getType());
        }
        if (tSummand.isZero()) {
            return new CFloatImpl(oSummand.copyWrapper(), oSummand.getType());
        }
        if (oSummand.isZero()) {
            return new CFloatImpl(tSummand.copyWrapper(), tSummand.getType());
        }
        long rExp = 0L;
        long tExp = tSummand.getExponent() & tSummand.getExponentMask();
        long tMan = tSummand.getMantissa();
        long oExp = oSummand.getExponent() & tSummand.getExponentMask();
        long oMan = oSummand.getMantissa();
        boolean negResult = false;
        boolean differentSign = tSummand.isNegative() ^ oSummand.isNegative();
        boolean tGTO = tSummand.greaterThan(oSummand);
        if (differentSign) {
            return tGTO ? tSummand.subtract(new CFloatImpl(new CFloatWrapper(oExp, oMan), tSummand.getType())) : oSummand.subtract(new CFloatImpl(new CFloatWrapper(tExp, tMan), tSummand.getType()));
        }
        if (tSummand.isNegative()) {
            negResult = true;
        }
        long overflow = 0L;
        if (tSummand.getType() != 2 && !tSummand.isZero()) {
            tMan ^= tSummand.getNormalizationMask();
        }
        if (tSummand.getType() != 2 && !oSummand.isZero()) {
            oMan ^= tSummand.getNormalizationMask();
        }
        if (tExp > oExp) {
            long diff = tExp - oExp;
            rExp = tExp;
            if (diff > 2L * (long)tSummand.getMantissaLength() || diff == 2L * (long)tSummand.getMantissaLength() && tSummand.getType() == 2) {
                oMan = 0L;
            } else if (diff <= (long)tSummand.getMantissaLength() && tSummand.getType() != 2 || diff < (long)tSummand.getMantissaLength()) {
                overflow = tSummand.getType() != 2 ? oMan << (int)(63L - diff) : oMan << (int)(64L - diff);
                oMan >>>= (int)diff;
            } else {
                if (tSummand.getType() != 2) {
                    overflow = oMan << 63 - tSummand.getMantissaLength();
                    overflow >>>= (int)(diff - (long)tSummand.getMantissaLength() - 1L);
                } else {
                    overflow = oMan << 64 - tSummand.getMantissaLength();
                    overflow >>>= (int)(diff - (long)tSummand.getMantissaLength());
                }
                overflow &= tSummand.getOverflowHighBitsMask();
                oMan = 0L;
            }
        } else {
            long diff = oExp - tExp;
            rExp = oExp;
            if (diff > 2L * (long)tSummand.getMantissaLength() || diff == 2L * (long)tSummand.getMantissaLength() && tSummand.getType() == 2) {
                tMan = 0L;
            } else if (diff <= (long)tSummand.getMantissaLength() && tSummand.getType() != 2 || diff < (long)tSummand.getMantissaLength()) {
                overflow = tSummand.getType() != 2 ? tMan << (int)(63L - diff) : tMan << (int)(64L - diff);
                tMan >>>= (int)diff;
            } else {
                if (tSummand.getType() != 2) {
                    overflow = tMan << 63 - tSummand.getMantissaLength();
                    overflow >>>= (int)(diff - (long)tSummand.getMantissaLength() - 1L);
                } else {
                    overflow = tMan << 64 - tSummand.getMantissaLength();
                    overflow >>>= (int)(diff - (long)tSummand.getMantissaLength());
                }
                overflow &= tSummand.getOverflowHighBitsMask();
                tMan = 0L;
            }
        }
        long rMan = tMan + oMan;
        switch (tSummand.getType()) {
            case 2: {
                if ((rMan & tSummand.getNormalizationMask()) != 0L) break;
                rMan >>>= 1;
                rMan |= tSummand.getNormalizationMask() & tSummand.getNormalizedMantissaMask();
                ++rExp;
                overflow <<= 1;
                break;
            }
            case 0: 
            case 1: {
                if ((rMan & tSummand.getNormalizationMask() << 1) == 0L) break;
                rMan >>>= 1;
                ++rExp;
                overflow <<= 1;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unimplemented floating-point-type: " + tSummand.getType());
            }
        }
        CFloatWrapper rWrapper = tSummand.round(new CFloatWrapper(rExp, rMan &= tSummand.getNormalizedMantissaMask()), overflow);
        if ((rExp & tSummand.getExponentMask()) == tSummand.getExponentMask() || rExp >= tSummand.getSignBitMask() * 2L) {
            return new CFloatInf(negResult, tSummand.getType());
        }
        if (negResult) {
            rWrapper.setExponent(rWrapper.getExponent() ^ tSummand.getSignBitMask());
        }
        return new CFloatImpl(rWrapper, tSummand.getType());
    }

    @Override
    public CFloat add(CFloat ... pSummands) {
        CFloat result = this;
        for (CFloat s : pSummands) {
            result = ((CFloat)result).add(s);
        }
        return result;
    }

    @Override
    public CFloat multiply(CFloat pFactor) {
        CFloatImpl result;
        long rExp;
        int cExp;
        long signBit;
        CFloat tFactor = this;
        CFloat oFactor = pFactor;
        boolean negativeResult = tFactor.isNegative() ^ oFactor.isNegative();
        if (tFactor.getType() != oFactor.getType()) {
            if (tFactor.getType() > oFactor.getType()) {
                oFactor = oFactor.castTo(tFactor.getType());
            } else {
                tFactor = tFactor.castTo(oFactor.getType());
            }
        }
        if (tFactor.isNan() || oFactor.isNan()) {
            return new CFloatNaN(negativeResult, tFactor.getType());
        }
        if (tFactor.isInfinity() || oFactor.isInfinity()) {
            return new CFloatInf(negativeResult, tFactor.getType());
        }
        if (tFactor.isZero() || oFactor.isZero()) {
            if (negativeResult) {
                return new CFloatImpl("-0.0", tFactor.getType());
            }
            return new CFloatImpl("0", tFactor.getType());
        }
        long l = signBit = negativeResult ? tFactor.getSignBitMask() : 0L;
        if (oFactor.isOne()) {
            CFloatWrapper rWrapper = tFactor.copyWrapper();
            rWrapper.setExponent(rWrapper.getExponent() & tFactor.getExponentMask() ^ signBit);
            return new CFloatImpl(rWrapper, tFactor.getType());
        }
        if (tFactor.isOne()) {
            CFloatWrapper rWrapper = oFactor.copyWrapper();
            rWrapper.setExponent(rWrapper.getExponent() & tFactor.getExponentMask() ^ signBit);
            return new CFloatImpl(rWrapper, tFactor.getType());
        }
        long rMan = 0L;
        long rOverflow = 0L;
        long tMan = tFactor.getMantissa();
        long oMan = oFactor.getMantissa();
        long tExp = tFactor.getExponent() & tFactor.getExponentMask();
        long oExp = oFactor.getExponent() & tFactor.getExponentMask();
        boolean negResult = tFactor.isNegative() ^ oFactor.isNegative();
        int mantissaLength = tFactor.getMantissaLength();
        if (tFactor.getType() != 2) {
            ++mantissaLength;
            if (tExp > 0L) {
                tMan ^= tFactor.getNormalizationMask();
            }
            if (oExp > 0L) {
                oMan ^= tFactor.getNormalizationMask();
            }
        }
        int[] bitfield = new int[mantissaLength * 2];
        if (Long.bitCount(tMan) > Long.bitCount(oMan)) {
            this.multiplyBits(tMan, oMan, mantissaLength, bitfield);
        } else {
            this.multiplyBits(oMan, tMan, mantissaLength, bitfield);
        }
        for (int i = cExp = bitfield[mantissaLength * 2 - 1] == 1 ? 1 : 0; i <= mantissaLength; ++i) {
            if (bitfield[i + mantissaLength - 1] == 1) {
                rMan += 1L << i - cExp;
            }
            if (bitfield[i] != 1) continue;
            rOverflow += 1L << i - cExp + (64 - mantissaLength);
        }
        for (rExp = tExp + oExp - tFactor.getBias() + (long)cExp; rExp < 0L && rMan != 0L; rMan >>>= 1, ++rExp) {
            rOverflow >>>= 1;
            rOverflow |= rMan << 63;
        }
        while ((rMan & tFactor.getNormalizationMask()) == 0L && rExp > 0L) {
            rMan <<= 1;
            rMan |= rOverflow >>> 63;
            rOverflow <<= 1;
            --rExp;
        }
        CFloatWrapper rWrapper = tFactor.round(new CFloatWrapper(rExp, rMan &= tFactor.getNormalizedMantissaMask()), rOverflow);
        if (negResult) {
            rWrapper.setExponent(rWrapper.getExponent() ^ tFactor.getSignBitMask());
        }
        if ((result = new CFloatImpl(rWrapper, tFactor.getType())).isNan()) {
            return new CFloatNaN(((CFloat)result).isNegative(), ((CFloat)result).getType());
        }
        if (result.isInfinity()) {
            return new CFloatInf(((CFloat)result).isNegative(), ((CFloat)result).getType());
        }
        return result;
    }

    private void multiplyBits(long manyOnesMantissa, long lesserOnesMantissa, int mantissaLength, int[] bitfield) {
        int i;
        for (i = 0; i < mantissaLength; ++i) {
            if ((lesserOnesMantissa & 1L << i) == 0L) continue;
            for (int j = 0; j < mantissaLength; ++j) {
                if ((manyOnesMantissa & 1L << j) == 0L) continue;
                int n = j + i;
                bitfield[n] = bitfield[n] + 1;
            }
        }
        for (i = 0; i < bitfield.length; ++i) {
            if (bitfield[i] <= 1) continue;
            int n = i + 1;
            bitfield[n] = bitfield[n] + bitfield[i] / 2;
            int n2 = i;
            bitfield[n2] = bitfield[n2] % 2;
        }
    }

    @Override
    public CFloat multiply(CFloat ... pFactors) {
        CFloat result = this;
        for (CFloat f : pFactors) {
            result = ((CFloat)result).multiply(f);
        }
        return result;
    }

    @Override
    public CFloat subtract(CFloat pSubtrahend) {
        boolean negResult;
        CFloat tSubtrahend = this;
        CFloat oSubtrahend = pSubtrahend;
        if (tSubtrahend.getType() != oSubtrahend.getType()) {
            if (tSubtrahend.getType() > oSubtrahend.getType()) {
                oSubtrahend = oSubtrahend.castTo(tSubtrahend.getType());
            } else {
                tSubtrahend = tSubtrahend.castTo(oSubtrahend.getType());
            }
        }
        if (tSubtrahend.isNan() || oSubtrahend.isNan()) {
            return new CFloatNaN(tSubtrahend.isNegative(), tSubtrahend.getType());
        }
        if (tSubtrahend.isInfinity()) {
            if (oSubtrahend.isInfinity() && tSubtrahend.isNegative() ^ oSubtrahend.isNegative()) {
                return new CFloatNaN(true, tSubtrahend.getType());
            }
            return new CFloatInf(tSubtrahend.isNegative(), tSubtrahend.getType());
        }
        if (oSubtrahend.isInfinity()) {
            return new CFloatInf(!oSubtrahend.isNegative(), tSubtrahend.getType());
        }
        long tExp = tSubtrahend.getExponent() & tSubtrahend.getExponentMask();
        long tMan = tSubtrahend.getMantissa();
        if (tExp != 0L) {
            tMan |= tSubtrahend.getNormalizationMask();
        }
        long oExp = oSubtrahend.getExponent() & tSubtrahend.getExponentMask();
        long oMan = oSubtrahend.getMantissa();
        if (oExp != 0L) {
            oMan |= tSubtrahend.getNormalizationMask();
        }
        boolean differentSign = tSubtrahend.isNegative() ^ oSubtrahend.isNegative();
        boolean oGTT = oSubtrahend.greaterThan(tSubtrahend);
        boolean bl = negResult = tSubtrahend.isNegative() && (differentSign || oGTT) || !tSubtrahend.isNegative() && !differentSign && oGTT;
        if (differentSign) {
            if (tSubtrahend.isNegative()) {
                tExp ^= tSubtrahend.getSignBitMask();
            }
            if (!oSubtrahend.isNegative()) {
                oExp ^= tSubtrahend.getSignBitMask();
            }
            CFloatImpl summandA = new CFloatImpl(new CFloatWrapper(tExp, tMan), tSubtrahend.getType());
            CFloatImpl summandB = new CFloatImpl(new CFloatWrapper(oExp, oMan), tSubtrahend.getType());
            return ((CFloat)summandA).add((CFloat)summandB);
        }
        CFloatWrapper resultWrapper = null;
        resultWrapper = tSubtrahend.isNegative() ? this.bitwiseSubtraction(negResult, oExp, oMan, tExp, tMan, tSubtrahend) : this.bitwiseSubtraction(negResult, tExp, tMan, oExp, oMan, tSubtrahend);
        return new CFloatImpl(resultWrapper, tSubtrahend.getType());
    }

    private CFloatWrapper bitwiseSubtraction(boolean pNegResult, long pExpMinuend, long pManMinuend, long pExpSubtrahend, long pManSubtrahend, CFloat pSubtrahend) {
        long manSubtrahendComplement = (pManSubtrahend ^ 0xFFFFFFFFFFFFFFFFL) + 1L;
        long diff = 0L;
        long overflow = 0L;
        long rExp = 0L;
        long rMan = 0L;
        if (pExpMinuend > pExpSubtrahend) {
            diff = pExpMinuend - pExpSubtrahend;
            rExp = pExpMinuend;
            overflow = manSubtrahendComplement << (int)(64L - diff);
            long complementedSubtrahend = manSubtrahendComplement;
            if (pSubtrahend.getType() == 2 && (complementedSubtrahend & pSubtrahend.getNormalizationMask()) == 0L) {
                --diff;
                complementedSubtrahend >>= 1;
                complementedSubtrahend |= pSubtrahend.getNormalizationMask();
            }
            rMan = pManMinuend + (complementedSubtrahend >>= (int)diff);
        } else {
            diff = pExpSubtrahend - pExpMinuend;
            rExp = pExpSubtrahend;
            overflow = pManMinuend << (int)(64L - diff);
            rMan = manSubtrahendComplement + (pManMinuend >>> (int)diff);
        }
        if (pNegResult) {
            rMan ^= 0xFFFFFFFFFFFFFFFFL;
            if (overflow != 0L) {
                overflow ^= 0xFFFFFFFFFFFFFFFFL;
                ++overflow;
            } else {
                ++rMan;
            }
        }
        while ((rMan & pSubtrahend.getNormalizationMask()) == 0L && rExp > 0L && (rMan & pSubtrahend.getMantissaMask()) != 0L) {
            rMan <<= 1;
            rMan += (overflow & CFloatNativeAPI.ONE_LONG_DOUBLE.getNormalizationMask()) != 0L ? 1L : 0L;
            overflow <<= 1;
            --rExp;
        }
        rMan &= pSubtrahend.getNormalizedMantissaMask();
        if (pNegResult) {
            rExp ^= pSubtrahend.getSignBitMask();
        }
        CFloatWrapper result = new CFloatWrapper(rExp, rMan);
        return pSubtrahend.round(result, overflow);
    }

    @Override
    public CFloat divideBy(CFloat pDivisor) {
        CFloat tDividend = this;
        CFloat oDivisor = pDivisor;
        boolean negativeResult = tDividend.isNegative() ^ oDivisor.isNegative();
        if (tDividend.getType() != oDivisor.getType()) {
            if (tDividend.getType() > oDivisor.getType()) {
                oDivisor = oDivisor.castTo(tDividend.getType());
            } else {
                tDividend = tDividend.castTo(oDivisor.getType());
            }
        }
        if (tDividend.isNan() || oDivisor.isNan()) {
            return new CFloatNaN(negativeResult, tDividend.getType());
        }
        if (oDivisor.isZero()) {
            if (tDividend.isZero()) {
                return new CFloatNaN(true, tDividend.getType());
            }
            return new CFloatInf(negativeResult, tDividend.getType());
        }
        if (tDividend.isZero()) {
            CFloatWrapper rWrapper = tDividend.copyWrapper();
            long signBit = negativeResult ? tDividend.getSignBitMask() : 0L;
            rWrapper.setExponent(rWrapper.getExponent() & tDividend.getExponentMask() ^ signBit);
            return new CFloatImpl(rWrapper, tDividend.getType());
        }
        long tMan = tDividend.getMantissa();
        long oMan = oDivisor.getMantissa();
        long tExp = tDividend.getExponent() & tDividend.getExponentMask();
        long oExp = oDivisor.getExponent() & tDividend.getExponentMask();
        long bias = tDividend.getBias();
        long rExp = tExp - oExp + bias ^ (negativeResult ? tDividend.getSignBitMask() : 0L);
        int quotientLength = tDividend.getMantissaLength() * 2;
        if (tDividend.getType() != 2) {
            quotientLength += 2;
            if (tExp != 0L) {
                tMan ^= tDividend.getNormalizationMask();
            }
            if (oExp != 0L) {
                oMan ^= tDividend.getNormalizationMask();
            }
        }
        int[] bitArray = new int[quotientLength];
        boolean adjustExp = this.divideBits(tMan, oMan, quotientLength, bitArray, tDividend);
        long rMan = 0L;
        long overflow = 0L;
        int index = 0;
        if (bitArray[index] == 0) {
            index = 1;
        }
        assert (bitArray[index] == 1);
        int count = quotientLength - 1;
        while (index < bitArray.length) {
            if (bitArray[index] == 1) {
                if (count >= quotientLength / 2) {
                    rMan ^= 1L << count - quotientLength / 2;
                } else {
                    overflow ^= 1L << 64 - quotientLength / 2 + count;
                }
            }
            ++index;
            --count;
        }
        rMan &= tDividend.getNormalizedMantissaMask();
        if (adjustExp) {
            --rExp;
        }
        CFloatWrapper rWrapper = new CFloatWrapper(rExp, rMan);
        rWrapper = tDividend.round(rWrapper, overflow);
        return new CFloatImpl(rWrapper, tDividend.getType());
    }

    private boolean divideBits(long pTMan, long pOMan, int pQuotientLength, int[] pBitArray, CFloat pDividend) {
        boolean initialOffsetNeeded = false;
        int[] dividArray = new int[pQuotientLength];
        int mantissaLength = pDividend.getNormalizedMantissaLength();
        long tMan = pTMan;
        long oMan = pOMan;
        int[] divisArray = this.createDivisorArray(pOMan);
        int[] divisArrayComplement = this.makeTwoComplement(divisArray);
        for (int i = 0; i < pQuotientLength / 2; ++i) {
            if ((1L << mantissaLength - i - 1 & tMan) != 0L) {
                dividArray[i] = 1;
            }
            if ((oMan & pDividend.getMantissaMask()) == 0L) continue;
            oMan <<= 1;
        }
        int offset = 0;
        int i = 0;
        while (i < pQuotientLength) {
            if (i == 0) {
                offset = this.divideStep(dividArray, divisArray, divisArrayComplement, offset);
                pBitArray[i] = 1;
                if (offset > 0) {
                    initialOffsetNeeded = true;
                }
            } else {
                int rO = this.divideStep(dividArray, divisArray, divisArrayComplement, offset);
                offset += rO;
                if ((i += rO) < pQuotientLength) {
                    pBitArray[i] = 1;
                }
            }
            ++i;
            ++offset;
        }
        return initialOffsetNeeded;
    }

    private int divideStep(int[] pDividend, int[] pDivisor, int[] pDivisorComplement, int pOffset) {
        assert (pDivisor.length == pDivisorComplement.length);
        assert (pDivisor.length < pDividend.length);
        int count = 0;
        for (int i = 0; i < pDivisor.length; ++i) {
            if (i == 0) {
                for (int j = 0; j < count + pOffset; ++j) {
                    if (pDividend[j] <= 0) continue;
                    this.offsetBitAddition(pDividend, pDivisorComplement, count + pOffset);
                    return count;
                }
            }
            if (i + count + pOffset >= pDividend.length || pDividend[i + count + pOffset] > pDivisor[i] || i == pDivisor.length - 1) {
                this.offsetBitAddition(pDividend, pDivisorComplement, count + pOffset);
                break;
            }
            if (pDividend[i + count + pOffset] >= pDivisor[i]) continue;
            i = -1;
            ++count;
        }
        return count;
    }

    private void offsetBitAddition(int[] pDividend, int[] pDivisorComplement, int pOffset) {
        if (pOffset >= pDividend.length) {
            return;
        }
        int offset = pOffset;
        int ignoreBits = 0;
        if (offset > pDivisorComplement.length) {
            ignoreBits = offset - pDivisorComplement.length;
            offset -= ignoreBits;
        }
        int carry = 0;
        for (int i = pDivisorComplement.length - 1; i >= -1 * offset; --i) {
            int n = i + offset;
            pDividend[n] = pDividend[n] + (i >= ignoreBits ? carry + pDivisorComplement[i - ignoreBits] : carry + 1);
            carry = pDividend[i + offset] / 2;
            int n2 = i + offset;
            pDividend[n2] = pDividend[n2] % 2;
        }
    }

    private int[] makeTwoComplement(int[] pDivisArray) {
        int[] complement = new int[pDivisArray.length];
        for (int i = 0; i < pDivisArray.length; ++i) {
            complement[i] = (pDivisArray[i] + 1) % 2;
        }
        int carry = 1;
        for (int i = complement.length - 1; i >= 0; --i) {
            complement[i] = (complement[i] + carry) % 2;
            if (complement[i] == 1) break;
        }
        return complement;
    }

    private int[] createDivisorArray(long pOMan) {
        int size = 0;
        for (int i = 0; i < 64; ++i) {
            if ((1L << i & pOMan) == 0L) continue;
            size = i + 1;
        }
        assert (size > 0);
        int[] bitArray = new int[size];
        int count = 0;
        boolean started = false;
        for (int i = 0; i < 64; ++i) {
            if ((pOMan & 1L << 63 - i) != 0L) {
                bitArray[count] = 1;
                started = true;
            }
            if (!started) continue;
            ++count;
        }
        return bitArray;
    }

    @Override
    public CFloat powTo(CFloat pExponent) {
        return null;
    }

    @Override
    public CFloat powToIntegral(int pExponent) {
        return null;
    }

    @Override
    public CFloat sqrt() {
        return null;
    }

    @Override
    public CFloat round() {
        long exp = this.wrapper.getExponent() & this.getExponentMask();
        long man = this.wrapper.getMantissa();
        long sign = this.isNegative() ? this.getSignBitMask() : 0L;
        int diff = (int)(exp - this.getBias());
        if (diff >= 0 && diff < this.getMantissaLength()) {
            long intMask = 0L;
            for (int i = this.getMantissaLength() - diff; i < this.getMantissaLength(); ++i) {
                intMask ^= 1L << i;
            }
            long fracMask = intMask ^ 0xFFFFFFFFFFFFFFFFL;
            long fractionalPart = man & fracMask;
            man &= intMask;
            long carryMask = intMask >> 1 & fractionalPart;
            if (carryMask != 0L && ((man += carryMask << 1) & intMask) == 0L) {
                ++exp;
            }
        } else if (diff < 0) {
            if (diff == -1) {
                ++exp;
                man = 0L;
            } else {
                exp = 0L;
                man = 0L;
            }
        }
        return new CFloatImpl(new CFloatWrapper((exp &= this.getExponentMask()) ^ sign, man &= this.getNormalizedMantissaMask()), this.type);
    }

    @Override
    public CFloat trunc() {
        long exp = this.wrapper.getExponent() & this.getExponentMask();
        long man = this.wrapper.getMantissa();
        long sign = this.isNegative() ? this.getSignBitMask() : 0L;
        int diff = (int)(exp - this.getBias());
        if (diff >= 0 && diff < this.getMantissaLength()) {
            long intMask = 0L;
            for (int i = this.getMantissaLength() - diff; i < this.getMantissaLength(); ++i) {
                intMask ^= 1L << i;
            }
            man &= intMask;
        } else if (diff < 0) {
            exp = 0L;
            man = 0L;
        }
        return new CFloatImpl(new CFloatWrapper(exp ^ sign, man), this.type);
    }

    @Override
    public CFloat ceil() {
        CFloat res = this.trunc();
        if (this.greaterThan(res)) {
            res.add((CFloat)new CFloatImpl("1", this.type));
        }
        return res;
    }

    @Override
    public CFloat floor() {
        CFloat res = this.trunc();
        if (res.greaterThan(this)) {
            res.add((CFloat)new CFloatImpl("-1", this.type));
        }
        return res;
    }

    @Override
    public CFloat abs() {
        CFloatWrapper wrap = this.copyWrapper();
        wrap.setExponent(wrap.getExponent() & this.getExponentMask());
        return new CFloatImpl(wrap, this.type);
    }

    @Override
    public boolean isZero() {
        boolean mantissaZero = (this.getNormalizedMantissaMask() & this.wrapper.getMantissa()) == 0L;
        boolean exponentZero = (this.wrapper.getExponent() & this.getExponentMask()) == 0L;
        return mantissaZero && (exponentZero || this.type == 2);
    }

    @Override
    public boolean isOne() {
        return (this.getBias() ^ this.wrapper.getExponent()) == 0L && (this.wrapper.getMantissa() ^ this.getNormalizedMantissaMask()) == this.getMantissaMask();
    }

    @Override
    public boolean isNegative() {
        return (this.wrapper.getExponent() & this.getSignBitMask()) != 0L;
    }

    @Override
    public CFloat copySignFrom(CFloat pSource) {
        CFloatWrapper wrap = this.copyWrapper();
        long tExp = wrap.getExponent();
        long oExp = pSource.getExponent();
        long tMask = this.getSignBitMask();
        long oMask = pSource.getSignBitMask();
        if ((oExp & oMask) == 0L) {
            if ((tExp & tMask) != 0L) {
                tExp ^= tMask;
            }
        } else if ((tExp & tMask) == 0L) {
            tExp ^= tMask;
        }
        wrap.setExponent(tExp);
        return new CFloatImpl(wrap, this.type);
    }

    @Override
    public CFloat castTo(int pToType) {
        CFloatImpl zero = new CFloatImpl("0", pToType);
        if (this.isZero()) {
            if (this.isNegative()) {
                return new CFloatImpl("-0", pToType);
            }
            return zero;
        }
        long rExp = this.wrapper.getExponent();
        long rMan = this.wrapper.getMantissa();
        long overflow = 0L;
        boolean signed = (rExp & this.getSignBitMask()) != 0L;
        long expDiff = (rExp & this.getExponentMask()) - this.getBias();
        int manDiff = this.getMantissaLength() - zero.getMantissaLength();
        manDiff *= manDiff < 0 ? -1 : 1;
        if (this.type == 2 && pToType != 2) {
            rMan &= this.getMantissaMask();
            --manDiff;
        } else if (this.type != 2 && pToType == 2) {
            rMan |= this.getNormalizationMask();
            --manDiff;
        }
        rExp = zero.getBias() + expDiff;
        if (signed) {
            rExp ^= zero.getSignBitMask();
        }
        if (this.type > pToType) {
            long overflowMask = (1L << manDiff) - 1L;
            overflow = (rMan & overflowMask) << 64 - manDiff;
            rMan >>>= manDiff;
        } else {
            rMan <<= manDiff;
        }
        CFloatWrapper rWrapper = new CFloatWrapper(rExp, rMan);
        rWrapper = zero.round(rWrapper, overflow);
        return new CFloatImpl(rWrapper, pToType);
    }

    @Override
    public Number castToOther(int pToType) {
        return null;
    }

    @Override
    public CFloatWrapper copyWrapper() {
        return this.wrapper.copy();
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean greaterThan(CFloat pFloat) {
        if (pFloat.isNan() || pFloat.isInfinity() && !pFloat.isNegative()) {
            return false;
        }
        CFloat oFloat = pFloat;
        CFloat tFloat = this;
        if (oFloat.getType() > tFloat.getType()) {
            tFloat = tFloat.castTo(oFloat.getType());
        } else if (tFloat.getType() > oFloat.getType()) {
            oFloat = oFloat.castTo(tFloat.getType());
        }
        int oType = oFloat.getType();
        boolean greater = false;
        boolean tNeg = tFloat.isNegative();
        boolean oNeg = oFloat.isNegative();
        long tExp = tFloat.getExponent();
        long tMan = tFloat.getMantissa();
        long oExp = oFloat.getExponent();
        long oMan = oFloat.getMantissa();
        if (oNeg) {
            if (tNeg) {
                if (tExp < oExp) {
                    greater = true;
                } else if (tExp == oExp) {
                    if (oType == 2) {
                        if ((tMan & tFloat.getNormalizationMask()) == 0L && (oMan & tFloat.getNormalizationMask()) != 0L) {
                            greater = true;
                        } else if (((tMan & tFloat.getNormalizationMask()) != 0L && (oMan & tFloat.getNormalizationMask()) != 0L || (tMan & tFloat.getNormalizationMask()) == 0L && (oMan & tFloat.getNormalizationMask()) == 0L) && (tMan & tFloat.getMantissaMask()) < (oMan & tFloat.getMantissaMask())) {
                            greater = true;
                        }
                    } else if (tMan < oMan) {
                        greater = true;
                    }
                }
            } else {
                greater = true;
            }
        } else if (!tNeg) {
            if (tExp > oExp) {
                greater = true;
            } else if (tExp == oExp) {
                if (oType == 2) {
                    if ((tMan & tFloat.getNormalizationMask()) != 0L && (oMan & tFloat.getNormalizationMask()) == 0L) {
                        greater = true;
                    } else if (((tMan & tFloat.getNormalizationMask()) != 0L && (oMan & tFloat.getNormalizationMask()) != 0L || (tMan & tFloat.getNormalizationMask()) == 0L && (oMan & tFloat.getNormalizationMask()) == 0L) && (tMan & tFloat.getMantissaMask()) > (oMan & tFloat.getMantissaMask())) {
                        greater = true;
                    }
                } else if (tMan > oMan) {
                    greater = true;
                }
            }
        }
        return greater;
    }

    public String toString() {
        long exp = this.wrapper.getExponent();
        long man = this.wrapper.getMantissa();
        StringBuilder builder = new StringBuilder();
        if ((exp & this.getSignBitMask()) != 0L) {
            builder.append("-");
        }
        int[] decArray = this.getDecimalArray(exp & this.getExponentMask(), man);
        boolean started = false;
        for (int i : decArray) {
            if (i < 0) {
                if (!started) {
                    builder.append("0");
                    started = true;
                }
                builder.append(".");
                continue;
            }
            if (!started && i <= 0) continue;
            builder.append(i);
            started = true;
        }
        return builder.toString().replaceAll("(\\.[0-9]+?)0*$", "$1");
    }

    private int[] getDecimalArray(long pExp, long pMan) {
        int i;
        long exp;
        int[] fracArray = CFloatUtil.getDecimalArray(this.type, pMan & 1L);
        for (int i2 = 1; i2 < this.getMantissaLength(); ++i2) {
            fracArray = this.decimalAdd(fracArray, CFloatUtil.getDecimalArray(this.type, pMan & 1L << i2));
        }
        int[] integralArray = new int[1];
        if (this.type != 2 && pExp != 0L || this.type == 2 && (pMan & this.getNormalizationMask()) != 0L) {
            integralArray[0] = 1;
        }
        if ((exp = pExp - this.getBias()) > 0L) {
            int startLength = fracArray.length;
            i = 0;
            while ((long)i < exp) {
                integralArray = this.decimalDouble(integralArray);
                if ((fracArray = this.decimalDouble(fracArray)).length > startLength) {
                    int iAL = integralArray.length;
                    int n = iAL - 1;
                    integralArray[n] = integralArray[n] + fracArray[0];
                    fracArray = this.copyAllButFirstCell(fracArray);
                    if (integralArray[iAL - 1] > 9) {
                        integralArray[iAL - 2] = integralArray[iAL - 1] / 10;
                        integralArray[iAL - 1] = integralArray[iAL - 1] % 10;
                    }
                }
                ++i;
            }
        } else {
            int i3 = 0;
            while ((long)i3 < -exp) {
                int last = fracArray[fracArray.length - 1];
                this.decimalHalf(fracArray);
                if (last % 2 != 0) {
                    fracArray = Arrays.copyOf(fracArray, fracArray.length + 1);
                    fracArray[fracArray.length - 1] = 5;
                }
                assert (integralArray.length == 1 && integralArray[0] <= 1) : "Exponent <= 0, but integral of mantissa larger than 1 - shouldn't be possible in IEEE 754";
                if (integralArray[0] == 1) {
                    integralArray = this.copyAllButFirstCell(integralArray);
                    int[] oneHalf = new int[fracArray.length];
                    oneHalf[0] = 5;
                    int startLength = fracArray.length;
                    fracArray = this.decimalAdd(fracArray, oneHalf);
                    assert (startLength == fracArray.length) : "overflow on (frac * 0.5 + 0.5) - shouldn't happen.";
                }
                ++i3;
            }
        }
        int[] result = new int[integralArray.length + fracArray.length + 1];
        for (i = 0; i < result.length; ++i) {
            result[i] = i < integralArray.length ? integralArray[i] : (i == integralArray.length ? -1 : fracArray[i - integralArray.length - 1]);
        }
        return result;
    }

    private int[] copyAllButFirstCell(int[] pArray) {
        return Arrays.copyOfRange(pArray, 1, pArray.length);
    }

    @Override
    protected CFloatWrapper getWrapper() {
        return this.wrapper;
    }
}

