/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.floatingpoint;

import com.google.common.primitives.Ints;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloat;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatNaN;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatWrapper;

public class CFloatInf
extends CFloat {
    private boolean negative;
    private final int type;

    public CFloatInf() {
        this(false, 0);
    }

    public CFloatInf(int type) {
        this(false, type);
    }

    public CFloatInf(boolean pNegative, int pType) {
        this.negative = pNegative;
        this.type = pType;
    }

    @Override
    public CFloat add(CFloat pSummand) {
        int maxType = Ints.max((int[])new int[]{this.type, pSummand.getType()});
        if (pSummand.isInfinity() && this.negative != pSummand.isNegative()) {
            return new CFloatNaN(true, maxType);
        }
        return new CFloatInf(this.negative, maxType);
    }

    @Override
    public CFloat add(CFloat ... pSummands) {
        int maxType = this.type;
        boolean nanResult = false;
        for (CFloat summand : pSummands) {
            maxType = Ints.max((int[])new int[]{maxType, summand.getType()});
            if (!summand.isInfinity() || this.negative == summand.isNegative()) continue;
            nanResult = true;
        }
        if (nanResult) {
            return new CFloatNaN(true, maxType);
        }
        return new CFloatInf(this.negative, maxType);
    }

    @Override
    public CFloat multiply(CFloat pFactor) {
        int maxType = Ints.max((int[])new int[]{this.type, pFactor.getType()});
        return new CFloatInf(this.negative, maxType);
    }

    @Override
    public CFloat multiply(CFloat ... pFactors) {
        int maxType = this.type;
        int sign = this.negative ? -1 : 1;
        for (CFloat factor : pFactors) {
            maxType = Ints.max((int[])new int[]{maxType, factor.getType()});
            sign *= factor.isNegative() ? -1 : 1;
        }
        return new CFloatInf(sign < 0, maxType);
    }

    @Override
    public CFloat subtract(CFloat pSubtrahend) {
        int maxType = Ints.max((int[])new int[]{this.type, pSubtrahend.getType()});
        if (pSubtrahend.isInfinity() && this.negative == pSubtrahend.isNegative()) {
            return new CFloatNaN(true, maxType);
        }
        return new CFloatInf(this.negative, maxType);
    }

    @Override
    public CFloat divideBy(CFloat pDivisor) {
        int maxType = Ints.max((int[])new int[]{this.type, pDivisor.getType()});
        int sign = (this.negative ? -1 : 1) * (pDivisor.isNegative() ? -1 : 1);
        return new CFloatInf(sign < 0, maxType);
    }

    @Override
    public CFloat powTo(CFloat pExponent) {
        return new CFloatInf(this.negative, this.type);
    }

    @Override
    public CFloat powToIntegral(int pExponent) {
        boolean neg = this.negative;
        if (this.negative && pExponent % 2 == 0) {
            neg = false;
        }
        return new CFloatInf(neg, this.type);
    }

    @Override
    public CFloat sqrt() {
        if (this.negative) {
            return new CFloatNaN(true, this.type);
        }
        return new CFloatInf(this.negative, this.type);
    }

    @Override
    public CFloat round() {
        return new CFloatInf(this.negative, this.type);
    }

    @Override
    public CFloat trunc() {
        return new CFloatInf(this.negative, this.type);
    }

    @Override
    public CFloat ceil() {
        return new CFloatInf(this.negative, this.type);
    }

    @Override
    public CFloat floor() {
        return new CFloatInf(this.negative, this.type);
    }

    @Override
    public CFloat abs() {
        return new CFloatInf(false, this.type);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public CFloat copySignFrom(CFloat pSource) {
        return new CFloatInf(pSource.isNegative(), this.type);
    }

    @Override
    public CFloat castTo(int pToType) {
        return new CFloatInf(this.negative, pToType);
    }

    @Override
    public Number castToOther(int pToType) {
        return null;
    }

    @Override
    public CFloatWrapper copyWrapper() {
        CFloatWrapper result = null;
        switch (this.type) {
            case 0: 
            case 1: {
                result = new CFloatWrapper(this.getExponentMask() ^ (this.negative ? this.getSignBitMask() : 0L), 0L);
                break;
            }
            case 2: {
                result = new CFloatWrapper(this.getExponentMask() ^ (this.negative ? this.getSignBitMask() : 0L), this.getNormalizationMask());
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.type);
            }
        }
        return result;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isInfinity() {
        return true;
    }

    public String toString() {
        return (this.negative ? "-" : "") + "inf";
    }

    @Override
    public boolean greaterThan(CFloat pFloat) {
        if (pFloat.isNan() || pFloat.isInfinity() && !pFloat.isNegative()) {
            return false;
        }
        return !this.isNegative();
    }

    @Override
    protected CFloatWrapper getWrapper() {
        return this.copyWrapper();
    }
}

