/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.floatingpoint;

import com.google.common.primitives.Ints;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloat;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatWrapper;

public class CFloatNaN
extends CFloat {
    private boolean negative;
    private final int type;

    public CFloatNaN() {
        this(false, 0);
    }

    public CFloatNaN(int pType) {
        this(false, pType);
    }

    public CFloatNaN(boolean pNegative, int pType) {
        this.negative = pNegative;
        this.type = pType;
    }

    @Override
    public CFloat add(CFloat pSummand) {
        int maxType = Ints.max((int[])new int[]{this.type, pSummand.getType()});
        return new CFloatNaN(this.negative, maxType);
    }

    @Override
    public CFloat add(CFloat ... pSummands) {
        int maxType = this.type;
        for (CFloat summand : pSummands) {
            maxType = Ints.max((int[])new int[]{maxType, summand.getType()});
        }
        return new CFloatNaN(this.negative, maxType);
    }

    @Override
    public CFloat multiply(CFloat pFactor) {
        int maxType = Ints.max((int[])new int[]{this.type, pFactor.getType()});
        return new CFloatNaN(this.negative, maxType);
    }

    @Override
    public CFloat multiply(CFloat ... pFactors) {
        int maxType = this.type;
        int sign = this.negative ? -1 : 1;
        for (CFloat factor : pFactors) {
            maxType = Ints.max((int[])new int[]{maxType, factor.getType()});
            sign *= factor.isNegative() ? -1 : 1;
        }
        return new CFloatNaN(sign < 0, maxType);
    }

    @Override
    public CFloat subtract(CFloat pSubtrahend) {
        int maxType = Ints.max((int[])new int[]{this.type, pSubtrahend.getType()});
        return new CFloatNaN(this.negative, maxType);
    }

    @Override
    public CFloat divideBy(CFloat pDivisor) {
        int maxType = Ints.max((int[])new int[]{this.type, pDivisor.getType()});
        int sign = (this.negative ? -1 : 1) * (pDivisor.isNegative() ? -1 : 1);
        return new CFloatNaN(sign < 0, maxType);
    }

    @Override
    public CFloat powTo(CFloat pExponent) {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat powToIntegral(int pExponent) {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat sqrt() {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat round() {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat trunc() {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat ceil() {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat floor() {
        return new CFloatNaN(this.negative, this.type);
    }

    @Override
    public CFloat abs() {
        return new CFloatNaN(false, this.type);
    }

    @Override
    public boolean isZero() {
        return false;
    }

    @Override
    public boolean isOne() {
        return false;
    }

    @Override
    public boolean isNegative() {
        return this.negative;
    }

    @Override
    public CFloat copySignFrom(CFloat pSource) {
        return new CFloatNaN(pSource.isNegative(), this.type);
    }

    @Override
    public CFloat castTo(int pToType) {
        return new CFloatNaN(this.negative, pToType);
    }

    @Override
    public Number castToOther(int pToType) {
        return null;
    }

    @Override
    public CFloatWrapper copyWrapper() {
        CFloatWrapper result = null;
        switch (this.type) {
            case 0: 
            case 1: {
                result = new CFloatWrapper(this.getExponentMask() ^ (this.negative ? this.getSignBitMask() : 0L), this.getNormalizationMask() >>> 1);
                break;
            }
            case 2: {
                result = new CFloatWrapper(this.getExponentMask() ^ (this.negative ? this.getSignBitMask() : 0L), this.getNormalizationMask() ^ this.getNormalizationMask() >>> 1);
                break;
            }
            default: {
                throw new RuntimeException("Unimplemented floating point type: " + this.type);
            }
        }
        return result;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isNan() {
        return true;
    }

    public String toString() {
        return (this.negative ? "-" : "") + "nan";
    }

    @Override
    public boolean greaterThan(CFloat pFloat) {
        return false;
    }

    @Override
    protected CFloatWrapper getWrapper() {
        return this.copyWrapper();
    }
}

