/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.floatingpoint;

import org.sosy_lab.common.NativeLibraries;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloat;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatImpl;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatWrapper;

public class CFloatNativeAPI {
    public static final CFloat ZERO_SINGLE;
    public static final CFloat ONE_SINGLE;
    public static final CFloat TEN_SINGLE;
    public static final CFloat ZERO_DOUBLE;
    public static final CFloat ONE_DOUBLE;
    public static final CFloat TEN_DOUBLE;
    public static final CFloat ZERO_LONG_DOUBLE;
    public static final CFloat ONE_LONG_DOUBLE;
    public static final CFloat TEN_LONG_DOUBLE;
    public static final int FP_TYPE_SINGLE = 0;
    public static final int FP_TYPE_DOUBLE = 1;
    public static final int FP_TYPE_LONG_DOUBLE = 2;
    public static final int TYPE_CHAR = 3;
    public static final int TYPE_SHORT = 4;
    public static final int TYPE_INT = 5;
    public static final int TYPE_LONG = 6;
    public static final int TYPE_LONG_LONG = 7;
    public static final int TYPE_UCHAR = 8;
    public static final int TYPE_USHORT = 9;
    public static final int TYPE_UINT = 10;
    public static final int TYPE_ULONG = 11;
    public static final int TYPE_ULONG_LONG = 12;

    private CFloatNativeAPI() {
    }

    public static native CFloatWrapper createFp(String var0, int var1);

    public static native String printFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper addFp(CFloatWrapper var0, int var1, CFloatWrapper var2, int var3);

    public static native CFloatWrapper subtractFp(CFloatWrapper var0, int var1, CFloatWrapper var2, int var3);

    public static native CFloatWrapper multiplyFp(CFloatWrapper var0, int var1, CFloatWrapper var2, int var3);

    public static native CFloatWrapper divideFp(CFloatWrapper var0, int var1, CFloatWrapper var2, int var3);

    public static native CFloatWrapper addManyFp(CFloatWrapper var0, int[] var1, CFloatWrapper ... var2);

    public static native CFloatWrapper multiplyManyFp(CFloatWrapper var0, int[] var1, CFloatWrapper ... var2);

    public static native CFloatWrapper powFp(CFloatWrapper var0, int var1, CFloatWrapper var2, int var3);

    public static native CFloatWrapper powIntegralFp(CFloatWrapper var0, int var1, int var2);

    public static native CFloatWrapper sqrtFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper roundFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper truncFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper ceilFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper floorFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper absFp(CFloatWrapper var0, int var1);

    public static native boolean isZeroFp(CFloatWrapper var0, int var1);

    public static native boolean isOneFp(CFloatWrapper var0, int var1);

    public static native boolean isNanFp(CFloatWrapper var0, int var1);

    public static native boolean isInfinityFp(CFloatWrapper var0, int var1);

    public static native boolean isNegativeFp(CFloatWrapper var0, int var1);

    public static native CFloatWrapper copySignFp(CFloatWrapper var0, CFloatWrapper var1, int var2);

    public static native CFloatWrapper castFpFromTo(CFloatWrapper var0, int var1, int var2);

    public static native CFloatWrapper castOtherToFp(Number var0, int var1, int var2);

    public static native Number castFpToOther(CFloatWrapper var0, int var1, int var2);

    static {
        NativeLibraries.loadLibrary((String)"FloatingPoints");
        ZERO_SINGLE = new CFloatImpl(CFloatNativeAPI.createFp("0.0", 0), 0);
        ONE_SINGLE = new CFloatImpl(CFloatNativeAPI.createFp("1.0", 0), 0);
        TEN_SINGLE = new CFloatImpl(CFloatNativeAPI.createFp("10.0", 0), 0);
        ZERO_DOUBLE = new CFloatImpl(CFloatNativeAPI.createFp("0.0", 1), 1);
        ONE_DOUBLE = new CFloatImpl(CFloatNativeAPI.createFp("1.0", 1), 1);
        TEN_DOUBLE = new CFloatImpl(CFloatNativeAPI.createFp("10.0", 1), 1);
        ZERO_LONG_DOUBLE = new CFloatImpl(CFloatNativeAPI.createFp("0.0", 2), 2);
        ONE_LONG_DOUBLE = new CFloatImpl(CFloatNativeAPI.createFp("1.0", 2), 2);
        TEN_LONG_DOUBLE = new CFloatImpl(CFloatNativeAPI.createFp("10.0", 2), 2);
    }

    public static enum CNativeType {
        SINGLE(0),
        DOUBLE(1),
        LONG_DOUBLE(2),
        CHAR(3),
        SHORT(4),
        INT(5),
        LONG(6),
        LONG_LONG(7),
        UCHAR(8),
        USHORT(9),
        UINT(10),
        ULONG(11),
        ULONG_LONG(12);

        private final int ordinal;

        private CNativeType(int pOrdinal) {
            this.ordinal = pOrdinal;
        }

        public int getOrdinal() {
            return this.ordinal;
        }
    }
}

