/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.floatingpoint;

import com.google.common.truth.Truth;
import org.junit.Ignore;
import org.junit.Test;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloat;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatImpl;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatNative;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatNativeAPI;
import org.sosy_lab.cpachecker.util.floatingpoint.CFloatWrapper;

public class CFloatTest {
    @Test
    public void infTest() {
        CFloatNative f_n1 = new CFloatNative("-1", 0);
        CFloatNative d_n0 = new CFloatNative("-0.0", 1);
        CFloatNative f_1 = new CFloatNative(CFloatNativeAPI.ONE_SINGLE.copyWrapper(), 0);
        CFloatNative d_1 = new CFloatNative(CFloatNativeAPI.ONE_DOUBLE.copyWrapper(), 1);
        CFloatNative ld_1 = new CFloatNative(CFloatNativeAPI.ONE_LONG_DOUBLE.copyWrapper(), 2);
        CFloatNative cf_f = new CFloatNative("0.0", 0);
        CFloatNative cf_d = new CFloatNative("0.0", 1);
        CFloatNative cf_ld = new CFloatNative("0.0", 2);
        Truth.assertThat((String)((CFloat)f_1).divideBy(cf_f).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)f_1).divideBy(cf_d).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)f_1).divideBy(cf_ld).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)d_1).divideBy(cf_f).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)d_1).divideBy(cf_d).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)d_1).divideBy(cf_ld).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)ld_1).divideBy(cf_f).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)ld_1).divideBy(cf_d).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)ld_1).divideBy(cf_ld).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)((CFloat)f_n1).divideBy(cf_f).toString()).isEqualTo((Object)"-inf");
        Truth.assertThat((String)((CFloat)f_n1).divideBy(cf_d).toString()).isEqualTo((Object)"-inf");
        Truth.assertThat((String)((CFloat)f_n1).divideBy(cf_ld).toString()).isEqualTo((Object)"-inf");
        Truth.assertThat((String)((CFloat)f_1).divideBy(d_n0).toString()).isEqualTo((Object)"-inf");
        Truth.assertThat((String)((CFloat)d_1).divideBy(d_n0).toString()).isEqualTo((Object)"-inf");
        Truth.assertThat((String)((CFloat)ld_1).divideBy(d_n0).toString()).isEqualTo((Object)"-inf");
        CFloat inf_f = ((CFloat)f_1).divideBy(cf_f);
        CFloat inf_nf = ((CFloat)f_n1).divideBy(cf_f);
        Truth.assertThat((String)inf_f.add(inf_f).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)inf_nf.add(inf_nf).toString()).isEqualTo((Object)"-inf");
        Truth.assertThat((String)inf_f.subtract(inf_nf).toString()).isEqualTo((Object)"inf");
        Truth.assertThat((String)inf_nf.subtract(inf_f).toString()).isEqualTo((Object)"-inf");
    }

    @Test
    public void nanTest() {
        CFloat cf_f = new CFloatNative("0.0", 0);
        CFloatNative cf_d = new CFloatNative("0.0", 1);
        CFloatNative cf_ld = new CFloatNative("0.0", 2);
        Truth.assertThat((String)cf_f.divideBy(cf_f).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)cf_f.divideBy(cf_d).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)cf_f.divideBy(cf_ld).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)((CFloat)cf_d).divideBy(cf_f).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)((CFloat)cf_d).divideBy(cf_d).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)((CFloat)cf_d).divideBy(cf_ld).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)((CFloat)cf_ld).divideBy(cf_f).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)((CFloat)cf_ld).divideBy(cf_d).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)((CFloat)cf_ld).divideBy(cf_ld).toString()).isEqualTo((Object)"-nan");
        CFloatNative f_1 = new CFloatNative(CFloatNativeAPI.ONE_SINGLE.copyWrapper(), 0);
        CFloatNative f_n1 = new CFloatNative("-1", 0);
        CFloat inf_f = ((CFloat)f_1).divideBy(cf_f);
        CFloat inf_nf = ((CFloat)f_n1).divideBy(cf_f);
        Truth.assertThat((String)inf_f.subtract(inf_f).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)inf_nf.subtract(inf_nf).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)inf_f.add(inf_nf).toString()).isEqualTo((Object)"-nan");
        Truth.assertThat((String)inf_nf.add(inf_f).toString()).isEqualTo((Object)"-nan");
        cf_f = cf_f.divideBy(cf_f);
        Truth.assertThat((String)cf_f.add((CFloat)f_1).toString()).isEqualTo((Object)"-nan");
    }

    @Test
    public void formatTest() {
        int i;
        CFloatNative cf_f = new CFloatNative("71236.262625", 0);
        CFloatNative cf_d = new CFloatNative("7891274812.82489681243896484375", 1);
        CFloat cf_ld = new CFloatNative("82173928379128.897125244140625", 2);
        CFloatNative cf_f2 = new CFloatNative("10.0", 0);
        Truth.assertThat((String)((Object)cf_f).toString()).isEqualTo((Object)"71236.265625");
        Truth.assertThat((String)((Object)cf_f2).toString()).isEqualTo((Object)"10.0");
        Truth.assertThat((String)((Object)cf_d).toString()).isEqualTo((Object)"7891274812.82489681243896484375");
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"82173928379128.897125244140625");
        CFloatNative two = new CFloatNative("2.0", 0);
        cf_ld = cf_ld.multiply((CFloat)two);
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"164347856758257.79425048828125");
        for (i = 0; i < 10; ++i) {
            cf_ld = cf_ld.multiply((CFloat)two);
        }
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"168292205320455981.3125");
        for (i = 0; i < 10; ++i) {
            cf_ld = cf_ld.multiply((CFloat)two);
        }
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"172331218248146924864.0");
        for (i = 0; i < 10; ++i) {
            cf_ld = cf_ld.multiply((CFloat)two);
        }
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"176467167486102451060736.0");
        for (i = 0; i < 800; ++i) {
            cf_ld = cf_ld.multiply((CFloat)two);
        }
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"1176685619726757694650973653036889804515652541394935327945104207967319975396405043723449926929245309944011749663826014608357167360348998884812228642560158430137541411941079758241360655682022168784213489289673637327812997677674819356237568534523669580117177832308736.0");
        for (i = 0; i < 15506; ++i) {
            cf_ld = cf_ld.multiply((CFloat)two);
        }
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"694661471029285501212945771332116283189597310134176279871043189542821592361034290078606668822051846516619797487990244598469777314072213775651740997048986477928169371715229655255359206162402789701556285027901731276951276932966299893756710604647716529685676844817520947850222003470298462271502609956078769849589900408767485724485967733599194870111268572665770915385732745533077935584814887246079891275768358592541249141208098888465601496657768977980719104688305805446337127467507655600805010440069686957667093439005930743710899465835693162496930922042219965565755872345088979745951059544410264590885533059802634911610112359072280643717850034447378889483354616356534072050883426144896485391839271548200637934784358423828361948121933169485446537718082323096878768326042779833555104832040698943211166866424754054058518687473286474067948292828214615505961268255909034200141046284021014576712140193597581626713649928012759984522574528083050285415720613046688185859795637548551514445633267671655826926175614480816809095786215643662930033739743457417532921030288466815508794482486385556026749829923189097288118396937096410891290928194250769813296387818031308061421013699955828562315519439982067347353925339756023987581503234833828283545902961339322113952589831569641527330790502240134789694938008747222640520135657293347309106779646491458431122937330634928614238016681904060576387983823642493996674208885147238684518016402962625484639057682915438581028172712163704500077695878867640029346320782445488797900101702716568106462610025654794142243666380061530725147800898964271744942918698143898638677164669373415496340898955825715641315678595790331151935905439190907272988737897140776341551472533780997375933937280166567585546743417096516847812195640709165790520762176180645358796498294497937404592297711082877765435291230286449583290834014773608422738804265973087281653073568570051219143973910598323202339617831684547261405588501034825543136062625740678347521636328626362325934600058707526730757605612347610346212727713445867537697290954889015840832006481552544354178598796024443289767222437288540384480913881790894681495830618486454777010193932844297424215592577430441244105631112284969397475586241350252719801955697719248263291576677400674564535012124466537817216674499601502843427706380322070207536266111849178732613493037133143914501656258394138427949341147498750043592117864861596291386955437525765875792978815200711703086031773265094062090433776474312925188037192978252390118103889764695250098400244382524632823218243298009716454263131170334953697375330234224834781529277158940732501033393627628292312518166039974135205583324016714039552252629662543435069986204212642024264748258088696773792510522901517507147404584504975919932787426188933702059345208175186414713367396753093710889099933396533310908624159283761910931570929031203239686518771465176191244443044838834439123817697621124371319307459407210656775350861659923351214137817620919405807574682209639907041498911534486791680147248174965353762937170834652169113699719970650209429514481731839607352056178750857322027687164428090119048609946821756584153887527951824142714772071015481449220282242859175402042471364900016874449405119766458202737518073575124390460229466164486486763731134790535338425159647362988989102415661368726931304389708098839253559241268159331162251596344133526786246671926477664370370204892975840991346964500139158435599256060845711019902324906317364112623636594144730900393698675674366435769737226028433017218491798546804160179402915827547646124889736393626326956158058847406745332212306275800009936633898125529945356843416313313501275104561978090672919846164480810915703489417353646940510996425915489531252616528416221473099427215939525288115469518510884813536389509309975809114935485012665444248884560381299604705974350152817929550833988410426558267784658496954992911562603970289791474655990552071036799681461338387116372476956571874717859729511104422791089338367448599166202680369739168769388326694208316406853213013832919099103563404858174925582486163566094997172082576169828886731599018830716649789663649445507892365369040297910847183802163649290889687899776076477303597955828244302748529695657718469885311506327204991597781008685208927343341458933797554504751392613129528016892940210384002022271833758521477022845254905080750452568603937516959398361005202759397145084274883419089761733733647216599798582928442438858339726851504835078826199077797972437788669165168797349587348145797789965900525131835010904232570351280328538495302926825096721212439857569699203144367206323634988578019367872848819173425685208948688233960869907377512223872994463655157441362032426157102214890200914510170508584825733648066487606047134622221180356046988009722071281017552038723432403711375708998205704619531394674018103728990824986210336710292853665742993819868990892512234593540492795363955983517552859998485133932437974378822687631687953586593586671266279562696266730495279104.0");
        cf_ld = cf_ld.multiply((CFloat)two);
        Truth.assertThat((String)cf_ld.toString()).isEqualTo((Object)"inf");
    }

    @Test
    public void zeroTest() {
        CFloatNative zero = new CFloatNative("0.0", 1);
        CFloatNative nZero = new CFloatNative("-0.0", 1);
        CFloatNative nOne = new CFloatNative("-1.0", 1);
        Truth.assertThat((String)zero.add((CFloat)nZero).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)nZero.add((CFloat)zero).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)nZero.add((CFloat)nZero).toString()).isEqualTo((Object)"-0.0");
        Truth.assertThat((String)nZero.subtract(zero).toString()).isEqualTo((Object)"-0.0");
        Truth.assertThat((String)zero.subtract(nZero).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)nZero.subtract(nZero).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)zero.subtract(zero).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)nOne.multiply((CFloat)zero).toString()).isEqualTo((Object)"-0.0");
        Truth.assertThat((String)nOne.multiply((CFloat)nZero).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)nZero.divideBy(nOne).toString()).isEqualTo((Object)"0.0");
        Truth.assertThat((String)zero.divideBy(nOne).toString()).isEqualTo((Object)"-0.0");
        Truth.assertThat((String)zero.multiply((CFloat)nZero).toString()).isEqualTo((Object)"-0.0");
    }

    @Test
    public void additionTest() {
        CFloatImpl ten = new CFloatImpl("10", 1);
        CFloatImpl five = new CFloatImpl("5", 0);
        CFloatImpl nOne = new CFloatImpl("-1", 2);
        CFloatNative p = new CFloatNative(((CFloat)ten).copyWrapper(), ((CFloat)ten).getType());
        CFloatNative q = new CFloatNative(((CFloat)five).copyWrapper(), ((CFloat)five).getType());
        Truth.assertThat((String)p.toString()).isEqualTo((Object)"10.0");
        Truth.assertThat((String)q.toString()).isEqualTo((Object)"5.0");
        CFloat res = ((CFloat)ten).add((CFloat)ten);
        p = new CFloatNative(res.copyWrapper(), 1);
        Truth.assertThat((String)p.toString()).isEqualTo((Object)"20.0");
        res = res.add(ten, ten, five);
        p = new CFloatNative(res.copyWrapper(), 1);
        Truth.assertThat((String)p.toString()).isEqualTo((Object)"45.0");
        res = res.add(nOne, nOne, nOne);
        p = new CFloatNative(res.copyWrapper(), 2);
        Truth.assertThat((String)p.toString()).isEqualTo((Object)"42.0");
    }

    @Test
    public void additionTest_With_Overflowing_Floats() {
        CFloatNative a = new CFloatNative("1.00000011920928955078125", 0);
        CFloatNative b = new CFloatNative("0.000000059604644775390625", 0);
        CFloatImpl aI = new CFloatImpl(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        CFloat bI = new CFloatImpl(((CFloat)b).copyWrapper(), ((CFloat)b).getType());
        CFloat resI = ((CFloat)aI).add(bI);
        CFloatNative res = new CFloatNative(resI.copyWrapper(), resI.getType());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)"1.0000002384185791015625");
        CFloatWrapper wrapper = ((CFloat)bI).copyWrapper();
        wrapper.setExponent(wrapper.getExponent() - 23L);
        CFloatImpl bIFractioned = new CFloatImpl(wrapper, ((CFloat)bI).getType());
        CFloatNative bFractioned = new CFloatNative(wrapper, ((CFloat)b).getType());
        CFloat resI2 = resI.add(((CFloat)bI).add((CFloat)bIFractioned));
        res = new CFloatNative(resI2.copyWrapper(), resI2.getType());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)"1.00000035762786865234375");
        wrapper.setExponent(wrapper.getExponent() - 1L);
        resI2 = resI.add(((CFloat)bI).add((CFloat)bIFractioned));
        res = new CFloatNative(resI2.copyWrapper(), resI2.getType());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)((CFloat)a).add(b, ((CFloat)b).add((CFloat)bFractioned)).toString());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)"1.0000002384185791015625");
        wrapper = ((CFloat)bI).copyWrapper();
        wrapper.setExponent(wrapper.getExponent() ^ bI.getSignBitMask());
        bI = new CFloatImpl(wrapper, ((CFloat)bI).getType());
        wrapper = ((CFloat)bI).copyWrapper();
        wrapper.setExponent(wrapper.getExponent() - 1L);
        CFloatImpl bI2 = new CFloatImpl(wrapper, ((CFloat)bI).getType());
        bI = ((CFloat)bI).add((CFloat)bI2);
        resI = ((CFloat)aI).add(bI);
        resI2 = ((CFloat)aI).add((CFloat)bI2);
        Truth.assertThat((String)new CFloatNative(resI.copyWrapper(), resI.getType()).toString()).isEqualTo((Object)"1.0");
        Truth.assertThat((String)new CFloatNative(resI2.copyWrapper(), resI2.getType()).toString()).isEqualTo((Object)"1.00000011920928955078125");
    }

    @Test
    public void additionTest_With_Overflowing_Doubles() {
        CFloatNative a = new CFloatNative("1.0000000000000002220446049250313080847263336181640625", 1);
        CFloatNative b = new CFloatNative("0.00000000000000011102230246251565404236316680908203125", 1);
        CFloatImpl aI = new CFloatImpl(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        CFloatImpl bI = new CFloatImpl(((CFloat)b).copyWrapper(), ((CFloat)b).getType());
        CFloat resI = ((CFloat)aI).add((CFloat)bI);
        CFloatNative res = new CFloatNative(resI.copyWrapper(), resI.getType());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)"1.000000000000000444089209850062616169452667236328125");
        CFloatWrapper wrapper = ((CFloat)bI).copyWrapper();
        wrapper.setExponent(wrapper.getExponent() - 52L);
        CFloatImpl bIFractioned = new CFloatImpl(wrapper, ((CFloat)bI).getType());
        CFloat resI2 = resI.add(((CFloat)bI).add((CFloat)bIFractioned));
        res = new CFloatNative(resI2.copyWrapper(), resI2.getType());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)"1.0000000000000006661338147750939242541790008544921875");
        wrapper.setExponent(wrapper.getExponent() - 1L);
        resI2 = resI.add(((CFloat)bI).add((CFloat)bIFractioned));
        res = new CFloatNative(resI2.copyWrapper(), resI2.getType());
        Truth.assertThat((String)((Object)res).toString()).isEqualTo((Object)"1.000000000000000444089209850062616169452667236328125");
    }

    @Test
    public void multiplicationTest() {
        CFloatImpl a = new CFloatImpl("2", 0);
        CFloatImpl b = new CFloatImpl("3", 0);
        CFloat res = ((CFloat)a).multiply((CFloat)b);
        CFloatNative cRes = new CFloatNative(res.copyWrapper(), res.getType());
        Truth.assertThat((String)((Object)cRes).toString()).isEqualTo((Object)"6.0");
        res = ((CFloat)b).multiply((CFloat)b);
        cRes = new CFloatNative(res.copyWrapper(), res.getType());
        Truth.assertThat((String)((Object)cRes).toString()).isEqualTo((Object)"9.0");
        res = ((CFloat)b).multiply((CFloat)b).multiply((CFloat)a).multiply((CFloat)b);
        cRes = new CFloatNative(res.copyWrapper(), res.getType());
        Truth.assertThat((String)((Object)cRes).toString()).isEqualTo((Object)"54.0");
        res = ((CFloat)b).multiply((CFloat)b).multiply((CFloat)a).multiply((CFloat)b).multiply((CFloat)b);
        cRes = new CFloatNative(res.copyWrapper(), res.getType());
        Truth.assertThat((String)((Object)cRes).toString()).isEqualTo((Object)"162.0");
    }

    @Test
    public void createTest() {
        CFloatImpl a = new CFloatImpl("12345.0", 1);
        CFloatNative test = new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        Truth.assertThat((String)((Object)test).toString()).isEqualTo((Object)"12345.0");
        CFloat b = new CFloatImpl("-2345.0", 1);
        test = new CFloatNative(b.copyWrapper(), b.getType());
        Truth.assertThat((String)((Object)test).toString()).isEqualTo((Object)"-2345.0");
        a = new CFloatImpl("1235124562371616235", 0);
        b = new CFloatNative("1235124562371616235", 0);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"1235124567312171008.0");
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)"1235124567312171008.0");
        a = new CFloatImpl("0.1235124562371616235", 0);
        b = new CFloatNative("0.1235124562371616235", 0);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"0.123512454330921173095703125");
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)"0.123512454330921173095703125");
        a = new CFloatImpl("8388609", 0);
        b = new CFloatNative("8388609", 0);
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)b.toString());
        a = new CFloatImpl("16777217", 0);
        b = new CFloatNative("16777217", 0);
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)b.toString());
        a = new CFloatImpl("36893488147419103233", 2);
        b = new CFloatNative("36893488147419103233", 2);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"36893488147419103232.0");
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)b.toString());
        a = new CFloatImpl("18446744073709551617", 2);
        b = new CFloatNative("18446744073709551617", 2);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"18446744073709551616.0");
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)b.toString());
        a = new CFloatImpl("36893488147419103235", 2);
        b = new CFloatNative("36893488147419103235", 2);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"36893488147419103236.0");
        Truth.assertThat((String)new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType()).toString()).isEqualTo((Object)b.toString());
    }

    @Test
    public void nativeAdditionTest() {
        CFloat a = new CFloatNative(new CFloatWrapper(17000L, -4611686018427387904L), 2);
        CFloat b = new CFloatNative(new CFloatWrapper(17063L, -4611686018427387904L), 2);
        Truth.assertThat((String)a.add(b).toString()).isEqualTo((Object)"7524684765169677984239668825841657450662424665126641865225532990851629461374682772298163028925468467204048782456979919923963285225557620642055414520570450567718506657241077846861357026497412026813181329408.0");
        b = new CFloatNative(new CFloatWrapper(17064L, -4611686018427387904L), 2);
        Truth.assertThat((String)a.add(b).toString()).isEqualTo((Object)"15049369530339355967391567042394575883208572683233827981680059276598297544036903949561899567255911541278292760274770262798041223663282407204681034557628156709126316397968184796941747610323938741049383452672.0");
        b = new CFloatNative(new CFloatWrapper(17065L, -4611686018427387904L), 2);
        Truth.assertThat((String)a.add(b).toString()).isEqualTo((Object)"30098739060678711932607592866211673730184592072428744465818105142986672330648884709054946153321772296296975911271161371496311753750899146250502480148230824565631238962908427800321562335306106856944808493056.0");
        a = new CFloatImpl(new CFloatWrapper(17000L, -4611686018427387904L), 2);
        b = new CFloatImpl(new CFloatWrapper(17063L, -4611686018427387904L), 2);
        Truth.assertThat((String)new CFloatNative(a.add(b).copyWrapper(), a.getType()).toString()).isEqualTo((Object)"7524684765169677984239668825841657450662424665126641865225532990851629461374682772298163028925468467204048782456979919923963285225557620642055414520570450567718506657241077846861357026497412026813181329408.0");
        b = new CFloatImpl(new CFloatWrapper(17064L, -4611686018427387904L), 2);
        Truth.assertThat((String)new CFloatNative(a.add(b).copyWrapper(), a.getType()).toString()).isEqualTo((Object)"15049369530339355967391567042394575883208572683233827981680059276598297544036903949561899567255911541278292760274770262798041223663282407204681034557628156709126316397968184796941747610323938741049383452672.0");
        b = new CFloatImpl(new CFloatWrapper(17065L, -4611686018427387904L), 2);
        Truth.assertThat((String)new CFloatNative(a.add(b).copyWrapper(), a.getType()).toString()).isEqualTo((Object)"30098739060678711932607592866211673730184592072428744465818105142986672330648884709054946153321772296296975911271161371496311753750899146250502480148230824565631238962908427800321562335306106856944808493056.0");
    }

    @Test
    public void maskTest() {
        Truth.assertThat((Integer)-1).isEqualTo((Object)-1L);
    }

    @Test
    public void subtractionOverflowTest() {
        CFloatWrapper wrapperA = new CFloatWrapper(127L, 0x200001L);
        CFloatWrapper wrapperB = new CFloatWrapper(125L, 2L);
        CFloatImpl aI = new CFloatImpl(wrapperA, 0);
        CFloatImpl bI = new CFloatImpl(wrapperB, ((CFloat)aI).getType());
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getMantissa()).isEqualTo((Object)0);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getMantissa()).isEqualTo((Object)0);
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getExponent()).isEqualTo((Object)127);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getExponent()).isEqualTo((Object)383);
        wrapperB.setMantissa(1L);
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getMantissa()).isEqualTo((Object)1);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getMantissa()).isEqualTo((Object)1);
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getExponent()).isEqualTo((Object)127);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getExponent()).isEqualTo((Object)383);
        wrapperA = new CFloatWrapper(127L, -6917529027641081855L);
        wrapperB = new CFloatWrapper(125L, -9223372036854775806L);
        aI = new CFloatImpl(wrapperA, 2);
        bI = new CFloatImpl(wrapperB, ((CFloat)aI).getType());
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getMantissa()).isEqualTo((Object)Long.MIN_VALUE);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getMantissa()).isEqualTo((Object)Long.MIN_VALUE);
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getExponent()).isEqualTo((Object)127);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getExponent()).isEqualTo((Object)32895);
        wrapperB.setMantissa(-9223372036854775807L);
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getMantissa()).isEqualTo((Object)-9223372036854775807L);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getMantissa()).isEqualTo((Object)-9223372036854775807L);
        Truth.assertThat((Long)((CFloat)aI).subtract(bI).copyWrapper().getExponent()).isEqualTo((Object)127);
        Truth.assertThat((Long)((CFloat)bI).subtract(aI).copyWrapper().getExponent()).isEqualTo((Object)32895);
        CFloatNative a = new CFloatNative("12345.03125", 2);
        CFloatNative b = new CFloatNative("0.0001220703125", 0);
        aI = new CFloatImpl(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        bI = new CFloatImpl(((CFloat)b).copyWrapper(), ((CFloat)b).getType());
        CFloat res = ((CFloat)aI).subtract(bI);
        Truth.assertThat((String)new CFloatNative(res.copyWrapper(), res.getType()).toString()).isEqualTo((Object)"12345.0311279296875");
        res = ((CFloat)bI).subtract(aI);
        Truth.assertThat((String)new CFloatNative(res.copyWrapper(), res.getType()).toString()).isEqualTo((Object)"-12345.0311279296875");
    }

    @Test
    public void isZeroTest() {
        CFloat a = new CFloatImpl("0.0", 0);
        CFloat b = new CFloatNative("0.0", 0);
        Truth.assertThat((Boolean)a.isZero()).isEqualTo((Object)b.isZero());
        CFloatImpl c = new CFloatImpl("-1.0", 0);
        Truth.assertThat((String)new CFloatNative(((CFloat)c).copyWrapper(), ((CFloat)c).getType()).toString()).isEqualTo((Object)"-1.0");
        a = a.multiply((CFloat)c);
        b = b.multiply((CFloat)c);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"-0.0");
        Truth.assertThat((Boolean)b.isNegative()).isTrue();
        Truth.assertThat((Boolean)a.isZero()).isEqualTo((Object)b.isZero());
        Truth.assertThat((Boolean)a.isNegative()).isEqualTo((Object)b.isNegative());
    }

    @Test
    public void divisionTest() {
        CFloatImpl a = new CFloatImpl("4", 1);
        CFloatImpl b = new CFloatImpl("2", 0);
        CFloat c = ((CFloat)a).divideBy(b).divideBy(a);
        c = new CFloatNative(((CFloat)a).divideBy(c).copyWrapper(), ((CFloat)a).getType());
        Truth.assertThat((String)c.toString()).isEqualTo((Object)"8.0");
        CFloatImpl d = new CFloatImpl("12.5625", 2);
        Truth.assertThat((String)new CFloatNative(((CFloat)d).copyWrapper(), ((CFloat)d).getType()).toString()).isEqualTo((Object)"12.5625");
    }

    @Test
    public void truncTest() {
        CFloat a = new CFloatImpl("-0.25", 0);
        CFloat b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"-0.25");
        a = a.trunc();
        b = b.trunc();
        Truth.assertThat((Boolean)a.isZero()).isTrue();
        Truth.assertThat((Boolean)b.isZero()).isTrue();
        Truth.assertThat((Boolean)a.isNegative()).isTrue();
        Truth.assertThat((Boolean)b.isNegative()).isTrue();
        Truth.assertThat((String)new CFloatNative(a.copyWrapper(), a.getType()).toString()).isEqualTo((Object)b.toString());
        a = new CFloatImpl("123.625", 1);
        b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"123.625");
        a = a.trunc();
        b = b.trunc();
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"123.0");
        Truth.assertThat((String)new CFloatNative(a.copyWrapper(), a.getType()).toString()).isEqualTo((Object)b.toString());
        a = new CFloatImpl("12345667", 1);
        b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"12345667.0");
        Truth.assertThat((String)new CFloatNative(a.copyWrapper(), a.getType()).toString()).isEqualTo((Object)b.toString());
    }

    @Test
    public void roundTest() {
        CFloat a = new CFloatImpl("2134.5625", 1);
        CFloat b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"2134.5625");
        a = a.round();
        b = b.round();
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"2135.0");
        Truth.assertThat((Long)a.copyWrapper().getExponent()).isEqualTo((Object)(b.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)a.copyWrapper().getMantissa()).isEqualTo((Object)(b.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
        a = new CFloatImpl("-2134.5625", 1);
        b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"-2134.5625");
        a = a.round();
        b = b.round();
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"-2135.0");
        Truth.assertThat((Long)a.copyWrapper().getExponent()).isEqualTo((Object)(b.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)a.copyWrapper().getMantissa()).isEqualTo((Object)(b.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
        a = new CFloatImpl("-2134.3125", 1);
        b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"-2134.3125");
        a = a.round();
        b = b.round();
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"-2134.0");
        Truth.assertThat((Long)a.copyWrapper().getExponent()).isEqualTo((Object)(b.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)a.copyWrapper().getMantissa()).isEqualTo((Object)(b.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
        a = new CFloatImpl("63.96875", 1);
        b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"63.96875");
        a = a.round();
        b = b.round();
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"64.0");
        Truth.assertThat((Long)a.copyWrapper().getExponent()).isEqualTo((Object)(b.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)a.copyWrapper().getMantissa()).isEqualTo((Object)(b.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
    }

    @Test
    public void divisionTest_2() {
        CFloatImpl a = new CFloatImpl("625", 1);
        CFloatImpl b = new CFloatImpl("1000", 1);
        CFloatNative c = new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        CFloatNative d = new CFloatNative(((CFloat)b).copyWrapper(), ((CFloat)b).getType());
        Truth.assertThat((String)((Object)c).toString()).isEqualTo((Object)"625.0");
        Truth.assertThat((String)((Object)d).toString()).isEqualTo((Object)"1000.0");
        CFloat e = ((CFloat)a).divideBy(b);
        CFloat f = ((CFloat)c).divideBy(d);
        Truth.assertThat((String)f.toString()).isEqualTo((Object)"0.625");
        Truth.assertThat((Long)e.copyWrapper().getExponent()).isEqualTo((Object)(f.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)e.copyWrapper().getMantissa()).isEqualTo((Object)(f.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
        a = new CFloatImpl("96875", 1);
        b = new CFloatImpl("100000", 1);
        CFloat one = new CFloatImpl("1", 1);
        c = new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        d = new CFloatNative(((CFloat)b).copyWrapper(), ((CFloat)b).getType());
        Truth.assertThat((String)((Object)c).toString()).isEqualTo((Object)"96875.0");
        Truth.assertThat((String)((Object)d).toString()).isEqualTo((Object)"100000.0");
        e = one.divideBy(((CFloat)b).divideBy(a));
        one = new CFloatNative(one.copyWrapper(), one.getType());
        f = one.divideBy(((CFloat)d).divideBy(c));
        Truth.assertThat((String)f.toString()).isEqualTo((Object)"0.96875");
        Truth.assertThat((Long)e.copyWrapper().getExponent()).isEqualTo((Object)(f.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)e.copyWrapper().getMantissa()).isEqualTo((Object)(f.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
        a = new CFloatImpl("87500", 1);
        b = new CFloatImpl("100000", 1);
        c = new CFloatNative(((CFloat)a).copyWrapper(), ((CFloat)a).getType());
        d = new CFloatNative(((CFloat)b).copyWrapper(), ((CFloat)b).getType());
        Truth.assertThat((String)((Object)c).toString()).isEqualTo((Object)"87500.0");
        Truth.assertThat((String)((Object)d).toString()).isEqualTo((Object)"100000.0");
        e = ((CFloat)a).divideBy(b);
        f = ((CFloat)c).divideBy(d);
        Truth.assertThat((String)f.toString()).isEqualTo((Object)"0.875");
        Truth.assertThat((Long)e.copyWrapper().getExponent()).isEqualTo((Object)(f.copyWrapper().getExponent() & (b.getExponentMask() ^ b.getSignBitMask())));
        Truth.assertThat((Long)e.copyWrapper().getMantissa()).isEqualTo((Object)(f.copyWrapper().getMantissa() & b.getNormalizedMantissaMask()));
    }

    @Test
    public void divisionTest_3() {
        CFloat one = CFloatNativeAPI.ONE_DOUBLE;
        CFloatNative nOne = new CFloatNative(one.copyWrapper(), one.getType());
        CFloat a = new CFloatImpl("123348857384573888", 1);
        CFloat b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"123348857384573888.0");
        a = one.divideBy(a);
        b = ((CFloat)nOne).divideBy(b);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"0.000000000000000008107087663424604897789104021903747826661400176467657530121613262963364832103252410888671875");
        Truth.assertThat((String)new CFloatNative(a.copyWrapper(), a.getType()).toString()).isEqualTo((Object)"0.000000000000000008107087663424604897789104021903747826661400176467657530121613262963364832103252410888671875");
        a = new CFloatImpl("123", 1);
        b = new CFloatNative(a.copyWrapper(), a.getType());
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"123.0");
        a = one.divideBy(a);
        b = ((CFloat)nOne).divideBy(b);
        Truth.assertThat((String)b.toString()).isEqualTo((Object)"0.00813008130081300899039131735435148584656417369842529296875");
        Truth.assertThat((String)new CFloatNative(a.copyWrapper(), a.getType()).toString()).isEqualTo((Object)b.toString());
    }

    @Test
    public void toStringTest() {
        CFloatImpl a = new CFloatImpl("2784365.34543", 0);
        CFloatNative b = new CFloatNative("2784365.34543", 0);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    public void toStringTest_floatValueWithLeadingZero() {
        CFloatImpl a = new CFloatImpl("0.6", 0);
        CFloatNative b = new CFloatNative("0.6", 0);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    public void toStringTest_negativeFloatValueWithLeadingZero() {
        CFloatImpl a = new CFloatImpl("-0.6", 0);
        CFloatNative b = new CFloatNative("-0.6", 0);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    @Ignore
    public void toStringTest_doubleValueWithLeadingZero() {
        CFloatImpl a = new CFloatImpl("0.6", 1);
        CFloatNative b = new CFloatNative("0.6", 1);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    @Ignore
    public void toStringTest_negativeDoubleValueWithLeadingZero() {
        CFloatImpl a = new CFloatImpl("-0.6", 1);
        CFloatNative b = new CFloatNative("-0.6", 1);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    @Ignore
    public void toStringTest_longDoubleValueWithLeadingZero() {
        CFloatImpl a = new CFloatImpl("0.6", 2);
        CFloatNative b = new CFloatNative("0.6", 2);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    @Ignore
    public void toStringTest_negativeLongDoubleValueWithLeadingZero() {
        CFloatImpl a = new CFloatImpl("-0.6", 2);
        CFloatNative b = new CFloatNative("-0.6", 2);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    public void toStringTest_floatValueWithZeroExponent() {
        CFloatImpl a = new CFloatImpl("1.000001", 0);
        CFloatNative b = new CFloatNative("1.000001", 0);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    public void toStringTest_doubleValueWithZeroExponent() {
        CFloatImpl a = new CFloatImpl("1.000001", 1);
        CFloatNative b = new CFloatNative("1.000001", 1);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    @Ignore
    public void toStringTest_longDoubleValueWithZeroExponent() {
        CFloatImpl a = new CFloatImpl("1.000001", 2);
        CFloatNative b = new CFloatNative("1.000001", 2);
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getExponent()).isEqualTo((Object)((CFloat)b).copyWrapper().getExponent());
        Truth.assertThat((Long)((CFloat)a).copyWrapper().getMantissa()).isEqualTo((Object)((CFloat)b).copyWrapper().getMantissa());
        Truth.assertThat((String)((Object)a).toString()).isEqualTo((Object)((Object)b).toString());
    }

    @Test
    public void castFloatToLongDoubleTest() {
        CFloat a = new CFloatImpl("893473.378465376", 0);
        CFloat b = new CFloatNative("893473.378465376", 0);
        Truth.assertThat((String)a.toString()).isEqualTo((Object)b.toString());
        a = a.castTo(2);
        b = b.castTo(2);
        Truth.assertThat((String)a.toString()).isEqualTo((Object)b.toString());
    }
}

