/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.globalinfo;

import com.google.common.collect.ImmutableMap;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.cfa.model.CFANode;
import org.sosy_lab.cpachecker.cpa.location.LocationStateFactory;

public class CFAInfo {
    private final ImmutableMap<Integer, CFANode> nodeNumberToNode;
    private LocationStateFactory locationStateFactory;

    CFAInfo(CFA cfa) {
        ImmutableMap.Builder nodeNumberToNode0 = ImmutableMap.builder();
        for (CFANode node : cfa.getAllNodes()) {
            nodeNumberToNode0.put((Object)node.getNodeNumber(), (Object)node);
        }
        this.nodeNumberToNode = nodeNumberToNode0.buildOrThrow();
    }

    public CFANode getNodeByNodeNumber(int nodeNumber) {
        return (CFANode)this.nodeNumberToNode.get((Object)nodeNumber);
    }

    public void storeLocationStateFactory(LocationStateFactory pElementFactory) {
        this.locationStateFactory = pElementFactory;
    }

    public LocationStateFactory getLocationStateFactory() {
        return this.locationStateFactory;
    }
}

