/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.globalinfo;

import com.google.common.base.Preconditions;
import java.util.Optional;
import org.sosy_lab.common.log.LogManager;
import org.sosy_lab.cpachecker.cfa.CFA;
import org.sosy_lab.cpachecker.core.interfaces.ConfigurableProgramAnalysis;
import org.sosy_lab.cpachecker.cpa.apron.ApronCPA;
import org.sosy_lab.cpachecker.cpa.assumptions.storage.AssumptionStorageCPA;
import org.sosy_lab.cpachecker.cpa.automaton.ControlAutomatonCPA;
import org.sosy_lab.cpachecker.cpa.predicate.PredicateCPA;
import org.sosy_lab.cpachecker.util.ApronManager;
import org.sosy_lab.cpachecker.util.CPAs;
import org.sosy_lab.cpachecker.util.globalinfo.AutomatonInfo;
import org.sosy_lab.cpachecker.util.globalinfo.CFAInfo;
import org.sosy_lab.cpachecker.util.predicates.AbstractionManager;
import org.sosy_lab.cpachecker.util.predicates.smt.FormulaManagerView;

public class GlobalInfo {
    private static GlobalInfo instance;
    private CFAInfo cfaInfo;
    private AutomatonInfo automatonInfo = new AutomatonInfo();
    private FormulaManagerView predicateFormulaManagerView;
    private FormulaManagerView assumptionFormulaManagerView;
    private AbstractionManager absManager;
    private ApronManager apronManager;
    private LogManager apronLogger;

    private GlobalInfo() {
    }

    public static synchronized GlobalInfo getInstance() {
        if (instance == null) {
            instance = new GlobalInfo();
        }
        return instance;
    }

    public synchronized void storeCFA(CFA cfa) {
        this.cfaInfo = new CFAInfo(cfa);
    }

    public synchronized Optional<CFAInfo> getCFAInfo() {
        return Optional.ofNullable(this.cfaInfo);
    }

    public synchronized void setUpInfoFromCPA(ConfigurableProgramAnalysis pCpa) {
        this.absManager = null;
        this.apronManager = null;
        this.apronLogger = null;
        if (pCpa != null) {
            for (ConfigurableProgramAnalysis c : CPAs.asIterable(pCpa)) {
                if (c instanceof ControlAutomatonCPA) {
                    ((ControlAutomatonCPA)c).registerInAutomatonInfo(this.automatonInfo);
                    continue;
                }
                if (c instanceof ApronCPA) {
                    Preconditions.checkState((this.apronManager == null && this.apronLogger == null ? 1 : 0) != 0);
                    ApronCPA apron = (ApronCPA)c;
                    this.apronManager = apron.getManager();
                    this.apronLogger = apron.getLogger();
                    continue;
                }
                if (c instanceof AssumptionStorageCPA) {
                    this.assumptionFormulaManagerView = ((AssumptionStorageCPA)c).getFormulaManager();
                    continue;
                }
                if (!(c instanceof PredicateCPA)) continue;
                Preconditions.checkState((this.absManager == null ? 1 : 0) != 0);
                this.absManager = ((PredicateCPA)c).getAbstractionManager();
                this.predicateFormulaManagerView = ((PredicateCPA)c).getSolver().getFormulaManager();
            }
        }
    }

    public synchronized AutomatonInfo getAutomatonInfo() {
        Preconditions.checkState((this.automatonInfo != null ? 1 : 0) != 0);
        return this.automatonInfo;
    }

    public synchronized FormulaManagerView getPredicateFormulaManagerView() {
        Preconditions.checkState((this.predicateFormulaManagerView != null ? 1 : 0) != 0);
        return this.predicateFormulaManagerView;
    }

    public synchronized AbstractionManager getAbstractionManager() {
        Preconditions.checkState((this.absManager != null ? 1 : 0) != 0);
        return this.absManager;
    }

    public synchronized ApronManager getApronManager() {
        return this.apronManager;
    }

    public synchronized LogManager getApronLogManager() {
        return this.apronLogger;
    }

    public synchronized FormulaManagerView getAssumptionStorageFormulaManager() {
        Preconditions.checkState((this.assumptionFormulaManagerView != null ? 1 : 0) != 0);
        return this.assumptionFormulaManagerView;
    }
}

