/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.graph.dominance;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.sosy_lab.common.collect.Collections3;
import org.sosy_lab.cpachecker.util.graph.dominance.DomInput;
import org.sosy_lab.cpachecker.util.graph.dominance.DomTree;

public final class DomFrontiers<T> {
    private final DomInput<T> input;
    private final ImmutableList<ImmutableSet<T>> frontiers;

    private DomFrontiers(DomInput<T> pInput, ImmutableList<ImmutableSet<T>> pFrontiers) {
        this.input = pInput;
        this.frontiers = pFrontiers;
    }

    public static <T> DomFrontiers<T> forDomTree(DomTree<T> pDomTree) {
        Preconditions.checkNotNull(pDomTree);
        return new DomFrontiers<T>(pDomTree.getInput(), DomFrontiers.computeFrontiers(pDomTree));
    }

    private static <T> ImmutableList<ImmutableSet<T>> computeFrontiers(DomTree<T> pDomTree) {
        DomInput domInput = pDomTree.getInput();
        DomInput.PredecessorDataIterator predecessorsDataIterator = domInput.iteratePredecessorData();
        ArrayList frontiers = new ArrayList(domInput.getNodeCount());
        for (int id = 0; id < domInput.getNodeCount(); ++id) {
            frontiers.add(new HashSet());
        }
        while (predecessorsDataIterator.hasNextNode()) {
            int nodeId = predecessorsDataIterator.nextNode();
            if (!predecessorsDataIterator.hasNextPredecessor()) continue;
            int runner = predecessorsDataIterator.nextPredecessor();
            if (!predecessorsDataIterator.hasNextPredecessor()) continue;
            while (true) {
                if (runner != -1 && runner != pDomTree.getParentId(nodeId)) {
                    ((Set)frontiers.get(runner)).add(nodeId);
                    runner = pDomTree.getParentId(runner);
                    continue;
                }
                runner = predecessorsDataIterator.hasNextPredecessor() ? predecessorsDataIterator.nextPredecessor() : -1;
                if (runner == -1) break;
            }
        }
        return Collections3.transformedImmutableListCopy(frontiers, frontier -> Collections3.transformedImmutableSetCopy((Collection)frontier, domInput::getNodeForReversePostOrderId));
    }

    public ImmutableSet<T> getFrontier(T pNode) {
        Preconditions.checkNotNull(pNode);
        @Nullable Integer id = this.input.getReversePostOrderId(pNode);
        Preconditions.checkArgument((id != null ? 1 : 0) != 0, (String)"unknown node: %s", pNode);
        return (ImmutableSet)this.frontiers.get(id.intValue());
    }

    public ImmutableSet<T> getIteratedFrontier(Set<T> pNodes) {
        Preconditions.checkNotNull(pNodes);
        HashSet iteratedFrontier = new HashSet();
        HashSet<Object> waitlisted = new HashSet<Object>();
        ArrayDeque<Object> waitlist = new ArrayDeque<Object>();
        for (T node : pNodes) {
            Preconditions.checkNotNull(node);
            @Nullable Integer id = this.input.getReversePostOrderId(node);
            Preconditions.checkArgument((id != null ? 1 : 0) != 0, (String)"pNodes contains a node that has no dominance frontier: %s", node);
            waitlist.add(node);
            waitlisted.add(node);
        }
        while (!waitlist.isEmpty()) {
            Object node = waitlist.remove();
            for (Object frontierNode : this.getFrontier(node)) {
                if (!iteratedFrontier.add(frontierNode) || !waitlisted.add(frontierNode)) continue;
                waitlist.add(frontierNode);
            }
        }
        return ImmutableSet.copyOf(iteratedFrontier);
    }

    public String toString() {
        return this.frontiers.toString();
    }
}

