/*
 * Decompiled with CFR 0.152.
 */
package org.sosy_lab.cpachecker.util.graph.dominance;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.graph.PredecessorsFunction;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.checkerframework.checker.nullness.qual.Nullable;

final class DomInput<T> {
    static final int START_NODE_ID = 0;
    private final ImmutableMap<T, Integer> ids;
    private final ImmutableList<T> nodes;
    private final int[][] predecessorData;

    private DomInput(Map<T, Integer> pIds, T[] pNodes, int[][] pPredecessorData) {
        this.ids = ImmutableMap.copyOf(pIds);
        this.nodes = ImmutableList.copyOf((Object[])pNodes);
        this.predecessorData = pPredecessorData;
    }

    private static <T> ImmutableMap<T, Integer> createReversePostOrder(SuccessorsFunction<T> pSuccessorsFunction, T pStartNode) {
        HashMap<Object, Integer> postOrderIds = new HashMap<Object, Integer>();
        Iterable nodesInPostOrder = Traverser.forGraph(pSuccessorsFunction).depthFirstPostOrder(pStartNode);
        int counter = 0;
        for (Object node2 : nodesInPostOrder) {
            postOrderIds.put(node2, counter);
            ++counter;
        }
        int offset = postOrderIds.size() - 1;
        postOrderIds.replaceAll((node, value) -> Math.abs(value - offset));
        return ImmutableMap.copyOf(postOrderIds);
    }

    static <T> DomInput<T> empty() {
        Object[] emptyNodesArray = new Object[]{};
        return new DomInput<Object>((Map<Object, Integer>)ImmutableMap.of(), (T[])emptyNodesArray, new int[0][]);
    }

    static <T> DomInput<T> forGraph(PredecessorsFunction<T> pPredecessorFunction, SuccessorsFunction<T> pSuccessorFunction, T pStartNode) {
        ImmutableMap<T, Integer> ids = DomInput.createReversePostOrder(pSuccessorFunction, pStartNode);
        assert ((Integer)ids.get(pStartNode) == 0);
        Object[] nodes = new Object[ids.size()];
        ArrayList<Object> allPredecessors = new ArrayList<Object>(Collections.nCopies(ids.size(), null));
        ArrayList<Integer> currentNodePredecessors = new ArrayList<Integer>();
        for (Map.Entry nodeToId : ids.entrySet()) {
            Object currentNode = nodeToId.getKey();
            int currentNodeId = (Integer)nodeToId.getValue();
            for (Object predecessor : pPredecessorFunction.predecessors(currentNode)) {
                @Nullable Integer predecessorId = (Integer)ids.get(predecessor);
                if (predecessorId == null) continue;
                currentNodePredecessors.add(predecessorId);
            }
            allPredecessors.set(currentNodeId, new ArrayList(currentNodePredecessors));
            nodes[currentNodeId] = currentNode;
            currentNodePredecessors.clear();
        }
        assert (ids.entrySet().stream().allMatch(entry -> entry.getKey().equals(nodes[(Integer)entry.getValue()])));
        int[][] predecessorData = new int[allPredecessors.size()][];
        for (int nodeId = 0; nodeId < allPredecessors.size(); ++nodeId) {
            List nodePredecessors = (List)allPredecessors.get(nodeId);
            predecessorData[nodeId] = nodePredecessors.stream().mapToInt(Integer::intValue).toArray();
        }
        return new DomInput<Object>((Map<Object, Integer>)ids, (T[])nodes, predecessorData);
    }

    @Nullable Integer getReversePostOrderId(T pNode) {
        return (Integer)this.ids.get(pNode);
    }

    T getNodeForReversePostOrderId(int pId) {
        return (T)this.nodes.get(pId);
    }

    PredecessorDataIterator iteratePredecessorData() {
        return new PredecessorDataIterator(this.predecessorData);
    }

    int getNodeCount() {
        return this.nodes.size();
    }

    static final class PredecessorDataIterator {
        private final int[][] predecessorData;
        private int nodeId;
        private int[] nodePredecessors;
        private int predecessorIndex;

        private PredecessorDataIterator(int[][] pPredecessorData) {
            this.predecessorData = pPredecessorData;
        }

        boolean hasNextNode() {
            return this.nodeId < this.predecessorData.length;
        }

        int nextNode() {
            if (!this.hasNextNode()) {
                throw new NoSuchElementException();
            }
            this.nodePredecessors = this.predecessorData[this.nodeId++];
            this.predecessorIndex = 0;
            return this.nodeId - 1;
        }

        boolean hasNextPredecessor() {
            return this.nodePredecessors != null && this.predecessorIndex < this.nodePredecessors.length;
        }

        int nextPredecessor() {
            if (!this.hasNextPredecessor()) {
                throw new NoSuchElementException();
            }
            return this.nodePredecessors[this.predecessorIndex++];
        }

        void reset() {
            this.nodeId = 0;
            this.nodePredecessors = null;
            this.predecessorIndex = 0;
        }
    }
}

